/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TSIG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ExtendedResolver
implements Resolver {
    private static final int quantum = 5;
    private List resolvers;
    private boolean loadBalance;
    private int lbStart;
    private int retries;

    private final void init() {
        this.resolvers = new ArrayList();
    }

    public void setPort(int n) {
        int n2 = 0;
        while (n2 < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(n2)).setPort(n);
            ++n2;
        }
    }

    public void setTCP(boolean bl) {
        int n = 0;
        while (n < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(n)).setTCP(bl);
            ++n;
        }
    }

    public void setIgnoreTruncation(boolean bl) {
        int n = 0;
        while (n < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(n)).setIgnoreTruncation(bl);
            ++n;
        }
    }

    public void setEDNS(int n) {
        int n2 = 0;
        while (n2 < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(n2)).setEDNS(n);
            ++n2;
        }
    }

    public void setTSIGKey(TSIG tSIG) {
        int n = 0;
        while (n < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(n)).setTSIGKey(tSIG);
            ++n;
        }
    }

    public void setTSIGKey(Name name, byte[] byArray) {
        this.setTSIGKey(new TSIG(name, byArray));
    }

    public void setTSIGKey(String string, String string2) {
        this.setTSIGKey(new TSIG(string, string2));
    }

    public void setTimeout(int n) {
        int n2 = 0;
        while (n2 < this.resolvers.size()) {
            ((Resolver)this.resolvers.get(n2)).setTimeout(n);
            ++n2;
        }
    }

    public Message send(Message message) throws IOException {
        Resolution resolution = new Resolution(this, message);
        return resolution.start();
    }

    public Object sendAsync(Message message, ResolverListener resolverListener) {
        Resolution resolution = new Resolution(this, message);
        resolution.startAsync(resolverListener);
        return resolution;
    }

    public Resolver getResolver(int n) {
        if (n < this.resolvers.size()) {
            return (Resolver)this.resolvers.get(n);
        }
        return null;
    }

    public Resolver[] getResolvers() {
        return (Resolver[])this.resolvers.toArray(new Resolver[this.resolvers.size()]);
    }

    public void addResolver(Resolver resolver) {
        this.resolvers.add(resolver);
    }

    public void deleteResolver(Resolver resolver) {
        this.resolvers.remove(resolver);
    }

    public void setLoadBalance(boolean bl) {
        this.loadBalance = bl;
    }

    public void setRetries(int n) {
        this.retries = n;
    }

    private final /* synthetic */ void this() {
        this.loadBalance = false;
        this.lbStart = 0;
        this.retries = 3;
    }

    public ExtendedResolver() throws UnknownHostException {
        this.this();
        this.init();
        String[] stringArray = ResolverConfig.getCurrentConfig().servers();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                SimpleResolver simpleResolver = new SimpleResolver(stringArray[n]);
                simpleResolver.setTimeout(5);
                this.resolvers.add(simpleResolver);
                ++n;
            }
        } else {
            this.resolvers.add(new SimpleResolver());
        }
    }

    public ExtendedResolver(String[] stringArray) throws UnknownHostException {
        this.this();
        this.init();
        int n = 0;
        while (n < stringArray.length) {
            SimpleResolver simpleResolver = new SimpleResolver(stringArray[n]);
            simpleResolver.setTimeout(5);
            this.resolvers.add(simpleResolver);
            ++n;
        }
    }

    public ExtendedResolver(Resolver[] resolverArray) throws UnknownHostException {
        this.this();
        this.init();
        int n = 0;
        while (n < resolverArray.length) {
            this.resolvers.add(resolverArray[n]);
            ++n;
        }
    }

    private static class Resolution
    implements ResolverListener {
        Resolver[] resolvers;
        int[] sent;
        Object[] inprogress;
        int retries;
        int outstanding;
        boolean done;
        Message query;
        Message response;
        Throwable thrown;
        ResolverListener listener;

        public void send(int n) {
            block2: {
                int n2 = n;
                this.sent[n2] = this.sent[n2] + 1;
                ++this.outstanding;
                try {
                    this.inprogress[n] = this.resolvers[n].sendAsync(this.query, this);
                }
                catch (Throwable throwable) {
                    this.thrown = throwable;
                    this.done = true;
                    if (this.listener != null) break block2;
                    this.notifyAll();
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Message start() throws IOException {
            block13: {
                try {
                    this.sent[0] = this.sent[0] + 1;
                    ++this.outstanding;
                    this.inprogress[0] = new Object();
                    return this.resolvers[0].send(this.query);
                }
                catch (Exception exception) {
                    this.handleException(this.inprogress[0], exception);
                    if (this.done) break block13;
                    Resolution resolution = this;
                    synchronized (resolution) {
                        while (!this.done) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }
            }
            if (this.response != null) {
                return this.response;
            }
            if (this.thrown instanceof IOException) {
                throw (IOException)this.thrown;
            }
            if (this.thrown instanceof RuntimeException) {
                throw (RuntimeException)this.thrown;
            }
            if (this.thrown instanceof Error) {
                throw (Error)this.thrown;
            }
            throw new IllegalStateException("ExtendedResolver failure");
        }

        public void startAsync(ResolverListener resolverListener) {
            this.listener = resolverListener;
            this.send(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void receiveMessage(Object object, Message message) {
            if (Options.check("verbose")) {
                System.err.println("ExtendedResolver: received message");
            }
            Resolution resolution = this;
            synchronized (resolution) {
                if (this.done) {
                    return;
                }
                this.response = message;
                this.done = true;
                if (this.listener == null) {
                    this.notifyAll();
                    return;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl16 : MonitorExitStatement: MONITOREXIT : var3_3
                this.listener.receiveMessage(this, this.response);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void handleException(Object object, Exception exception) {
            if (Options.check("verbose")) {
                System.err.println("ExtendedResolver: got " + exception);
            }
            Resolution resolution = this;
            // MONITORENTER : resolution
            --this.outstanding;
            if (this.done) {
                // MONITOREXIT : resolution
                return;
            }
            int n = 0;
            while (n < this.inprogress.length) {
                if (this.inprogress[n] == object) break;
                ++n;
            }
            if (n == this.inprogress.length) {
                // MONITOREXIT : resolution
                return;
            }
            boolean bl = false;
            boolean bl2 = false;
            if (this.sent[n] == 1 && n < this.resolvers.length - 1) {
                bl = true;
            }
            if (exception instanceof InterruptedIOException) {
                if (this.sent[n] < this.retries) {
                    this.send(n);
                }
                if (this.thrown == null) {
                    this.thrown = exception;
                }
            } else if (exception instanceof SocketException) {
                if (this.thrown == null || this.thrown instanceof InterruptedIOException) {
                    this.thrown = exception;
                }
            } else {
                this.thrown = exception;
            }
            if (this.done) {
                // MONITOREXIT : resolution
                return;
            }
            if (bl) {
                this.send(n + 1);
            }
            if (this.done) {
                // MONITOREXIT : resolution
                return;
            }
            if (this.outstanding == 0) {
                this.done = true;
                if (this.listener == null) {
                    this.notifyAll();
                    // MONITOREXIT : resolution
                    return;
                }
            }
            if (!this.done) {
                // MONITOREXIT : resolution
                return;
            }
            if (!(this.thrown instanceof Exception)) {
                this.thrown = new RuntimeException(this.thrown.getMessage());
            }
            this.listener.handleException(this, (Exception)this.thrown);
        }

        public Resolution(ExtendedResolver extendedResolver, Message message) {
            List list2 = extendedResolver.resolvers;
            this.resolvers = (Resolver[])list2.toArray(new Resolver[list2.size()]);
            if (extendedResolver.loadBalance) {
                int n = this.resolvers.length;
                ExtendedResolver extendedResolver2 = extendedResolver;
                int n2 = extendedResolver2.lbStart;
                extendedResolver2.lbStart = n2 + 1;
                int n3 = n2 % n;
                if (extendedResolver.lbStart > n) {
                    ExtendedResolver extendedResolver3 = extendedResolver;
                    extendedResolver3.lbStart = extendedResolver3.lbStart % n;
                }
                if (n3 > 0) {
                    Resolver[] resolverArray = new Resolver[n];
                    int n4 = 0;
                    while (n4 < n) {
                        int n5 = (n4 + n3) % n;
                        resolverArray[n4] = this.resolvers[n5];
                        ++n4;
                    }
                    this.resolvers = resolverArray;
                }
            }
            this.sent = new int[this.resolvers.length];
            this.inprogress = new Object[this.resolvers.length];
            this.retries = extendedResolver.retries;
            this.query = message;
        }
    }
}

