require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_ENDIAN_H_)) {
    eval 'sub _SYS_ENDIAN_H_ () {1;}' unless defined(&_SYS_ENDIAN_H_);
    require 'sys/featuretest.ph';
    eval 'sub _LITTLE_ENDIAN () {1234;}' unless defined(&_LITTLE_ENDIAN);
    eval 'sub _BIG_ENDIAN () {4321;}' unless defined(&_BIG_ENDIAN);
    eval 'sub _PDP_ENDIAN () {3412;}' unless defined(&_PDP_ENDIAN);
    if(defined(&_XOPEN_SOURCE) || defined(&_NETBSD_SOURCE)) {
	unless(defined(&_LOCORE)) {
	    require 'sys/ansi.ph';
	    require 'sys/cdefs.ph';
	    require 'sys/types.ph';
	    unless(defined(&in_addr_t)) {
		eval 'sub in_addr_t () { &__in_addr_t;}' unless defined(&in_addr_t);
	    }
	    unless(defined(&in_port_t)) {
		eval 'sub in_port_t () { &__in_port_t;}' unless defined(&in_port_t);
	    }
	}
    }
    require 'machine/endian_machdep.ph';
    if((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_LITTLE_ENDIAN) ? &_LITTLE_ENDIAN : undef)) {
	eval 'sub _QUAD_HIGHWORD () {1;}' unless defined(&_QUAD_HIGHWORD);
	eval 'sub _QUAD_LOWWORD () {0;}' unless defined(&_QUAD_LOWWORD);
    }
    if((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_BIG_ENDIAN) ? &_BIG_ENDIAN : undef)) {
	eval 'sub _QUAD_HIGHWORD () {0;}' unless defined(&_QUAD_HIGHWORD);
	eval 'sub _QUAD_LOWWORD () {1;}' unless defined(&_QUAD_LOWWORD);
    }
    if(defined(&_XOPEN_SOURCE) || defined(&_NETBSD_SOURCE)) {
	eval 'sub LITTLE_ENDIAN () {1234;}' unless defined(&LITTLE_ENDIAN);
	eval 'sub BIG_ENDIAN () {4321;}' unless defined(&BIG_ENDIAN);
	eval 'sub PDP_ENDIAN () {3412;}' unless defined(&PDP_ENDIAN);
	eval 'sub BYTE_ORDER () { &_BYTE_ORDER;}' unless defined(&BYTE_ORDER);
	unless(defined(&_LOCORE)) {
	    require 'machine/bswap.ph';
	    if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)  && !defined(&__lint__)) {
		eval 'sub ntohl {
		    my($x) = @_;
    		    eval q(($x));
		}' unless defined(&ntohl);
		eval 'sub ntohs {
		    my($x) = @_;
    		    eval q(($x));
		}' unless defined(&ntohs);
		eval 'sub htonl {
		    my($x) = @_;
    		    eval q(($x));
		}' unless defined(&htonl);
		eval 'sub htons {
		    my($x) = @_;
    		    eval q(($x));
		}' unless defined(&htons);
		eval 'sub NTOHL {
		    my($x) = @_;
    		    eval q(( &void) ($x));
		}' unless defined(&NTOHL);
		eval 'sub NTOHS {
		    my($x) = @_;
    		    eval q(( &void) ($x));
		}' unless defined(&NTOHS);
		eval 'sub HTONL {
		    my($x) = @_;
    		    eval q(( &void) ($x));
		}' unless defined(&HTONL);
		eval 'sub HTONS {
		    my($x) = @_;
    		    eval q(( &void) ($x));
		}' unless defined(&HTONS);
	    } else {
		eval 'sub ntohl {
		    my($x) = @_;
    		    eval q( &bswap32( &__CAST( &uint32_t, ($x))));
		}' unless defined(&ntohl);
		eval 'sub ntohs {
		    my($x) = @_;
    		    eval q( &bswap16( &__CAST( &uint16_t, ($x))));
		}' unless defined(&ntohs);
		eval 'sub htonl {
		    my($x) = @_;
    		    eval q( &bswap32( &__CAST( &uint32_t, ($x))));
		}' unless defined(&htonl);
		eval 'sub htons {
		    my($x) = @_;
    		    eval q( &bswap16( &__CAST( &uint16_t, ($x))));
		}' unless defined(&htons);
		eval 'sub NTOHL {
		    my($x) = @_;
    		    eval q(($x) =  &ntohl( &__CAST( &uint32_t, ($x))));
		}' unless defined(&NTOHL);
		eval 'sub NTOHS {
		    my($x) = @_;
    		    eval q(($x) =  &ntohs( &__CAST( &uint16_t, ($x))));
		}' unless defined(&NTOHS);
		eval 'sub HTONL {
		    my($x) = @_;
    		    eval q(($x) =  &htonl( &__CAST( &uint32_t, ($x))));
		}' unless defined(&HTONL);
		eval 'sub HTONS {
		    my($x) = @_;
    		    eval q(($x) =  &htons( &__CAST( &uint16_t, ($x))));
		}' unless defined(&HTONS);
	    }
	    if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
		eval 'sub htobe16 {
		    my($x) = @_;
    		    eval q(($x));
		}' unless defined(&htobe16);
		eval 'sub htobe32 {
		    my($x) = @_;
    		    eval q(($x));
		}' unless defined(&htobe32);
		eval 'sub htobe64 {
		    my($x) = @_;
    		    eval q(($x));
		}' unless defined(&htobe64);
		eval 'sub htole16 {
		    my($x) = @_;
    		    eval q( &bswap16( &__CAST( &uint16_t, ($x))));
		}' unless defined(&htole16);
		eval 'sub htole32 {
		    my($x) = @_;
    		    eval q( &bswap32( &__CAST( &uint32_t, ($x))));
		}' unless defined(&htole32);
		eval 'sub htole64 {
		    my($x) = @_;
    		    eval q( &bswap64( &__CAST( &uint64_t, ($x))));
		}' unless defined(&htole64);
		eval 'sub HTOBE16 {
		    my($x) = @_;
    		    eval q( &__CAST( &void, ($x)));
		}' unless defined(&HTOBE16);
		eval 'sub HTOBE32 {
		    my($x) = @_;
    		    eval q( &__CAST( &void, ($x)));
		}' unless defined(&HTOBE32);
		eval 'sub HTOBE64 {
		    my($x) = @_;
    		    eval q( &__CAST( &void, ($x)));
		}' unless defined(&HTOBE64);
		eval 'sub HTOLE16 {
		    my($x) = @_;
    		    eval q(($x) =  &bswap16( &__CAST( &uint16_t, ($x))));
		}' unless defined(&HTOLE16);
		eval 'sub HTOLE32 {
		    my($x) = @_;
    		    eval q(($x) =  &bswap32( &__CAST( &uint32_t, ($x))));
		}' unless defined(&HTOLE32);
		eval 'sub HTOLE64 {
		    my($x) = @_;
    		    eval q(($x) =  &bswap64( &__CAST( &uint64_t, ($x))));
		}' unless defined(&HTOLE64);
	    } else {
		eval 'sub htobe16 {
		    my($x) = @_;
    		    eval q( &bswap16( &__CAST( &uint16_t, ($x))));
		}' unless defined(&htobe16);
		eval 'sub htobe32 {
		    my($x) = @_;
    		    eval q( &bswap32( &__CAST( &uint32_t, ($x))));
		}' unless defined(&htobe32);
		eval 'sub htobe64 {
		    my($x) = @_;
    		    eval q( &bswap64( &__CAST( &uint64_t, ($x))));
		}' unless defined(&htobe64);
		eval 'sub htole16 {
		    my($x) = @_;
    		    eval q(($x));
		}' unless defined(&htole16);
		eval 'sub htole32 {
		    my($x) = @_;
    		    eval q(($x));
		}' unless defined(&htole32);
		eval 'sub htole64 {
		    my($x) = @_;
    		    eval q(($x));
		}' unless defined(&htole64);
		eval 'sub HTOBE16 {
		    my($x) = @_;
    		    eval q(($x) =  &bswap16( &__CAST( &uint16_t, ($x))));
		}' unless defined(&HTOBE16);
		eval 'sub HTOBE32 {
		    my($x) = @_;
    		    eval q(($x) =  &bswap32( &__CAST( &uint32_t, ($x))));
		}' unless defined(&HTOBE32);
		eval 'sub HTOBE64 {
		    my($x) = @_;
    		    eval q(($x) =  &bswap64( &__CAST( &uint64_t, ($x))));
		}' unless defined(&HTOBE64);
		eval 'sub HTOLE16 {
		    my($x) = @_;
    		    eval q( &__CAST( &void, ($x)));
		}' unless defined(&HTOLE16);
		eval 'sub HTOLE32 {
		    my($x) = @_;
    		    eval q( &__CAST( &void, ($x)));
		}' unless defined(&HTOLE32);
		eval 'sub HTOLE64 {
		    my($x) = @_;
    		    eval q( &__CAST( &void, ($x)));
		}' unless defined(&HTOLE64);
	    }
	    eval 'sub be16toh {
	        my($x) = @_;
    		eval q( &htobe16($x));
	    }' unless defined(&be16toh);
	    eval 'sub be32toh {
	        my($x) = @_;
    		eval q( &htobe32($x));
	    }' unless defined(&be32toh);
	    eval 'sub be64toh {
	        my($x) = @_;
    		eval q( &htobe64($x));
	    }' unless defined(&be64toh);
	    eval 'sub le16toh {
	        my($x) = @_;
    		eval q( &htole16($x));
	    }' unless defined(&le16toh);
	    eval 'sub le32toh {
	        my($x) = @_;
    		eval q( &htole32($x));
	    }' unless defined(&le32toh);
	    eval 'sub le64toh {
	        my($x) = @_;
    		eval q( &htole64($x));
	    }' unless defined(&le64toh);
	    eval 'sub BE16TOH {
	        my($x) = @_;
    		eval q( &HTOBE16($x));
	    }' unless defined(&BE16TOH);
	    eval 'sub BE32TOH {
	        my($x) = @_;
    		eval q( &HTOBE32($x));
	    }' unless defined(&BE32TOH);
	    eval 'sub BE64TOH {
	        my($x) = @_;
    		eval q( &HTOBE64($x));
	    }' unless defined(&BE64TOH);
	    eval 'sub LE16TOH {
	        my($x) = @_;
    		eval q( &HTOLE16($x));
	    }' unless defined(&LE16TOH);
	    eval 'sub LE32TOH {
	        my($x) = @_;
    		eval q( &HTOLE32($x));
	    }' unless defined(&LE32TOH);
	    eval 'sub LE64TOH {
	        my($x) = @_;
    		eval q( &HTOLE64($x));
	    }' unless defined(&LE64TOH);
	    if( &__GNUC_PREREQ__(2, 95)) {
		eval 'sub __GEN_ENDIAN_ENC {
		    my($bits, $endian) = @_;
    		    eval q( &static  &__inline  &void  &__unused $endian  $bits   &enc( &void * &dst, \'uint\'  $bits   &_t  &u) {  &u =  &hto  $endian  $bits ( &u);  &__builtin_memcpy( &dst,  &u, $sizeof{ &u}); });
		}' unless defined(&__GEN_ENDIAN_ENC);
		undef(&__GEN_ENDIAN_ENC) if defined(&__GEN_ENDIAN_ENC);
		eval 'sub __GEN_ENDIAN_DEC {
		    my($bits, $endian) = @_;
    		    eval q( &static  &__inline \'uint\'  $bits   &_t  &__unused $endian  $bits   &dec( &const  &void * &buf) { \'uint\'  $bits   &_t  &u;  &__builtin_memcpy( &u,  &buf, $sizeof{ &u});  &return $endian  $bits   &toh ( &u); });
		}' unless defined(&__GEN_ENDIAN_DEC);
		undef(&__GEN_ENDIAN_DEC) if defined(&__GEN_ENDIAN_DEC);
	    } else {
		eval 'sub be16enc {
		    my($buf,$u) = @_;
    		    eval q({  &uint8_t * &p =  &__CAST( &uint8_t *, $buf);  $p[0] =  &__CAST( &uint8_t, (( &__CAST(\'unsigned\', $u) >> 8) & 0xff));  $p[1] =  &__CAST( &uint8_t, ($u & 0xff)); });
		}' unless defined(&be16enc);
		eval 'sub le16enc {
		    my($buf,$u) = @_;
    		    eval q({  &uint8_t * &p =  &__CAST( &uint8_t *, $buf);  $p[0] =  &__CAST( &uint8_t, ($u & 0xff));  $p[1] =  &__CAST( &uint8_t, (( &__CAST(\'unsigned\', $u) >> 8) & 0xff)); });
		}' unless defined(&le16enc);
		eval 'sub be16dec {
		    my($buf) = @_;
    		    eval q({  &const  &uint8_t * &p =  &__CAST( &const  &uint8_t *, $buf); (( &__CAST( &uint16_t,  $p[0]) << 8) |  $p[1]); });
		}' unless defined(&be16dec);
		eval 'sub le16dec {
		    my($buf) = @_;
    		    eval q({  &const  &uint8_t * &p =  &__CAST( &const  &uint8_t *, $buf); ( $p[0] | ( &__CAST( &uint16_t,  $p[1]) << 8)); });
		}' unless defined(&le16dec);
		eval 'sub be32enc {
		    my($buf,$u) = @_;
    		    eval q({  &uint8_t * &p =  &__CAST( &uint8_t *, $buf);  $p[0] =  &__CAST( &uint8_t, (($u >> 24) & 0xff));  $p[1] =  &__CAST( &uint8_t, (($u >> 16) & 0xff));  $p[2] =  &__CAST( &uint8_t, (($u >> 8) & 0xff));  $p[3] =  &__CAST( &uint8_t, ($u & 0xff)); });
		}' unless defined(&be32enc);
		eval 'sub le32enc {
		    my($buf,$u) = @_;
    		    eval q({  &uint8_t * &p =  &__CAST( &uint8_t *, $buf);  $p[0] =  &__CAST( &uint8_t, ($u & 0xff));  $p[1] =  &__CAST( &uint8_t, (($u >> 8) & 0xff));  $p[2] =  &__CAST( &uint8_t, (($u >> 16) & 0xff));  $p[3] =  &__CAST( &uint8_t, (($u >> 24) & 0xff)); });
		}' unless defined(&le32enc);
		eval 'sub be32dec {
		    my($buf) = @_;
    		    eval q({  &const  &uint8_t * &p =  &__CAST( &const  &uint8_t *, $buf); (( &__CAST( &uint32_t,  &be16dec( &p)) << 16) |  &be16dec( &p + 2)); });
		}' unless defined(&be32dec);
		eval 'sub le32dec {
		    my($buf) = @_;
    		    eval q({  &const  &uint8_t * &p =  &__CAST( &const  &uint8_t *, $buf); ( &le16dec( &p) | ( &__CAST( &uint32_t,  &le16dec( &p + 2)) << 16)); });
		}' unless defined(&le32dec);
		eval 'sub be64enc {
		    my($buf,$u) = @_;
    		    eval q({  &uint8_t * &p =  &__CAST( &uint8_t *, $buf);  &be32enc( &p,  &__CAST( &uint32_t, ($u >> 32)));  &be32enc( &p + 4,  &__CAST( &uint32_t, ($u & 0xffffffff))); });
		}' unless defined(&be64enc);
		eval 'sub le64enc {
		    my($buf,$u) = @_;
    		    eval q({  &uint8_t * &p =  &__CAST( &uint8_t *, $buf);  &le32enc( &p,  &__CAST( &uint32_t, ($u & 0xffffffff)));  &le32enc( &p + 4,  &__CAST( &uint32_t, ($u >> 32))); });
		}' unless defined(&le64enc);
		eval 'sub be64dec {
		    my($buf) = @_;
    		    eval q({  &const  &uint8_t * &p = ( &const  &uint8_t *)$buf; (( &__CAST( &uint64_t,  &be32dec( &p)) << 32) |  &be32dec( &p + 4)); });
		}' unless defined(&be64dec);
		eval 'sub le64dec {
		    my($buf) = @_;
    		    eval q({  &const  &uint8_t * &p = ( &const  &uint8_t *)$buf; ( &le32dec( &p) | ( &__CAST( &uint64_t,  &le32dec( &p + 4)) << 32)); });
		}' unless defined(&le64dec);
	    }
	}
    }
}
1;
