require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_UVM_UVM_PAGE_H_)) {
    eval 'sub _UVM_UVM_PAGE_H_ () {1;}' unless defined(&_UVM_UVM_PAGE_H_);
    if(defined(&_KERNEL_OPT)) {
	require './uvm/opt_uvm_page_trkown.ph';
    }
    require 'sys/rwlock.ph';
    require 'uvm/uvm_extern.ph';
    require 'uvm/uvm_pglist.ph';
    if(defined(&__HAVE_VM_PAGE_MD)) {
    }
    if(defined(&UVM_PAGE_TRKOWN)) {
    }
    eval 'sub PG_CLEAN () {0x1;}' unless defined(&PG_CLEAN);
    eval 'sub PG_DIRTY () {0x2;}' unless defined(&PG_DIRTY);
    eval 'sub PG_BUSY () {0x4;}' unless defined(&PG_BUSY);
    eval 'sub PG_PAGEOUT () {0x10;}' unless defined(&PG_PAGEOUT);
    eval 'sub PG_RELEASED () {0x20;}' unless defined(&PG_RELEASED);
    eval 'sub PG_FAKE () {0x40;}' unless defined(&PG_FAKE);
    eval 'sub PG_RDONLY () {0x80;}' unless defined(&PG_RDONLY);
    eval 'sub PG_TABLED () {0x200;}' unless defined(&PG_TABLED);
    eval 'sub PG_AOBJ () {0x400;}' unless defined(&PG_AOBJ);
    eval 'sub PG_ANON () {0x800;}' unless defined(&PG_ANON);
    eval 'sub PG_FILE () {0x1000;}' unless defined(&PG_FILE);
    eval 'sub PG_READAHEAD () {0x2000;}' unless defined(&PG_READAHEAD);
    eval 'sub PG_FREE () {0x4000;}' unless defined(&PG_FREE);
    eval 'sub PG_MARKER () {0x8000;}' unless defined(&PG_MARKER);
    eval 'sub PG_PAGER1 () {0x10000;}' unless defined(&PG_PAGER1);
    eval 'sub PG_PGLCA () {0x20000;}' unless defined(&PG_PGLCA);
    eval 'sub PG_STAT () {( &PG_ANON| &PG_AOBJ| &PG_FILE);}' unless defined(&PG_STAT);
    eval 'sub PG_SWAPBACKED () {( &PG_ANON| &PG_AOBJ);}' unless defined(&PG_SWAPBACKED);
    eval 'sub UVM_PGFLAGBITS () {"\\20\\1CLEAN\\2DIRTY\\3BUSY" "\\5PAGEOUT\\6RELEASED\\7FAKE\\10RDONLY" "\\11ZERO\\12TABLED\\13AOBJ\\14ANON" "\\15FILE\\16READAHEAD\\17FREE\\20MARKER" "\\21PAGER1\\22PGLCA";}' unless defined(&UVM_PGFLAGBITS);
    eval 'sub PQ_INTENT_A () {0x;}' unless defined(&PQ_INTENT_A);
    eval 'sub PQ_INTENT_I () {0x1;}' unless defined(&PQ_INTENT_I);
    eval 'sub PQ_INTENT_E () {0x2;}' unless defined(&PQ_INTENT_E);
    eval 'sub PQ_INTENT_D () {0x3;}' unless defined(&PQ_INTENT_D);
    eval 'sub PQ_INTENT_MASK () {0x3;}' unless defined(&PQ_INTENT_MASK);
    eval 'sub PQ_INTENT_SET () {0x4;}' unless defined(&PQ_INTENT_SET);
    eval 'sub PQ_INTENT_QUEUED () {0x8;}' unless defined(&PQ_INTENT_QUEUED);
    eval 'sub PQ_PRIVATE () {0xff0;}' unless defined(&PQ_PRIVATE);
    eval 'sub PQ_WANTED () {0x1000;}' unless defined(&PQ_WANTED);
    eval 'sub UVM_PQFLAGBITS () {"\\20\\1INTENT_0\\2INTENT_1\\3INTENT_SET\\4INTENT_QUEUED" "\\5PRIVATE1\\6PRIVATE2\\7PRIVATE3\\10PRIVATE4" "\\11PRIVATE5\\12PRIVATE6\\13PRIVATE7\\14PRIVATE8" "\\15WANTED";}' unless defined(&UVM_PQFLAGBITS);
    eval 'sub VM_PSTRAT_RANDOM () {1;}' unless defined(&VM_PSTRAT_RANDOM);
    eval 'sub VM_PSTRAT_BSEARCH () {2;}' unless defined(&VM_PSTRAT_BSEARCH);
    eval 'sub VM_PSTRAT_BIGFIRST () {3;}' unless defined(&VM_PSTRAT_BIGFIRST);
    if(defined(&_KERNEL)) {
	if(defined(&UVM_PAGE_TRKOWN)) {
	}
	if(!defined(&PMAP_STEAL_MEMORY)) {
	}
	if(defined(&PMAP_DIRECT)) {
	}
	eval 'sub UVM_PAGE_STATUS_UNKNOWN () {0;}' unless defined(&UVM_PAGE_STATUS_UNKNOWN);
	eval 'sub UVM_PAGE_STATUS_CLEAN () {1;}' unless defined(&UVM_PAGE_STATUS_CLEAN);
	eval 'sub UVM_PAGE_STATUS_DIRTY () {2;}' unless defined(&UVM_PAGE_STATUS_DIRTY);
	eval 'sub UVM_PAGE_NUM_STATUS () {3;}' unless defined(&UVM_PAGE_NUM_STATUS);
	eval 'sub VM_PAGE_TO_PHYS {
	    my($entry) = @_;
    	    eval q( &uvm_vm_page_to_phys($entry));
	}' unless defined(&VM_PAGE_TO_PHYS);
	if(defined(&__HAVE_VM_PAGE_MD)) {
	    eval 'sub VM_PAGE_TO_MD {
	        my($pg) = @_;
    		eval q((($pg)-> &mdpage));
	    }' unless defined(&VM_PAGE_TO_MD);
	    eval 'sub VM_MD_TO_PAGE {
	        my($md) = @_;
    		eval q(( &container_of(($md), \'struct vm_page\',  &mdpage)));
	    }' unless defined(&VM_MD_TO_PAGE);
	}
	eval 'sub VM_PGCOLOR {
	    my($pg) = @_;
    	    eval q(( &atop( &VM_PAGE_TO_PHYS(($pg))) &  ($uvmexp->{colormask})));
	}' unless defined(&VM_PGCOLOR);
	eval 'sub PHYS_TO_VM_PAGE {
	    my($pa) = @_;
    	    eval q( &uvm_phys_to_vm_page($pa));
	}' unless defined(&PHYS_TO_VM_PAGE);
	eval 'sub VM_PAGE_IS_FREE {
	    my($entry) = @_;
    	    eval q((($entry)-> &flags &  &PG_FREE));
	}' unless defined(&VM_PAGE_IS_FREE);
	eval 'sub UVM_PHYSADDR_FREELIST () { &__BITS(0,4);}' unless defined(&UVM_PHYSADDR_FREELIST);
	eval 'sub UVM_PHYSADDR_BUCKET () { &__BITS(5,9);}' unless defined(&UVM_PHYSADDR_BUCKET);
	eval 'sub uvm_page_get_freelist {
	    my($pg) = @_;
    	    eval q({ my $fl =  &__SHIFTOUT( ($pg->{phys_addr}),  &UVM_PHYSADDR_FREELIST);  &KASSERT( $fl ==  &uvm_page_lookup_freelist($pg));  $fl; });
	}' unless defined(&uvm_page_get_freelist);
	eval 'sub uvm_page_get_bucket {
	    my($pg) = @_;
    	    eval q({  &__SHIFTOUT( ($pg->{phys_addr}),  &UVM_PHYSADDR_BUCKET); });
	}' unless defined(&uvm_page_get_bucket);
	eval 'sub uvm_page_set_freelist {
	    my($pg,$fl) = @_;
    	    eval q({  &KASSERT($fl < 32);  ($pg->{phys_addr}) &= ~ &UVM_PHYSADDR_FREELIST;  ($pg->{phys_addr}) |=  &__SHIFTIN($fl,  &UVM_PHYSADDR_FREELIST); });
	}' unless defined(&uvm_page_set_freelist);
	eval 'sub uvm_page_set_bucket {
	    my($pg,$b) = @_;
    	    eval q({  &KASSERT($b < 32);  ($pg->{phys_addr}) &= ~ &UVM_PHYSADDR_BUCKET;  ($pg->{phys_addr}) |=  &__SHIFTIN($b,  &UVM_PHYSADDR_BUCKET); });
	}' unless defined(&uvm_page_set_bucket);
    }
}
1;
