/*
 * This declarations of the PIC18LF2331 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2016.
 *
 * This file is generated automatically by the cinc2h.pl, 2016-04-13 17:24:00 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC18LF2331_H__
#define __PIC18LF2331_H__

//==============================================================================

//==============================================================================
//
//	Register Definitions
//
//==============================================================================


//==============================================================================
//        DFLTCON Bits

extern __at(0x0F60) __sfr DFLTCON;

typedef union
  {
  struct
    {
    unsigned FLTCK0             : 1;
    unsigned FLTCK1             : 1;
    unsigned FLTCK2             : 1;
    unsigned FLT1EN             : 1;
    unsigned FLT2EN             : 1;
    unsigned FLT3EN             : 1;
    unsigned FLT4EN             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned FLTCK              : 3;
    unsigned                    : 5;
    };
  } __DFLTCONbits_t;

extern __at(0x0F60) volatile __DFLTCONbits_t DFLTCONbits;

#define _FLTCK0                 0x01
#define _FLTCK1                 0x02
#define _FLTCK2                 0x04
#define _FLT1EN                 0x08
#define _FLT2EN                 0x10
#define _FLT3EN                 0x20
#define _FLT4EN                 0x40

//==============================================================================


//==============================================================================
//        CAP3CON Bits

extern __at(0x0F61) __sfr CAP3CON;

typedef union
  {
  struct
    {
    unsigned CAP3M0             : 1;
    unsigned CAP3M1             : 1;
    unsigned CAP3M2             : 1;
    unsigned CAP3M3             : 1;
    unsigned                    : 1;
    unsigned CAP3TMR            : 1;
    unsigned CAP3REN            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CAP3M              : 4;
    unsigned                    : 4;
    };
  } __CAP3CONbits_t;

extern __at(0x0F61) volatile __CAP3CONbits_t CAP3CONbits;

#define _CAP3M0                 0x01
#define _CAP3M1                 0x02
#define _CAP3M2                 0x04
#define _CAP3M3                 0x08
#define _CAP3TMR                0x20
#define _CAP3REN                0x40

//==============================================================================


//==============================================================================
//        CAP2CON Bits

extern __at(0x0F62) __sfr CAP2CON;

typedef union
  {
  struct
    {
    unsigned CAP2M0             : 1;
    unsigned CAP2M1             : 1;
    unsigned CAP2M2             : 1;
    unsigned CAP2M3             : 1;
    unsigned                    : 1;
    unsigned CAP2TMR            : 1;
    unsigned CAP2REN            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CAP2M              : 4;
    unsigned                    : 4;
    };
  } __CAP2CONbits_t;

extern __at(0x0F62) volatile __CAP2CONbits_t CAP2CONbits;

#define _CAP2M0                 0x01
#define _CAP2M1                 0x02
#define _CAP2M2                 0x04
#define _CAP2M3                 0x08
#define _CAP2TMR                0x20
#define _CAP2REN                0x40

//==============================================================================


//==============================================================================
//        CAP1CON Bits

extern __at(0x0F63) __sfr CAP1CON;

typedef union
  {
  struct
    {
    unsigned CAP1M0             : 1;
    unsigned CAP1M1             : 1;
    unsigned CAP1M2             : 1;
    unsigned CAP1M3             : 1;
    unsigned                    : 1;
    unsigned CAP1TMR            : 1;
    unsigned CAP1REN            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CAP1M              : 4;
    unsigned                    : 4;
    };
  } __CAP1CONbits_t;

extern __at(0x0F63) volatile __CAP1CONbits_t CAP1CONbits;

#define _CAP1M0                 0x01
#define _CAP1M1                 0x02
#define _CAP1M2                 0x04
#define _CAP1M3                 0x08
#define _CAP1TMR                0x20
#define _CAP1REN                0x40

//==============================================================================

extern __at(0x0F64) __sfr CAP3BUFL;
extern __at(0x0F64) __sfr MAXCNTL;
extern __at(0x0F65) __sfr CAP3BUFH;
extern __at(0x0F65) __sfr MAXCNTH;
extern __at(0x0F66) __sfr CAP2BUFL;
extern __at(0x0F66) __sfr POSCNTL;
extern __at(0x0F67) __sfr CAP2BUFH;
extern __at(0x0F67) __sfr POSCNTH;
extern __at(0x0F68) __sfr CAP1BUFL;
extern __at(0x0F68) __sfr VELRL;
extern __at(0x0F69) __sfr CAP1BUFH;
extern __at(0x0F69) __sfr VELRH;

//==============================================================================
//        OVDCONS Bits

extern __at(0x0F6A) __sfr OVDCONS;

typedef struct
  {
  unsigned POUT0                : 1;
  unsigned POUT1                : 1;
  unsigned POUT2                : 1;
  unsigned POUT3                : 1;
  unsigned POUT4                : 1;
  unsigned POUT5                : 1;
  unsigned POUT6                : 1;
  unsigned POUT7                : 1;
  } __OVDCONSbits_t;

extern __at(0x0F6A) volatile __OVDCONSbits_t OVDCONSbits;

#define _POUT0                  0x01
#define _POUT1                  0x02
#define _POUT2                  0x04
#define _POUT3                  0x08
#define _POUT4                  0x10
#define _POUT5                  0x20
#define _POUT6                  0x40
#define _POUT7                  0x80

//==============================================================================


//==============================================================================
//        OVDCOND Bits

extern __at(0x0F6B) __sfr OVDCOND;

typedef struct
  {
  unsigned POVD0                : 1;
  unsigned POVD1                : 1;
  unsigned POVD2                : 1;
  unsigned POVD3                : 1;
  unsigned POVD4                : 1;
  unsigned POVD5                : 1;
  unsigned POVD6                : 1;
  unsigned POVD7                : 1;
  } __OVDCONDbits_t;

extern __at(0x0F6B) volatile __OVDCONDbits_t OVDCONDbits;

#define _POVD0                  0x01
#define _POVD1                  0x02
#define _POVD2                  0x04
#define _POVD3                  0x08
#define _POVD4                  0x10
#define _POVD5                  0x20
#define _POVD6                  0x40
#define _POVD7                  0x80

//==============================================================================


//==============================================================================
//        FLTCONFIG Bits

extern __at(0x0F6C) __sfr FLTCONFIG;

typedef struct
  {
  unsigned FLTAEN               : 1;
  unsigned FLTAMOD              : 1;
  unsigned FLTAS                : 1;
  unsigned FLTCON               : 1;
  unsigned FLTBEN               : 1;
  unsigned FLTBMOD              : 1;
  unsigned FLTBS                : 1;
  unsigned BRFEN                : 1;
  } __FLTCONFIGbits_t;

extern __at(0x0F6C) volatile __FLTCONFIGbits_t FLTCONFIGbits;

#define _FLTAEN                 0x01
#define _FLTAMOD                0x02
#define _FLTAS                  0x04
#define _FLTCON                 0x08
#define _FLTBEN                 0x10
#define _FLTBMOD                0x20
#define _FLTBS                  0x40
#define _BRFEN                  0x80

//==============================================================================


//==============================================================================
//        DTCON Bits

extern __at(0x0F6D) __sfr DTCON;

typedef union
  {
  struct
    {
    unsigned DT0                : 1;
    unsigned DT1                : 1;
    unsigned DT2                : 1;
    unsigned DT3                : 1;
    unsigned DT4                : 1;
    unsigned DT5                : 1;
    unsigned DTPS0              : 1;
    unsigned DTPS1              : 1;
    };

  struct
    {
    unsigned DTA0               : 1;
    unsigned DTA1               : 1;
    unsigned DTA2               : 1;
    unsigned DTA3               : 1;
    unsigned DTA4               : 1;
    unsigned DTA5               : 1;
    unsigned DTAPS0             : 1;
    unsigned DTAPS1             : 1;
    };

  struct
    {
    unsigned DTA                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned DT                 : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned DTPS               : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned DTAPS              : 2;
    };
  } __DTCONbits_t;

extern __at(0x0F6D) volatile __DTCONbits_t DTCONbits;

#define _DT0                    0x01
#define _DTA0                   0x01
#define _DT1                    0x02
#define _DTA1                   0x02
#define _DT2                    0x04
#define _DTA2                   0x04
#define _DT3                    0x08
#define _DTA3                   0x08
#define _DT4                    0x10
#define _DTA4                   0x10
#define _DT5                    0x20
#define _DTA5                   0x20
#define _DTPS0                  0x40
#define _DTAPS0                 0x40
#define _DTPS1                  0x80
#define _DTAPS1                 0x80

//==============================================================================


//==============================================================================
//        PWMCON1 Bits

extern __at(0x0F6E) __sfr PWMCON1;

typedef union
  {
  struct
    {
    unsigned OSYNC              : 1;
    unsigned UDIS               : 1;
    unsigned                    : 1;
    unsigned SEVTDIR            : 1;
    unsigned SEVOPS0            : 1;
    unsigned SEVOPS1            : 1;
    unsigned SEVOPS2            : 1;
    unsigned SEVOPS3            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned SEVOPS             : 4;
    };
  } __PWMCON1bits_t;

extern __at(0x0F6E) volatile __PWMCON1bits_t PWMCON1bits;

#define _OSYNC                  0x01
#define _UDIS                   0x02
#define _SEVTDIR                0x08
#define _SEVOPS0                0x10
#define _SEVOPS1                0x20
#define _SEVOPS2                0x40
#define _SEVOPS3                0x80

//==============================================================================


//==============================================================================
//        PWMCON0 Bits

extern __at(0x0F6F) __sfr PWMCON0;

typedef union
  {
  struct
    {
    unsigned PMOD0              : 1;
    unsigned PMOD1              : 1;
    unsigned PMOD2              : 1;
    unsigned PMOD3              : 1;
    unsigned PWMEN0             : 1;
    unsigned PWMEN1             : 1;
    unsigned PWMEN2             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PMOD               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned PWMEN              : 3;
    unsigned                    : 1;
    };
  } __PWMCON0bits_t;

extern __at(0x0F6F) volatile __PWMCON0bits_t PWMCON0bits;

#define _PMOD0                  0x01
#define _PMOD1                  0x02
#define _PMOD2                  0x04
#define _PMOD3                  0x08
#define _PWMEN0                 0x10
#define _PWMEN1                 0x20
#define _PWMEN2                 0x40

//==============================================================================

extern __at(0x0F70) __sfr SEVTCMPH;
extern __at(0x0F71) __sfr SEVTCMPL;
extern __at(0x0F74) __sfr PDC2H;
extern __at(0x0F75) __sfr PDC2L;
extern __at(0x0F76) __sfr PDC1H;
extern __at(0x0F77) __sfr PDC1L;
extern __at(0x0F78) __sfr PDC0H;
extern __at(0x0F79) __sfr PDC0L;
extern __at(0x0F7A) __sfr PTPERH;
extern __at(0x0F7B) __sfr PTPERL;
extern __at(0x0F7C) __sfr PTMRH;
extern __at(0x0F7D) __sfr PTMRL;

//==============================================================================
//        PTCON1 Bits

extern __at(0x0F7E) __sfr PTCON1;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PTDIR                : 1;
  unsigned PTEN                 : 1;
  } __PTCON1bits_t;

extern __at(0x0F7E) volatile __PTCON1bits_t PTCON1bits;

#define _PTDIR                  0x40
#define _PTEN                   0x80

//==============================================================================


//==============================================================================
//        PTCON0 Bits

extern __at(0x0F7F) __sfr PTCON0;

typedef union
  {
  struct
    {
    unsigned PTMOD0             : 1;
    unsigned PTMOD1             : 1;
    unsigned PTCKPS0            : 1;
    unsigned PTCKPS1            : 1;
    unsigned PTOPS0             : 1;
    unsigned PTOPS1             : 1;
    unsigned PTOPS2             : 1;
    unsigned PTOPS3             : 1;
    };

  struct
    {
    unsigned PTMOD              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PTCKPS             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned PTOPS              : 4;
    };
  } __PTCON0bits_t;

extern __at(0x0F7F) volatile __PTCON0bits_t PTCON0bits;

#define _PTMOD0                 0x01
#define _PTMOD1                 0x02
#define _PTCKPS0                0x04
#define _PTCKPS1                0x08
#define _PTOPS0                 0x10
#define _PTOPS1                 0x20
#define _PTOPS2                 0x40
#define _PTOPS3                 0x80

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x0F80) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned                    : 1;
    unsigned RA6                : 1;
    unsigned RA7                : 1;
    };

  struct
    {
    unsigned AN0                : 1;
    unsigned AN1                : 1;
    unsigned AN2                : 1;
    unsigned AN3                : 1;
    unsigned AN4                : 1;
    unsigned                    : 1;
    unsigned OSC2               : 1;
    unsigned OSC1               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned VREFM              : 1;
    unsigned VREFP              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CLKO               : 1;
    unsigned CLKI               : 1;
    };

  struct
    {
    unsigned AN                 : 5;
    unsigned                    : 3;
    };
  } __PORTAbits_t;

extern __at(0x0F80) volatile __PORTAbits_t PORTAbits;

#define _PORTA_RA0              0x01
#define _PORTA_AN0              0x01
#define _PORTA_RA1              0x02
#define _PORTA_AN1              0x02
#define _PORTA_RA2              0x04
#define _PORTA_AN2              0x04
#define _PORTA_VREFM            0x04
#define _PORTA_RA3              0x08
#define _PORTA_AN3              0x08
#define _PORTA_VREFP            0x08
#define _PORTA_RA4              0x10
#define _PORTA_AN4              0x10
#define _PORTA_RA6              0x40
#define _PORTA_OSC2             0x40
#define _PORTA_CLKO             0x40
#define _PORTA_RA7              0x80
#define _PORTA_OSC1             0x80
#define _PORTA_CLKI             0x80

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x0F81) __sfr PORTB;

typedef struct
  {
  unsigned RB0                  : 1;
  unsigned RB1                  : 1;
  unsigned RB2                  : 1;
  unsigned RB3                  : 1;
  unsigned RB4                  : 1;
  unsigned RB5                  : 1;
  unsigned RB6                  : 1;
  unsigned RB7                  : 1;
  } __PORTBbits_t;

extern __at(0x0F81) volatile __PORTBbits_t PORTBbits;

#define _PORTB_RB0              0x01
#define _PORTB_RB1              0x02
#define _PORTB_RB2              0x04
#define _PORTB_RB3              0x08
#define _PORTB_RB4              0x10
#define _PORTB_RB5              0x20
#define _PORTB_RB6              0x40
#define _PORTB_RB7              0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x0F82) __sfr PORTC;

typedef union
  {
  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };

  struct
    {
    unsigned T1OSO              : 1;
    unsigned T1OSI              : 1;
    unsigned CCP1               : 1;
    unsigned INT0               : 1;
    unsigned INT1               : 1;
    unsigned INT2               : 1;
    unsigned TX                 : 1;
    unsigned RX                 : 1;
    };

  struct
    {
    unsigned T13CKI             : 1;
    unsigned CCP2               : 1;
    unsigned NOT_FLTB           : 1;
    unsigned T0CKI              : 1;
    unsigned SDA                : 1;
    unsigned SCK                : 1;
    unsigned CK                 : 1;
    unsigned SDO                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned NOT_FLTA           : 1;
    unsigned FLTB               : 1;
    unsigned T5CKI              : 1;
    unsigned SDI                : 1;
    unsigned SCL                : 1;
    unsigned NOT_SS             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned FLTA               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SS                 : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 3;
    unsigned INT                : 3;
    unsigned                    : 2;
    };
  } __PORTCbits_t;

extern __at(0x0F82) volatile __PORTCbits_t PORTCbits;

#define _PORTC_RC0              0x01
#define _PORTC_T1OSO            0x01
#define _PORTC_T13CKI           0x01
#define _PORTC_RC1              0x02
#define _PORTC_T1OSI            0x02
#define _PORTC_CCP2             0x02
#define _PORTC_NOT_FLTA         0x02
#define _PORTC_FLTA             0x02
#define _PORTC_RC2              0x04
#define _PORTC_CCP1             0x04
#define _PORTC_NOT_FLTB         0x04
#define _PORTC_FLTB             0x04
#define _PORTC_RC3              0x08
#define _PORTC_INT0             0x08
#define _PORTC_T0CKI            0x08
#define _PORTC_T5CKI            0x08
#define _PORTC_RC4              0x10
#define _PORTC_INT1             0x10
#define _PORTC_SDA              0x10
#define _PORTC_SDI              0x10
#define _PORTC_RC5              0x20
#define _PORTC_INT2             0x20
#define _PORTC_SCK              0x20
#define _PORTC_SCL              0x20
#define _PORTC_RC6              0x40
#define _PORTC_TX               0x40
#define _PORTC_CK               0x40
#define _PORTC_NOT_SS           0x40
#define _PORTC_SS               0x40
#define _PORTC_RC7              0x80
#define _PORTC_RX               0x80
#define _PORTC_SDO              0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0F84) __sfr PORTE;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RE3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_MCLR           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned MCLR               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTEbits_t;

extern __at(0x0F84) volatile __PORTEbits_t PORTEbits;

#define _RE3                    0x08
#define _NOT_MCLR               0x08
#define _MCLR                   0x08

//==============================================================================

extern __at(0x0F87) __sfr TMR5;
extern __at(0x0F87) __sfr TMR5L;
extern __at(0x0F88) __sfr TMR5H;

//==============================================================================
//        LATA Bits

extern __at(0x0F89) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned LATA3                : 1;
  unsigned LATA4                : 1;
  unsigned                      : 1;
  unsigned LATA6                : 1;
  unsigned LATA7                : 1;
  } __LATAbits_t;

extern __at(0x0F89) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA3                  0x08
#define _LATA4                  0x10
#define _LATA6                  0x40
#define _LATA7                  0x80

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x0F8A) __sfr LATB;

typedef struct
  {
  unsigned LATB0                : 1;
  unsigned LATB1                : 1;
  unsigned LATB2                : 1;
  unsigned LATB3                : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x0F8A) volatile __LATBbits_t LATBbits;

#define _LATB0                  0x01
#define _LATB1                  0x02
#define _LATB2                  0x04
#define _LATB3                  0x08
#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x0F8B) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x0F8B) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================

extern __at(0x0F90) __sfr PR5;
extern __at(0x0F90) __sfr PR5L;
extern __at(0x0F91) __sfr PR5H;

//==============================================================================
//        DDRA Bits

extern __at(0x0F92) __sfr DDRA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned                    : 1;
    unsigned TRISA6             : 1;
    unsigned TRISA7             : 1;
    };

  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned                    : 1;
    unsigned RA6                : 1;
    unsigned RA7                : 1;
    };
  } __DDRAbits_t;

extern __at(0x0F92) volatile __DDRAbits_t DDRAbits;

#define _TRISA0                 0x01
#define _RA0                    0x01
#define _TRISA1                 0x02
#define _RA1                    0x02
#define _TRISA2                 0x04
#define _RA2                    0x04
#define _TRISA3                 0x08
#define _RA3                    0x08
#define _TRISA4                 0x10
#define _RA4                    0x10
#define _TRISA6                 0x40
#define _RA6                    0x40
#define _TRISA7                 0x80
#define _RA7                    0x80

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0F92) __sfr TRISA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned                    : 1;
    unsigned TRISA6             : 1;
    unsigned TRISA7             : 1;
    };

  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned                    : 1;
    unsigned RA6                : 1;
    unsigned RA7                : 1;
    };
  } __TRISAbits_t;

extern __at(0x0F92) volatile __TRISAbits_t TRISAbits;

#define _TRISA_TRISA0           0x01
#define _TRISA_RA0              0x01
#define _TRISA_TRISA1           0x02
#define _TRISA_RA1              0x02
#define _TRISA_TRISA2           0x04
#define _TRISA_RA2              0x04
#define _TRISA_TRISA3           0x08
#define _TRISA_RA3              0x08
#define _TRISA_TRISA4           0x10
#define _TRISA_RA4              0x10
#define _TRISA_TRISA6           0x40
#define _TRISA_RA6              0x40
#define _TRISA_TRISA7           0x80
#define _TRISA_RA7              0x80

//==============================================================================


//==============================================================================
//        DDRB Bits

extern __at(0x0F93) __sfr DDRB;

typedef union
  {
  struct
    {
    unsigned TRISB0             : 1;
    unsigned TRISB1             : 1;
    unsigned TRISB2             : 1;
    unsigned TRISB3             : 1;
    unsigned TRISB4             : 1;
    unsigned TRISB5             : 1;
    unsigned TRISB6             : 1;
    unsigned TRISB7             : 1;
    };

  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };
  } __DDRBbits_t;

extern __at(0x0F93) volatile __DDRBbits_t DDRBbits;

#define _TRISB0                 0x01
#define _RB0                    0x01
#define _TRISB1                 0x02
#define _RB1                    0x02
#define _TRISB2                 0x04
#define _RB2                    0x04
#define _TRISB3                 0x08
#define _RB3                    0x08
#define _TRISB4                 0x10
#define _RB4                    0x10
#define _TRISB5                 0x20
#define _RB5                    0x20
#define _TRISB6                 0x40
#define _RB6                    0x40
#define _TRISB7                 0x80
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x0F93) __sfr TRISB;

typedef union
  {
  struct
    {
    unsigned TRISB0             : 1;
    unsigned TRISB1             : 1;
    unsigned TRISB2             : 1;
    unsigned TRISB3             : 1;
    unsigned TRISB4             : 1;
    unsigned TRISB5             : 1;
    unsigned TRISB6             : 1;
    unsigned TRISB7             : 1;
    };

  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };
  } __TRISBbits_t;

extern __at(0x0F93) volatile __TRISBbits_t TRISBbits;

#define _TRISB_TRISB0           0x01
#define _TRISB_RB0              0x01
#define _TRISB_TRISB1           0x02
#define _TRISB_RB1              0x02
#define _TRISB_TRISB2           0x04
#define _TRISB_RB2              0x04
#define _TRISB_TRISB3           0x08
#define _TRISB_RB3              0x08
#define _TRISB_TRISB4           0x10
#define _TRISB_RB4              0x10
#define _TRISB_TRISB5           0x20
#define _TRISB_RB5              0x20
#define _TRISB_TRISB6           0x40
#define _TRISB_RB6              0x40
#define _TRISB_TRISB7           0x80
#define _TRISB_RB7              0x80

//==============================================================================


//==============================================================================
//        DDRC Bits

extern __at(0x0F94) __sfr DDRC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned TRISC3             : 1;
    unsigned TRISC4             : 1;
    unsigned TRISC5             : 1;
    unsigned TRISC6             : 1;
    unsigned TRISC7             : 1;
    };

  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };
  } __DDRCbits_t;

extern __at(0x0F94) volatile __DDRCbits_t DDRCbits;

#define _TRISC0                 0x01
#define _RC0                    0x01
#define _TRISC1                 0x02
#define _RC1                    0x02
#define _TRISC2                 0x04
#define _RC2                    0x04
#define _TRISC3                 0x08
#define _RC3                    0x08
#define _TRISC4                 0x10
#define _RC4                    0x10
#define _TRISC5                 0x20
#define _RC5                    0x20
#define _TRISC6                 0x40
#define _RC6                    0x40
#define _TRISC7                 0x80
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x0F94) __sfr TRISC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned TRISC3             : 1;
    unsigned TRISC4             : 1;
    unsigned TRISC5             : 1;
    unsigned TRISC6             : 1;
    unsigned TRISC7             : 1;
    };

  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };
  } __TRISCbits_t;

extern __at(0x0F94) volatile __TRISCbits_t TRISCbits;

#define _TRISC_TRISC0           0x01
#define _TRISC_RC0              0x01
#define _TRISC_TRISC1           0x02
#define _TRISC_RC1              0x02
#define _TRISC_TRISC2           0x04
#define _TRISC_RC2              0x04
#define _TRISC_TRISC3           0x08
#define _TRISC_RC3              0x08
#define _TRISC_TRISC4           0x10
#define _TRISC_RC4              0x10
#define _TRISC_TRISC5           0x20
#define _TRISC_RC5              0x20
#define _TRISC_TRISC6           0x40
#define _TRISC_RC6              0x40
#define _TRISC_TRISC7           0x80
#define _TRISC_RC7              0x80

//==============================================================================


//==============================================================================
//        ADCHS Bits

extern __at(0x0F99) __sfr ADCHS;

typedef union
  {
  struct
    {
    unsigned GASEL0             : 1;
    unsigned GASEL1             : 1;
    unsigned GCSEL0             : 1;
    unsigned GCSEL1             : 1;
    unsigned GBSEL0             : 1;
    unsigned GBSEL1             : 1;
    unsigned GDSEL0             : 1;
    unsigned GDSEL1             : 1;
    };

  struct
    {
    unsigned SASEL0             : 1;
    unsigned SASEL1             : 1;
    unsigned SCSEL0             : 1;
    unsigned SCSEL1             : 1;
    unsigned SBSEL0             : 1;
    unsigned SBSEL1             : 1;
    unsigned SDSEL0             : 1;
    unsigned SDSEL1             : 1;
    };

  struct
    {
    unsigned GASEL              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned SASEL              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned GCSEL              : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned SCSEL              : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned SBSEL              : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned GBSEL              : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned SDSEL              : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned GDSEL              : 2;
    };
  } __ADCHSbits_t;

extern __at(0x0F99) volatile __ADCHSbits_t ADCHSbits;

#define _GASEL0                 0x01
#define _SASEL0                 0x01
#define _GASEL1                 0x02
#define _SASEL1                 0x02
#define _GCSEL0                 0x04
#define _SCSEL0                 0x04
#define _GCSEL1                 0x08
#define _SCSEL1                 0x08
#define _GBSEL0                 0x10
#define _SBSEL0                 0x10
#define _GBSEL1                 0x20
#define _SBSEL1                 0x20
#define _GDSEL0                 0x40
#define _SDSEL0                 0x40
#define _GDSEL1                 0x80
#define _SDSEL1                 0x80

//==============================================================================


//==============================================================================
//        ADCON3 Bits

extern __at(0x0F9A) __sfr ADCON3;

typedef union
  {
  struct
    {
    unsigned SSRC0              : 1;
    unsigned SSRC1              : 1;
    unsigned SSRC2              : 1;
    unsigned SSRC3              : 1;
    unsigned SSRC4              : 1;
    unsigned                    : 1;
    unsigned ADRS0              : 1;
    unsigned ADRS1              : 1;
    };

  struct
    {
    unsigned SSRC               : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 6;
    unsigned ADRS               : 2;
    };
  } __ADCON3bits_t;

extern __at(0x0F9A) volatile __ADCON3bits_t ADCON3bits;

#define _SSRC0                  0x01
#define _SSRC1                  0x02
#define _SSRC2                  0x04
#define _SSRC3                  0x08
#define _SSRC4                  0x10
#define _ADRS0                  0x40
#define _ADRS1                  0x80

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0F9B) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned TUN5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TUN                : 6;
    unsigned                    : 2;
    };
  } __OSCTUNEbits_t;

extern __at(0x0F9B) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10
#define _TUN5                   0x20

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0F9D) __sfr PIE1;

typedef union
  {
  struct
    {
    unsigned TMR1IE             : 1;
    unsigned TMR2IE             : 1;
    unsigned CCP1IE             : 1;
    unsigned SSPIE              : 1;
    unsigned TXIE               : 1;
    unsigned RCIE               : 1;
    unsigned ADIE               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TBIE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE1bits_t;

extern __at(0x0F9D) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _SSPIE                  0x08
#define _TXIE                   0x10
#define _TBIE                   0x10
#define _RCIE                   0x20
#define _ADIE                   0x40

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0F9E) __sfr PIR1;

typedef union
  {
  struct
    {
    unsigned TMR1IF             : 1;
    unsigned TMR2IF             : 1;
    unsigned CCP1IF             : 1;
    unsigned SSPIF              : 1;
    unsigned TXIF               : 1;
    unsigned RCIF               : 1;
    unsigned ADIF               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TBIF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR1bits_t;

extern __at(0x0F9E) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _SSPIF                  0x08
#define _TXIF                   0x10
#define _TBIF                   0x10
#define _RCIF                   0x20
#define _ADIF                   0x40

//==============================================================================


//==============================================================================
//        IPR1 Bits

extern __at(0x0F9F) __sfr IPR1;

typedef union
  {
  struct
    {
    unsigned TMR1IP             : 1;
    unsigned TMR2IP             : 1;
    unsigned CCP1IP             : 1;
    unsigned SSPIP              : 1;
    unsigned TXIP               : 1;
    unsigned RCIP               : 1;
    unsigned ADIP               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TBIP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __IPR1bits_t;

extern __at(0x0F9F) volatile __IPR1bits_t IPR1bits;

#define _TMR1IP                 0x01
#define _TMR2IP                 0x02
#define _CCP1IP                 0x04
#define _SSPIP                  0x08
#define _TXIP                   0x10
#define _TBIP                   0x10
#define _RCIP                   0x20
#define _ADIP                   0x40

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0FA0) __sfr PIE2;

typedef struct
  {
  unsigned CCP2IE               : 1;
  unsigned                      : 1;
  unsigned LVDIE                : 1;
  unsigned                      : 1;
  unsigned EEIE                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned OSFIE                : 1;
  } __PIE2bits_t;

extern __at(0x0FA0) volatile __PIE2bits_t PIE2bits;

#define _CCP2IE                 0x01
#define _LVDIE                  0x04
#define _EEIE                   0x10
#define _OSFIE                  0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0FA1) __sfr PIR2;

typedef struct
  {
  unsigned CCP2IF               : 1;
  unsigned                      : 1;
  unsigned LVDIF                : 1;
  unsigned                      : 1;
  unsigned EEIF                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned OSFIF                : 1;
  } __PIR2bits_t;

extern __at(0x0FA1) volatile __PIR2bits_t PIR2bits;

#define _CCP2IF                 0x01
#define _LVDIF                  0x04
#define _EEIF                   0x10
#define _OSFIF                  0x80

//==============================================================================


//==============================================================================
//        IPR2 Bits

extern __at(0x0FA2) __sfr IPR2;

typedef struct
  {
  unsigned CCP2IP               : 1;
  unsigned                      : 1;
  unsigned LVDIP                : 1;
  unsigned                      : 1;
  unsigned EEIP                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned OSFIP                : 1;
  } __IPR2bits_t;

extern __at(0x0FA2) volatile __IPR2bits_t IPR2bits;

#define _CCP2IP                 0x01
#define _LVDIP                  0x04
#define _EEIP                   0x10
#define _OSFIP                  0x80

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0FA3) __sfr PIE3;

typedef struct
  {
  unsigned TMR5IE               : 1;
  unsigned IC1IE                : 1;
  unsigned IC2QEIE              : 1;
  unsigned IC3DRIE              : 1;
  unsigned PTIE                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE3bits_t;

extern __at(0x0FA3) volatile __PIE3bits_t PIE3bits;

#define _TMR5IE                 0x01
#define _IC1IE                  0x02
#define _IC2QEIE                0x04
#define _IC3DRIE                0x08
#define _PTIE                   0x10

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x0FA4) __sfr PIR3;

typedef struct
  {
  unsigned TMR5IF               : 1;
  unsigned IC1IF                : 1;
  unsigned IC2QEIF              : 1;
  unsigned IC3DRIF              : 1;
  unsigned PTIF                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR3bits_t;

extern __at(0x0FA4) volatile __PIR3bits_t PIR3bits;

#define _TMR5IF                 0x01
#define _IC1IF                  0x02
#define _IC2QEIF                0x04
#define _IC3DRIF                0x08
#define _PTIF                   0x10

//==============================================================================


//==============================================================================
//        IPR3 Bits

extern __at(0x0FA5) __sfr IPR3;

typedef struct
  {
  unsigned TMR5IP               : 1;
  unsigned IC1IP                : 1;
  unsigned IC2QEIP              : 1;
  unsigned IC3DRIP              : 1;
  unsigned PTIP                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IPR3bits_t;

extern __at(0x0FA5) volatile __IPR3bits_t IPR3bits;

#define _TMR5IP                 0x01
#define _IC1IP                  0x02
#define _IC2QEIP                0x04
#define _IC3DRIP                0x08
#define _PTIP                   0x10

//==============================================================================


//==============================================================================
//        EECON1 Bits

extern __at(0x0FA6) __sfr EECON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned                      : 1;
  unsigned CFGS                 : 1;
  unsigned EEPGD                : 1;
  } __EECON1bits_t;

extern __at(0x0FA6) volatile __EECON1bits_t EECON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _CFGS                   0x40
#define _EEPGD                  0x80

//==============================================================================

extern __at(0x0FA7) __sfr EECON2;
extern __at(0x0FA8) __sfr EEDATA;
extern __at(0x0FA9) __sfr EEADR;

//==============================================================================
//        BAUDCON Bits

extern __at(0x0FAA) __sfr BAUDCON;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned TXCKP              : 1;
    unsigned RXDTP              : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SCKP               : 1;
    unsigned                    : 1;
    unsigned RCMT               : 1;
    unsigned                    : 1;
    };
  } __BAUDCONbits_t;

extern __at(0x0FAA) volatile __BAUDCONbits_t BAUDCONbits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _TXCKP                  0x10
#define _SCKP                   0x10
#define _RXDTP                  0x20
#define _RCIDL                  0x40
#define _RCMT                   0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        BAUDCTL Bits

extern __at(0x0FAA) __sfr BAUDCTL;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned TXCKP              : 1;
    unsigned RXDTP              : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SCKP               : 1;
    unsigned                    : 1;
    unsigned RCMT               : 1;
    unsigned                    : 1;
    };
  } __BAUDCTLbits_t;

extern __at(0x0FAA) volatile __BAUDCTLbits_t BAUDCTLbits;

#define _BAUDCTL_ABDEN          0x01
#define _BAUDCTL_WUE            0x02
#define _BAUDCTL_BRG16          0x08
#define _BAUDCTL_TXCKP          0x10
#define _BAUDCTL_SCKP           0x10
#define _BAUDCTL_RXDTP          0x20
#define _BAUDCTL_RCIDL          0x40
#define _BAUDCTL_RCMT           0x40
#define _BAUDCTL_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        RCSTA Bits

extern __at(0x0FAB) __sfr RCSTA;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADEN               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __RCSTAbits_t;

extern __at(0x0FAB) volatile __RCSTAbits_t RCSTAbits;

#define _RX9D                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _ADEN                   0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _SPEN                   0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x0FAC) __sfr TXSTA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTAbits_t;

extern __at(0x0FAC) volatile __TXSTAbits_t TXSTAbits;

#define _TX9D                   0x01
#define _TRMT                   0x02
#define _BRGH                   0x04
#define _SENDB                  0x08
#define _SYNC                   0x10
#define _TXEN                   0x20
#define _TX9                    0x40
#define _CSRC                   0x80

//==============================================================================

extern __at(0x0FAD) __sfr TXREG;
extern __at(0x0FAE) __sfr RCREG;
extern __at(0x0FAF) __sfr SPBRG;
extern __at(0x0FB0) __sfr SPBRGH;

//==============================================================================
//        QEICON Bits

extern __at(0x0FB6) __sfr QEICON;

typedef union
  {
  struct
    {
    unsigned PDEC0              : 1;
    unsigned PDEC1              : 1;
    unsigned QEIM0              : 1;
    unsigned QEIM1              : 1;
    unsigned QEIM2              : 1;
    unsigned UP_NOT_DOWN        : 1;
    unsigned                    : 1;
    unsigned NOT_VELM           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned UP_DOWN            : 1;
    unsigned                    : 1;
    unsigned VELM               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned UP                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DOWN               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_DOWN           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned UPDOWN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PDEC               : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned QEIM               : 3;
    unsigned                    : 3;
    };
  } __QEICONbits_t;

extern __at(0x0FB6) volatile __QEICONbits_t QEICONbits;

#define _PDEC0                  0x01
#define _PDEC1                  0x02
#define _QEIM0                  0x04
#define _QEIM1                  0x08
#define _QEIM2                  0x10
#define _UP_NOT_DOWN            0x20
#define _UP_DOWN                0x20
#define _UP                     0x20
#define _DOWN                   0x20
#define _NOT_DOWN               0x20
#define _UPDOWN                 0x20
#define _NOT_VELM               0x80
#define _VELM                   0x80

//==============================================================================


//==============================================================================
//        T5CON Bits

extern __at(0x0FB7) __sfr T5CON;

typedef union
  {
  struct
    {
    unsigned TMR5ON             : 1;
    unsigned TMR5CS             : 1;
    unsigned NOT_T5SYNC         : 1;
    unsigned T5PS0              : 1;
    unsigned T5PS1              : 1;
    unsigned T5MOD              : 1;
    unsigned NOT_RESEN          : 1;
    unsigned T5SEN              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T5SYNC             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RESEN              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T5PS               : 2;
    unsigned                    : 3;
    };
  } __T5CONbits_t;

extern __at(0x0FB7) volatile __T5CONbits_t T5CONbits;

#define _TMR5ON                 0x01
#define _TMR5CS                 0x02
#define _NOT_T5SYNC             0x04
#define _T5SYNC                 0x04
#define _T5PS0                  0x08
#define _T5PS1                  0x10
#define _T5MOD                  0x20
#define _NOT_RESEN              0x40
#define _RESEN                  0x40
#define _T5SEN                  0x80

//==============================================================================


//==============================================================================
//        ANSEL0 Bits

extern __at(0x0FB8) __sfr ANSEL0;

typedef union
  {
  struct
    {
    unsigned ANS0               : 1;
    unsigned ANS1               : 1;
    unsigned ANS2               : 1;
    unsigned ANS3               : 1;
    unsigned ANS4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ANS                : 5;
    unsigned                    : 3;
    };
  } __ANSEL0bits_t;

extern __at(0x0FB8) volatile __ANSEL0bits_t ANSEL0bits;

#define _ANS0                   0x01
#define _ANS1                   0x02
#define _ANS2                   0x04
#define _ANS3                   0x08
#define _ANS4                   0x10

//==============================================================================


//==============================================================================
//        CCP2CON Bits

extern __at(0x0FBA) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned CCP2Y              : 1;
    unsigned CCP2X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };
  } __CCP2CONbits_t;

extern __at(0x0FBA) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2M0                 0x01
#define _CCP2M1                 0x02
#define _CCP2M2                 0x04
#define _CCP2M3                 0x08
#define _CCP2Y                  0x10
#define _DC2B0                  0x10
#define _CCP2X                  0x20
#define _DC2B1                  0x20

//==============================================================================

extern __at(0x0FBB) __sfr CCPR2;
extern __at(0x0FBB) __sfr CCPR2L;
extern __at(0x0FBC) __sfr CCPR2H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0FBD) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned CCP1Y              : 1;
    unsigned CCP1X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0FBD) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _CCP1Y                  0x10
#define _DC1B0                  0x10
#define _CCP1X                  0x20
#define _DC1B1                  0x20

//==============================================================================

extern __at(0x0FBE) __sfr CCPR1;
extern __at(0x0FBE) __sfr CCPR1L;
extern __at(0x0FBF) __sfr CCPR1H;

//==============================================================================
//        ADCON2 Bits

extern __at(0x0FC0) __sfr ADCON2;

typedef union
  {
  struct
    {
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ACQT0              : 1;
    unsigned ACQT1              : 1;
    unsigned ACQT2              : 1;
    unsigned ACQT3              : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADCS               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned ACQT               : 4;
    unsigned                    : 1;
    };
  } __ADCON2bits_t;

extern __at(0x0FC0) volatile __ADCON2bits_t ADCON2bits;

#define _ADCS0                  0x01
#define _ADCS1                  0x02
#define _ADCS2                  0x04
#define _ACQT0                  0x08
#define _ACQT1                  0x10
#define _ACQT2                  0x20
#define _ACQT3                  0x40
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x0FC1) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned ADPNT0             : 1;
    unsigned ADPNT1             : 1;
    unsigned BFOVFL             : 1;
    unsigned BFEMT              : 1;
    unsigned FIFOEN             : 1;
    unsigned                    : 1;
    unsigned VCFG0              : 1;
    unsigned VCFG1              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned FFOVFL             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPNT              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 6;
    unsigned VCFG               : 2;
    };
  } __ADCON1bits_t;

extern __at(0x0FC1) volatile __ADCON1bits_t ADCON1bits;

#define _ADPNT0                 0x01
#define _ADPNT1                 0x02
#define _BFOVFL                 0x04
#define _FFOVFL                 0x04
#define _BFEMT                  0x08
#define _FIFOEN                 0x10
#define _VCFG0                  0x40
#define _VCFG1                  0x80

//==============================================================================


//==============================================================================
//        ADCON0 Bits

extern __at(0x0FC2) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned ACMOD0             : 1;
    unsigned ACMOD1             : 1;
    unsigned ACSCH              : 1;
    unsigned ACONV              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_DONE            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned DONE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GODONE             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned ACMOD              : 2;
    unsigned                    : 4;
    };
  } __ADCON0bits_t;

extern __at(0x0FC2) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _GO_DONE                0x02
#define _DONE                   0x02
#define _GO                     0x02
#define _NOT_DONE               0x02
#define _GODONE                 0x02
#define _ACMOD0                 0x04
#define _ACMOD1                 0x08
#define _ACSCH                  0x10
#define _ACONV                  0x20

//==============================================================================

extern __at(0x0FC3) __sfr ADRES;
extern __at(0x0FC3) __sfr ADRESL;
extern __at(0x0FC4) __sfr ADRESH;

//==============================================================================
//        SSPCON Bits

extern __at(0x0FC6) __sfr SSPCON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCONbits_t;

extern __at(0x0FC6) volatile __SSPCONbits_t SSPCONbits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0FC7) __sfr SSPSTAT;

typedef union
  {
  struct
    {
    unsigned BF                 : 1;
    unsigned UA                 : 1;
    unsigned R_NOT_W            : 1;
    unsigned S                  : 1;
    unsigned P                  : 1;
    unsigned D_NOT_A            : 1;
    unsigned CKE                : 1;
    unsigned SMP                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R_W                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D_A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_W              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_A              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_WRITE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_ADDRESS        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned READ_WRITE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA_ADDRESS       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSPSTATbits_t;

extern __at(0x0FC7) volatile __SSPSTATbits_t SSPSTATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _R_W                    0x04
#define _NOT_W                  0x04
#define _NOT_WRITE              0x04
#define _READ_WRITE             0x04
#define _R                      0x04
#define _S                      0x08
#define _P                      0x10
#define _D_NOT_A                0x20
#define _D_A                    0x20
#define _NOT_A                  0x20
#define _NOT_ADDRESS            0x20
#define _DATA_ADDRESS           0x20
#define _D                      0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================

extern __at(0x0FC8) __sfr SSPADD;
extern __at(0x0FC9) __sfr SSPBUF;

//==============================================================================
//        T2CON Bits

extern __at(0x0FCA) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TOUTPS0            : 1;
    unsigned TOUTPS1            : 1;
    unsigned TOUTPS2            : 1;
    unsigned TOUTPS3            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 3;
    unsigned TOUTPS             : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x0FCA) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _TOUTPS0                0x08
#define _T2OUTPS1               0x10
#define _TOUTPS1                0x10
#define _T2OUTPS2               0x20
#define _TOUTPS2                0x20
#define _T2OUTPS3               0x40
#define _TOUTPS3                0x40

//==============================================================================

extern __at(0x0FCB) __sfr PR2;
extern __at(0x0FCC) __sfr TMR2;

//==============================================================================
//        T1CON Bits

extern __at(0x0FCD) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned TMR1CS             : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned T1RUN              : 1;
    unsigned RD16               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1SYNC             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1INSYNC           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };
  } __T1CONbits_t;

extern __at(0x0FCD) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _TMR1CS                 0x02
#define _NOT_T1SYNC             0x04
#define _T1SYNC                 0x04
#define _T1INSYNC               0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _T1RUN                  0x40
#define _RD16                   0x80

//==============================================================================

extern __at(0x0FCE) __sfr TMR1;
extern __at(0x0FCE) __sfr TMR1L;
extern __at(0x0FCF) __sfr TMR1H;

//==============================================================================
//        RCON Bits

extern __at(0x0FD0) __sfr RCON;

typedef union
  {
  struct
    {
    unsigned NOT_BOR            : 1;
    unsigned NOT_POR            : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned NOT_RI             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned IPEN               : 1;
    };

  struct
    {
    unsigned BOR                : 1;
    unsigned POR                : 1;
    unsigned PD                 : 1;
    unsigned TO                 : 1;
    unsigned RI                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_IPEN           : 1;
    };
  } __RCONbits_t;

extern __at(0x0FD0) volatile __RCONbits_t RCONbits;

#define _NOT_BOR                0x01
#define _BOR                    0x01
#define _NOT_POR                0x02
#define _POR                    0x02
#define _NOT_PD                 0x04
#define _PD                     0x04
#define _NOT_TO                 0x08
#define _TO                     0x08
#define _NOT_RI                 0x10
#define _RI                     0x10
#define _IPEN                   0x80
#define _NOT_IPEN               0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0FD1) __sfr WDTCON;

typedef struct
  {
  unsigned SWDTEN               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned WDTW                 : 1;
  } __WDTCONbits_t;

extern __at(0x0FD1) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _WDTW                   0x80

//==============================================================================


//==============================================================================
//        LVDCON Bits

extern __at(0x0FD2) __sfr LVDCON;

typedef union
  {
  struct
    {
    unsigned LVDL0              : 1;
    unsigned LVDL1              : 1;
    unsigned LVDL2              : 1;
    unsigned LVDL3              : 1;
    unsigned LVDEN              : 1;
    unsigned IRVST              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned IVRST              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVDL               : 4;
    unsigned                    : 4;
    };
  } __LVDCONbits_t;

extern __at(0x0FD2) volatile __LVDCONbits_t LVDCONbits;

#define _LVDL0                  0x01
#define _LVDL1                  0x02
#define _LVDL2                  0x04
#define _LVDL3                  0x08
#define _LVDEN                  0x10
#define _IRVST                  0x20
#define _IVRST                  0x20

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0FD3) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned IOFS               : 1;
    unsigned OSTS               : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IDLEN              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned FLTS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned IRCF               : 3;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0FD3) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _IOFS                   0x04
#define _FLTS                   0x04
#define _OSTS                   0x08
#define _IRCF0                  0x10
#define _IRCF1                  0x20
#define _IRCF2                  0x40
#define _IDLEN                  0x80

//==============================================================================


//==============================================================================
//        T0CON Bits

extern __at(0x0FD5) __sfr T0CON;

typedef union
  {
  struct
    {
    unsigned T0PS0              : 1;
    unsigned T0PS1              : 1;
    unsigned T0PS2              : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned T016BIT            : 1;
    unsigned TMR0ON             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0PS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T0PS               : 4;
    unsigned                    : 4;
    };
  } __T0CONbits_t;

extern __at(0x0FD5) volatile __T0CONbits_t T0CONbits;

#define _T0PS0                  0x01
#define _T0PS1                  0x02
#define _T0PS2                  0x04
#define _PSA                    0x08
#define _T0PS3                  0x08
#define _T0SE                   0x10
#define _T0CS                   0x20
#define _T016BIT                0x40
#define _TMR0ON                 0x80

//==============================================================================

extern __at(0x0FD6) __sfr TMR0;
extern __at(0x0FD6) __sfr TMR0L;
extern __at(0x0FD7) __sfr TMR0H;

//==============================================================================
//        STATUS Bits

extern __at(0x0FD8) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned OV                   : 1;
  unsigned N                    : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0FD8) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _OV                     0x08
#define _N                      0x10

//==============================================================================

extern __at(0x0FD9) __sfr FSR2L;
extern __at(0x0FDA) __sfr FSR2H;
extern __at(0x0FDB) __sfr PLUSW2;
extern __at(0x0FDC) __sfr PREINC2;
extern __at(0x0FDD) __sfr POSTDEC2;
extern __at(0x0FDE) __sfr POSTINC2;
extern __at(0x0FDF) __sfr INDF2;
extern __at(0x0FE0) __sfr BSR;
extern __at(0x0FE1) __sfr FSR1L;
extern __at(0x0FE2) __sfr FSR1H;
extern __at(0x0FE3) __sfr PLUSW1;
extern __at(0x0FE4) __sfr PREINC1;
extern __at(0x0FE5) __sfr POSTDEC1;
extern __at(0x0FE6) __sfr POSTINC1;
extern __at(0x0FE7) __sfr INDF1;
extern __at(0x0FE8) __sfr WREG;
extern __at(0x0FE9) __sfr FSR0L;
extern __at(0x0FEA) __sfr FSR0H;
extern __at(0x0FEB) __sfr PLUSW0;
extern __at(0x0FEC) __sfr PREINC0;
extern __at(0x0FED) __sfr POSTDEC0;
extern __at(0x0FEE) __sfr POSTINC0;
extern __at(0x0FEF) __sfr INDF0;

//==============================================================================
//        INTCON3 Bits

extern __at(0x0FF0) __sfr INTCON3;

typedef union
  {
  struct
    {
    unsigned INT1IF             : 1;
    unsigned INT2IF             : 1;
    unsigned                    : 1;
    unsigned INT1IE             : 1;
    unsigned INT2IE             : 1;
    unsigned                    : 1;
    unsigned INT1IP             : 1;
    unsigned INT2IP             : 1;
    };

  struct
    {
    unsigned INT1F              : 1;
    unsigned INT2F              : 1;
    unsigned                    : 1;
    unsigned INT1E              : 1;
    unsigned INT2E              : 1;
    unsigned                    : 1;
    unsigned INT1P              : 1;
    unsigned INT2P              : 1;
    };
  } __INTCON3bits_t;

extern __at(0x0FF0) volatile __INTCON3bits_t INTCON3bits;

#define _INT1IF                 0x01
#define _INT1F                  0x01
#define _INT2IF                 0x02
#define _INT2F                  0x02
#define _INT1IE                 0x08
#define _INT1E                  0x08
#define _INT2IE                 0x10
#define _INT2E                  0x10
#define _INT1IP                 0x40
#define _INT1P                  0x40
#define _INT2IP                 0x80
#define _INT2P                  0x80

//==============================================================================


//==============================================================================
//        INTCON2 Bits

extern __at(0x0FF1) __sfr INTCON2;

typedef union
  {
  struct
    {
    unsigned RBIP               : 1;
    unsigned                    : 1;
    unsigned TMR0IP             : 1;
    unsigned                    : 1;
    unsigned INTEDG2            : 1;
    unsigned INTEDG1            : 1;
    unsigned INTEDG0            : 1;
    unsigned NOT_RBPU           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RBPU               : 1;
    };
  } __INTCON2bits_t;

extern __at(0x0FF1) volatile __INTCON2bits_t INTCON2bits;

#define _RBIP                   0x01
#define _TMR0IP                 0x04
#define _T0IP                   0x04
#define _INTEDG2                0x10
#define _INTEDG1                0x20
#define _INTEDG0                0x40
#define _NOT_RBPU               0x80
#define _RBPU                   0x80

//==============================================================================


//==============================================================================
//        INTCON Bits

extern __at(0x0FF2) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned RBIF               : 1;
    unsigned INT0IF             : 1;
    unsigned TMR0IF             : 1;
    unsigned RBIE               : 1;
    unsigned INT0IE             : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE_GIEL          : 1;
    unsigned GIE_GIEH           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned INT0F              : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned INT0E              : 1;
    unsigned T0IE               : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GIEL               : 1;
    unsigned GIEH               : 1;
    };
  } __INTCONbits_t;

extern __at(0x0FF2) volatile __INTCONbits_t INTCONbits;

#define _RBIF                   0x01
#define _INT0IF                 0x02
#define _INT0F                  0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _RBIE                   0x08
#define _INT0IE                 0x10
#define _INT0E                  0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE_GIEL              0x40
#define _PEIE                   0x40
#define _GIEL                   0x40
#define _GIE_GIEH               0x80
#define _GIE                    0x80
#define _GIEH                   0x80

//==============================================================================

extern __at(0x0FF3) __sfr PROD;
extern __at(0x0FF3) __sfr PRODL;
extern __at(0x0FF4) __sfr PRODH;
extern __at(0x0FF5) __sfr TABLAT;
extern __at(0x0FF6) __sfr TBLPTR;
extern __at(0x0FF6) __sfr TBLPTRL;
extern __at(0x0FF7) __sfr TBLPTRH;
extern __at(0x0FF8) __sfr TBLPTRU;
extern __at(0x0FF9) __sfr PC;
extern __at(0x0FF9) __sfr PCL;
extern __at(0x0FFA) __sfr PCLATH;
extern __at(0x0FFB) __sfr PCLATU;

//==============================================================================
//        STKPTR Bits

extern __at(0x0FFC) __sfr STKPTR;

typedef union
  {
  struct
    {
    unsigned STKPTR0            : 1;
    unsigned STKPTR1            : 1;
    unsigned STKPTR2            : 1;
    unsigned STKPTR3            : 1;
    unsigned STKPTR4            : 1;
    unsigned                    : 1;
    unsigned STKUNF             : 1;
    unsigned STKFUL             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned STKOVF             : 1;
    };

  struct
    {
    unsigned STKPTR             : 5;
    unsigned                    : 3;
    };
  } __STKPTRbits_t;

extern __at(0x0FFC) volatile __STKPTRbits_t STKPTRbits;

#define _STKPTR0                0x01
#define _STKPTR1                0x02
#define _STKPTR2                0x04
#define _STKPTR3                0x08
#define _STKPTR4                0x10
#define _STKUNF                 0x40
#define _STKFUL                 0x80
#define _STKOVF                 0x80

//==============================================================================

extern __at(0x0FFD) __sfr TOS;
extern __at(0x0FFD) __sfr TOSL;
extern __at(0x0FFE) __sfr TOSH;
extern __at(0x0FFF) __sfr TOSU;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define __CONFIG1H              0x300001
#define __CONFIG2L              0x300002
#define __CONFIG2H              0x300003
#define __CONFIG3L              0x300004
#define __CONFIG3H              0x300005
#define __CONFIG4L              0x300006
#define __CONFIG5L              0x300008
#define __CONFIG5H              0x300009
#define __CONFIG6L              0x30000A
#define __CONFIG6H              0x30000B
#define __CONFIG7L              0x30000C
#define __CONFIG7H              0x30000D

//----------------------------- CONFIG1H Options -------------------------------

#define _OSC_LP_1H              0xF0    // LP oscillator.
#define _OSC_XT_1H              0xF1    // XT oscillator.
#define _OSC_HS_1H              0xF2    // HS oscillator.
#define _OSC_RC2_1H             0xF3    // External RC oscillator, CLKO function on RA6.
#define _OSC_EC_1H              0xF4    // EC oscillator, CLKO function on RA6.
#define _OSC_ECIO_1H            0xF5    // EC oscillator, port function on RA6.
#define _OSC_HSPLL_1H           0xF6    // HS oscillator, PLL enabled (clock frequency = 4 x FOSC1).
#define _OSC_RCIO_1H            0xF7    // External RC oscillator, port function on RA6.
#define _OSC_IRCIO_1H           0xF8    // Internal oscillator block, port function on RA6 and port function on RA7.
#define _OSC_IRC_1H             0xF9    // Internal oscillator block, CLKO function on RA6 and port function on RA7.
#define _OSC_RC1_1H             0xFA    // 101X External RC oscillator, CLKO function on RA6.
#define _OSC_RC_1H              0xFC    // 11XX External RC oscillator, CLKO function on RA6.
#define _FCMEN_OFF_1H           0xBF    // Fail-Safe Clock Monitor disabled.
#define _FCMEN_ON_1H            0xFF    // Fail-Safe Clock Monitor enabled.
#define _IESO_OFF_1H            0x7F    // Internal External Switchover mode disabled.
#define _IESO_ON_1H             0xFF    // Internal External Switchover mode enabled.

//----------------------------- CONFIG2L Options -------------------------------

#define _PWRTEN_ON_2L           0xFE    // PWRT enabled.
#define _PWRTEN_OFF_2L          0xFF    // PWRT disabled.
#define _BOREN_OFF_2L           0xFD    // Brown-out Reset disabled.
#define _BOREN_ON_2L            0xFF    // Brown-out Reset enabled.
#define _BORV_45_2L             0xF3    // VBOR set to 4.5V.
#define _BORV_42_2L             0xF7    // VBOR set to 4.2V.
#define _BORV_27_2L             0xFB    // VBOR set to 2.7V.
#define _BORV_20_2L             0xFF    // Reserved.

//----------------------------- CONFIG2H Options -------------------------------

#define _WDTEN_OFF_2H           0xFE    // WDT disabled (control is placed on the SWDTEN bit).
#define _WDTEN_ON_2H            0xFF    // WDT enabled.
#define _WDPS_1_2H              0xE1    // 1:1.
#define _WDPS_2_2H              0xE3    // 1:2.
#define _WDPS_4_2H              0xE5    // 1:4.
#define _WDPS_8_2H              0xE7    // 1:8.
#define _WDPS_16_2H             0xE9    // 1:16.
#define _WDPS_32_2H             0xEB    // 1:32.
#define _WDPS_64_2H             0xED    // 1:64.
#define _WDPS_128_2H            0xEF    // 1:128.
#define _WDPS_256_2H            0xF1    // 1:256.
#define _WDPS_512_2H            0xF3    // 1:512.
#define _WDPS_1024_2H           0xF5    // 1:1024.
#define _WDPS_2048_2H           0xF7    // 1:2048.
#define _WDPS_4096_2H           0xF9    // 1:4096.
#define _WDPS_8192_2H           0xFB    // 1:8192.
#define _WDPS_16384_2H          0xFD    // 1:16384.
#define _WDPS_32768_2H          0xFF    // 1:32768.
#define _WINEN_ON_2H            0xDF    // WDT window enabledbled.
#define _WINEN_OFF_2H           0xFF    // WDT window disabled.

//----------------------------- CONFIG3L Options -------------------------------

#define _PWMPIN_ON_3L           0xFB    // PWM outputs drive active states upon Reset.
#define _PWMPIN_OFF_3L          0xFF    // PWM outputs disabled upon Reset (default).
#define _LPOL_LOW_3L            0xF7    // PWM0, 2, 4 and 6 are active-low.
#define _LPOL_HIGH_3L           0xFF    // PWM0, 2, 4 and 6 are active-high.
#define _HPOL_LOW_3L            0xEF    // PWM1, 3, 5 and 7 are active-low.
#define _HPOL_HIGH_3L           0xFF    // PWM1, 3, 5 and 7 are active-high.
#define _T1OSCMX_OFF_3L         0xDF    // Standard (legacy) Timer1 oscillator operation.
#define _T1OSCMX_ON_3L          0xFF    // Low-power Timer1 operation when microcontroller is in Sleep mode.

//----------------------------- CONFIG3H Options -------------------------------

#define _MCLRE_OFF_3H           0x7F    // Disabled.
#define _MCLRE_ON_3H            0xFF    // Enabled.

//----------------------------- CONFIG4L Options -------------------------------

#define _STVREN_OFF_4L          0xFE    // Stack full/underflow will not cause Reset.
#define _STVREN_ON_4L           0xFF    // Stack full/underflow will cause Reset.
#define _LVP_OFF_4L             0xFB    // Low-voltage ICSP disabled.
#define _LVP_ON_4L              0xFF    // Low-voltage ICSP enabled.
#define _DEBUG_ON_4L            0x7F    // Background debugger enabled; RB6 and RB7 are dedicated to In-Circuit Debug.
#define _DEBUG_OFF_4L           0xFF    // Background debugger disabled; RB6 and RB7 configured as general purpose I/O pins.

//----------------------------- CONFIG5L Options -------------------------------

#define _CP0_ON_5L              0xFE    // Block 0 (000200-000FFFh) code-protected.
#define _CP0_OFF_5L             0xFF    // Block 0 (000200-000FFFh) not code-protected.
#define _CP1_ON_5L              0xFD    // Block 1 (001000-001FFF) code-protected.
#define _CP1_OFF_5L             0xFF    // Block 1 (001000-001FFF) not code-protected.

//----------------------------- CONFIG5H Options -------------------------------

#define _CPB_ON_5H              0xBF    // Boot Block (000000-0001FFh) code-protected.
#define _CPB_OFF_5H             0xFF    // Boot Block (000000-0001FFh) not code-protected.
#define _CPD_ON_5H              0x7F    // Data EEPROM code-protected.
#define _CPD_OFF_5H             0xFF    // Data EEPROM not code-protected.

//----------------------------- CONFIG6L Options -------------------------------

#define _WRT0_ON_6L             0xFE    // Block 0 (000200-000FFFh) write-protected.
#define _WRT0_OFF_6L            0xFF    // Block 0 (000200-000FFFh) not write-protected.
#define _WRT1_ON_6L             0xFD    // Block 1 (001000-001FFF) write-protected.
#define _WRT1_OFF_6L            0xFF    // Block 1 (001000-001FFF) not write-protected.

//----------------------------- CONFIG6H Options -------------------------------

#define _WRTC_ON_6H             0xDF    // Configuration registers (300000-3000FFh) write-protected.
#define _WRTC_OFF_6H            0xFF    // Configuration registers (300000-3000FFh) not write-protected.
#define _WRTB_ON_6H             0xBF    // Boot Block (000000-0001FFh) write-protected.
#define _WRTB_OFF_6H            0xFF    // Boot Block (000000-0001FFh) not write-protected.
#define _WRTD_ON_6H             0x7F    // Data EEPROM write-protected.
#define _WRTD_OFF_6H            0xFF    // Data EEPROM not write-protected.

//----------------------------- CONFIG7L Options -------------------------------

#define _EBTR0_ON_7L            0xFE    // Block 0 (000200-000FFFh) protected from table reads executed in other blocks.
#define _EBTR0_OFF_7L           0xFF    // Block 0 (000200-000FFFh) not protected from table reads executed in other blocks.
#define _EBTR1_ON_7L            0xFD    // Block 1 (001000-001FFF) protected from table reads executed in other blocks.
#define _EBTR1_OFF_7L           0xFF    // Block 1 (001000-001FFF) not protected from table reads executed in other blocks.

//----------------------------- CONFIG7H Options -------------------------------

#define _EBTRB_ON_7H            0xBF    // Boot Block (000000-0001FFh) not protected from table reads executed in other blocks.
#define _EBTRB_OFF_7H           0xFF    // Boot Block (000000-0001FFh) not protected from table reads executed in other blocks.

//==============================================================================

#define __DEVID1                0x3FFFFE
#define __DEVID2                0x3FFFFF

#define __IDLOC0                0x200000
#define __IDLOC1                0x200001
#define __IDLOC2                0x200002
#define __IDLOC3                0x200003
#define __IDLOC4                0x200004
#define __IDLOC5                0x200005
#define __IDLOC6                0x200006
#define __IDLOC7                0x200007

#endif // #ifndef __PIC18LF2331_H__
