/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import javax.swing.text.TabStop;

public class TabSet
implements Serializable {
    private static final long serialVersionUID = 2367703481999080593L;
    TabStop[] tabs;

    public TabStop getTab(int i) {
        return this.tabs[i];
    }

    public TabStop getTabAfter(float location) {
        int idx = this.getTabIndexAfter(location);
        if (idx == -1) {
            return null;
        }
        return this.tabs[idx];
    }

    public int getTabCount() {
        return this.tabs.length;
    }

    public int getTabIndex(TabStop tab) {
        int i = 0;
        while (i < this.tabs.length) {
            if (this.tabs[i] == tab) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getTabIndexAfter(float location) {
        int idx = -1;
        int i = 0;
        while (i < this.tabs.length) {
            if (location < this.tabs[i].getPosition()) {
                idx = i;
            }
            ++i;
        }
        return idx;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        int i = 0;
        while (i < this.tabs.length) {
            if (i != 0) {
                sb.append(" - ");
            }
            sb.append(this.tabs[i].toString());
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public TabSet(TabStop[] t) {
        this.tabs = t;
    }
}

