/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_FILE_H__
#define __SG_FILE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <stdio.h>

gchar *		xml_get_string			(const gchar *input);
FILE *		sg_file_open			(const gchar *filename,
						 const gchar *mode);
gint            sg_file_close			(FILE *stream);
gint		sg_file_printf			(FILE *stream,
						 const gchar *format, ...);
gboolean	sg_file_writeable		(const gchar *path);
gboolean	sg_file_readable		(const gchar *path);

/**
 * System and user paths
 */
gchar *    	sg_sys_lib_dir    		(const gchar *subdir);
gchar *    	sg_sys_data_dir   		(const gchar *subdir);
gchar *    	sg_sys_glade_dir  		(void);
gchar *    	sg_sys_plugin_dir 		(void);

gchar *    	sg_usr_dir        		(const gchar *subdir);
gchar *    	sg_usr_plugin_dir 		(void);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_FILE_H__ */

