/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.TreeMap;
import java.util.Vector;
import org.sablecc.sablecc.StringComparator;

final class Symbol
implements Comparable {
    private static Vector terminals;
    private static Vector nonterminals;
    private static TreeMap names;
    private static boolean modified_;
    private static Symbol[] symbols_;
    private static Symbol[] terminals_;
    private static Symbol[] nonterminals_;
    final String name;
    final String errorName;
    final boolean terminal;
    final int index;

    Symbol(String name, String errorName, boolean terminal) {
        if (names.get(name) != null) {
            throw new IllegalArgumentException("The symbol " + name + " aready exists.");
        }
        if (terminal) {
            terminals.addElement(this);
            this.index = terminals.indexOf(this);
        } else {
            nonterminals.addElement(this);
            this.index = nonterminals.indexOf(this);
        }
        this.name = name;
        this.errorName = errorName;
        this.terminal = terminal;
        names.put(name, this);
        modified_ = true;
    }

    public static void reinit() {
        terminals = new Vector();
        nonterminals = new Vector();
        names = new TreeMap(StringComparator.instance);
        modified_ = true;
        symbols_ = null;
        terminals_ = null;
        nonterminals_ = null;
    }

    static Symbol symbol(String name) {
        return (Symbol)names.get(name);
    }

    static Symbol symbol(int index, boolean terminal) {
        if (terminal) {
            return (Symbol)terminals.elementAt(index);
        }
        return (Symbol)nonterminals.elementAt(index);
    }

    private static void computeArrays() {
        symbols_ = new Symbol[terminals.size() + nonterminals.size()];
        terminals_ = new Symbol[terminals.size()];
        nonterminals_ = new Symbol[nonterminals.size()];
        terminals.copyInto(terminals_);
        nonterminals.copyInto(nonterminals_);
        System.arraycopy(terminals_, 0, symbols_, 0, terminals_.length);
        System.arraycopy(nonterminals_, 0, symbols_, terminals_.length, nonterminals_.length);
        modified_ = false;
    }

    static Symbol[] symbols() {
        if (modified_) {
            Symbol.computeArrays();
        }
        return symbols_;
    }

    static Symbol[] terminals() {
        if (modified_) {
            Symbol.computeArrays();
        }
        return terminals_;
    }

    static Symbol[] nonterminals() {
        if (modified_) {
            Symbol.computeArrays();
        }
        return nonterminals_;
    }

    public String toString() {
        return this.name;
    }

    public int compareTo(Object object) {
        Symbol symbol = (Symbol)object;
        if (this.terminal ^ symbol.terminal) {
            if (this.terminal) {
                return 1;
            }
            return -1;
        }
        return this.index - symbol.index;
    }

    static {
        modified_ = true;
        Symbol.reinit();
    }
}

