/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans;

import htsjdk.samtools.cram.compression.rans.RANSEncodingSymbol;
import htsjdk.samtools.cram.compression.rans.Utils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class E14 {
    E14() {
    }

    static int compress(ByteBuffer inBuffer, RANSEncodingSymbol[][] syms, ByteBuffer outBuffer) {
        int in_size = inBuffer.remaining();
        int rans0 = 0x800000;
        int rans1 = 0x800000;
        int rans2 = 0x800000;
        int rans3 = 0x800000;
        ByteBuffer ptr = outBuffer.slice();
        int isz4 = in_size >> 2;
        int i0 = isz4 - 2;
        int i1 = 2 * isz4 - 2;
        int i2 = 3 * isz4 - 2;
        int i3 = 4 * isz4 - 2;
        int l0 = 0;
        if (i0 + 1 >= 0) {
            l0 = 0xFF & inBuffer.get(i0 + 1);
        }
        int l1 = 0;
        if (i1 + 1 >= 0) {
            l1 = 0xFF & inBuffer.get(i1 + 1);
        }
        int l2 = 0;
        if (i2 + 1 >= 0) {
            l2 = 0xFF & inBuffer.get(i2 + 1);
        }
        int l3 = 0xFF & inBuffer.get(in_size - 1);
        for (i3 = in_size - 2; i3 > 4 * isz4 - 2 && i3 >= 0; --i3) {
            int c3 = 0xFF & inBuffer.get(i3);
            rans3 = syms[c3][l3].putSymbol(rans3, ptr);
            l3 = c3;
        }
        while (i0 >= 0) {
            int c0 = 0xFF & inBuffer.get(i0);
            int c1 = 0xFF & inBuffer.get(i1);
            int c2 = 0xFF & inBuffer.get(i2);
            int c3 = 0xFF & inBuffer.get(i3);
            rans3 = syms[c3][l3].putSymbol(rans3, ptr);
            rans2 = syms[c2][l2].putSymbol(rans2, ptr);
            rans1 = syms[c1][l1].putSymbol(rans1, ptr);
            rans0 = syms[c0][l0].putSymbol(rans0, ptr);
            l0 = c0;
            l1 = c1;
            l2 = c2;
            l3 = c3;
            --i0;
            --i1;
            --i2;
            --i3;
        }
        rans3 = syms[0][l3].putSymbol(rans3, ptr);
        rans2 = syms[0][l2].putSymbol(rans2, ptr);
        rans1 = syms[0][l1].putSymbol(rans1, ptr);
        rans0 = syms[0][l0].putSymbol(rans0, ptr);
        ptr.order(ByteOrder.BIG_ENDIAN);
        ptr.putInt(rans3);
        ptr.putInt(rans2);
        ptr.putInt(rans1);
        ptr.putInt(rans0);
        ptr.flip();
        int compressedBlobSize = ptr.limit();
        Utils.reverse(ptr);
        inBuffer.position(inBuffer.limit());
        return compressedBlobSize;
    }
}

