package org.cdavies.itunes.request;

import java.net.*;
import java.io.*;

import itunes.FieldPair;

public class LegacyTrackRequest extends Request implements TrackRequest {
	
	private BufferedInputStream _buf;
	
	public LegacyTrackRequest(String server, int port, int sessionId, int dbId, int trackId, String songFmt) {
		
		super(server, port, "databases/" +  dbId  + "/items/" + trackId + "." + songFmt + "?session-id=" + sessionId);
		
	}
	
	public void runQuery() throws NoServerPermissionException {
		
		try {
			
			int _len = _conn.getContentLength();
			
			if (_len == -1)
				return;
			else if (_len == 0)
				throw new NoServerPermissionException("Cannot get input stream for track");
			
			_buf = new BufferedInputStream(_conn.getInputStream());
			
		} 
		catch (MalformedURLException _e) {
			
			/* Should never happen */
			_e.printStackTrace();
			System.exit(1);
			
		} 
		catch (IOException _e) {
			
			throw new NoServerPermissionException(_e.getMessage());
			
		}
		
	}
	
	public void process() { /* NOOP in this class */  }
	
	public InputStream getInputStream() {
		
		return _buf;
		
	}

}
