/*
   BAREOS® - Backup Archiving REcovery Open Sourced

   Copyright (C) 2012-2012 Free Software Foundation Europe e.V.
   Copyright (C) 2011-2012 Planets Communications B.V.
   Copyright (C) 2013-2020 Bareos GmbH & Co. KG

   This program is Free Software; you can redistribute it and/or
   modify it under the terms of version three of the GNU Affero General Public
   License as published by the Free Software Foundation and included
   in the file LICENSE.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   Affero General Public License for more details.

   You should have received a copy of the GNU Affero General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
   02110-1301, USA.
*/

// clang-format off
#ifndef BAREOS_INCLUDE_CONFIG_H_
#define BAREOS_INCLUDE_CONFIG_H_ 1

#define BAREOS "Bareos"
#define FD_DEFAULT_PORT "9102"
#define SD_DEFAULT_PORT "9103"
#define DIR_DEFAULT_PORT "9101"
#define NDMP_DEFAULT_PORT "10000"

#if defined(HAVE_WIN32)
#  include "mingwconfig.h"
#define _POSIX_C_SOURCE 1
extern char win_os[];
#  define PLATFORM "Cross-compile"
#  if defined(_WIN64)
#    define DISTVER "Win64"
#  else
#    define DISTVER "Win32"
#  endif
#else

// Where are Bareos config files stored
#define CONFDIR "/usr/pkg/etc/bareos"

// Define to 1 if you want the Developer mode enabled
/* #undef DEVELOPER */

/* Define to 1 if translation of program messages to the user's native
 * language is requested */
#define ENABLE_NLS 1

// Define to 1 for pthread_attr_get_np() instead of pthread_getattr_np()
#define HAVE_PTHREAD_ATTR_GET_NP 1

// Define to 1 if pthread_*_np() are in a seperate header
/* #undef HAVE_PTHREAD_NP_H */

// Define to 1 if you want Normal acl support
/* #undef HAVE_ACL */

// Define to 1 if you want PAM support
#define HAVE_PAM 1

// Defines if your system have the ACL_TYPE_DEFAULT_DIR acl type
/* #undef HAVE_ACL_TYPE_DEFAULT_DIR */

// Defines if your system have the ACL_TYPE_EXTENDED acl type
/* #undef HAVE_ACL_TYPE_EXTENDED */

// Defines if your system have the ACL_TYPE_NFS4 acl type
/* #undef HAVE_ACL_TYPE_NFS4 */

// Define to 1 if you have the `add_proplist_entry' function
/* #undef HAVE_ADD_PROPLIST_ENTRY */

// Define to 1 if your system has AFS support
/* #undef HAVE_AFS */

// Andrew FileSystem ACL support
// FIXME: this is used, but never configured
/* #undef HAVE_AFS_ACL */

// Define to 1 if you have the <afs/afsint.h> header file
/* #undef HAVE_AFS_AFSINT_H */

// Define to 1 if you have the <afs/venus.h> header file
/* #undef HAVE_AFS_VENUS_H */

// Define to 1 if you are running AIX
/* #undef HAVE_AIX_OS */

// Define to 1 if you have <alloca.h> and it should be used (not on Ultrix)
/* #undef HAVE_ALLOCA_H */

// Define to 1 if you have the <arpa/nameser.h> header file
#define HAVE_ARPA_NAMESER_H 1

// Define to 1 if you have the <attr.h> header file
/* #undef HAVE_ATTR_H */

// Define to 1 if you have the `backtrace' function
/* #undef HAVE_BACKTRACE */

// Define to 1 if you have the `backtrace_symbols' function
/* #undef HAVE_BACKTRACE_SYMBOLS */

// Big Endian
#define HAVE_BIG_ENDIAN 1

// Define to 1 if you have cephfs lib
/* #undef HAVE_CEPHFS */

// Define to 1 if you have cephfs/ceph_stat_x.h header
/* #undef HAVE_CEPH_STATX */

// Define to 1 if you have the `chflags' function
/* #undef HAVE_CHFLAGS */

// Define to 1 if you have the `closefrom' function
#define HAVE_CLOSEFROM 1

// Define to 1 if you have compressBound
#define HAVE_COMPRESS_BOUND 1

// Define to 1 if cplus_demangle exists in libdemangle
/* #undef HAVE_CPLUS_DEMANGLE */

// Define to 1 if encryption support should be enabled
#define HAVE_CRYPTO 1

// Define to 1 if you have the <cxxabi.h> header file
#define HAVE_CXXABI_H 1

// Define to 1 if you are running OSX
/* #undef HAVE_DARWIN_OS */

// Define to 1 if you have the <demangle.h> header file
/* #undef HAVE_DEMANGLE_H */

// Define to 1 if dynamic loading of catalog backends is enabled
#define HAVE_DYNAMIC_CATS_BACKENDS 1

// Define to 1 if dynamic loading of storage backends is enabled
#define HAVE_DYNAMIC_SD_BACKENDS 1

// Define to 1 if OpenSSL library has ENGINE_load_pk11 available
/* #undef HAVE_ENGINE_LOAD_PK11 */

// Define to 1 if you have the <execinfo.h> header file
#define HAVE_EXECINFO_H 1

// Define to 1 if you have the `extattr_get_file' function
#define HAVE_EXTATTR_GET_FILE 1

// Define to 1 if you have the `extattr_get_link' function
#define HAVE_EXTATTR_GET_LINK 1

// Define to 1 if you have the `extattr_list_file' function
#define HAVE_EXTATTR_LIST_FILE 1

// Define to 1 if you have the `extattr_list_link' function
#define HAVE_EXTATTR_LIST_LINK 1

// Define to 1 if you have the `extattr_namespace_to_string' function
#define HAVE_EXTATTR_NAMESPACE_TO_STRING 1

// Define to 1 if you have the `extattr_set_file' function
#define HAVE_EXTATTR_SET_FILE 1

// Define to 1 if you have the `extattr_set_link' function
#define HAVE_EXTATTR_SET_LINK 1

// Define to 1 if you have the `extattr_string_to_namespace' function
#define HAVE_EXTATTR_STRING_TO_NAMESPACE 1

// Define to 1 if you want Extended acl support
/* #undef HAVE_EXTENDED_ACL */

// Define to 1 if you have the `fchmod' function
#define HAVE_FCHMOD 1

// Define to 1 if you have the `fchown' function
#define HAVE_FCHOWN 1

// Define to 1 if you have the `fchownat' function
#define HAVE_FCHOWNAT 1

// Define to 1 if you have the fcntl F_CLOSEM flag
/* #undef HAVE_FCNTL_F_CLOSEM */

// Define to 1 if you have the `fdatasync' function
#define HAVE_FDATASYNC 1

// Define to 1 if you are running FreeBSD
/* #undef HAVE_FREEBSD_OS */

// Define to 1 if you have the `fseeko' function
#define HAVE_FSEEKO 1

// Define to 1 if you have the `futimens' function
#define HAVE_FUTIMENS 1

// Define to 1 if you have the `futimes' function
#define HAVE_FUTIMES 1

// Define to 1 if you have the `futimesat' function
/* #undef HAVE_FUTIMESAT */

// Define to 1 if you use gcc
#define HAVE_GCC 1

// Define to 1 if you have the `getaddrinfo' function
#define HAVE_GETADDRINFO 1

// Define to 1 if you have the `getea' function
/* #undef HAVE_GETEA */

// Define to 1 if you have the `gethostbyname2' function
#define HAVE_GETHOSTBYNAME2 1

// Define to 1 if you have the `getmntent' function
/* #undef HAVE_GETMNTENT */

// Define to 1 if you have the `getmntinfo' function
#define HAVE_GETMNTINFO 1

// Define to 1 if you have the `getpagesize' function
#define HAVE_GETPAGESIZE 1

// Define to 1 if you have the `getproplist' function
/* #undef HAVE_GETPROPLIST */

// Define to 1 if you have the `getxattr' function
#define HAVE_GETXATTR 1

// Define to 1 if you have the `get_proplist_entry' function
/* #undef HAVE_GET_PROPLIST_ENTRY */

// Define to 1 if you have gfapi lib
/* #undef HAVE_GFAPI */

// Define to 1 if the `glfs_ftruncate' function has four arguments
/* #undef GLFS_FTRUNCATE_HAS_FOUR_ARGS */

// Define to 1 if you have the `glfs_readdirplus' function
/* #undef HAVE_GLFS_READDIRPLUS */

// Define to 1 if you have the `glob' function
#define HAVE_GLOB 1

// Define to 1 if you have the <grp.h> header file
#define HAVE_GRP_H 1

// Define to 1 if you are running HPUX
/* #undef HAVE_HPUX_OS */

// Define to 1 if you are running GNU Hurd
/* #undef HAVE_HURD_OS */

// Define to 1 if you have the `inet_ntop' function
#define HAVE_INET_NTOP 1

// Define to 1 if ioctl request is unsigned long int
/* #undef HAVE_IOCTL_ULINT_REQUEST */

// Define to 1 if IPv6 support should be enabled
#define HAVE_IPV6 1

// Define to 1 if you are running IRIX
/* #undef HAVE_IRIX_OS */

// Define HAVE_IS_TRIVIALLY_COPYABLE if compiler has type trait is_trivially_copyable
#define HAVE_IS_TRIVIALLY_COPYABLE

// Define to 1 if you have jansson lib
#define HAVE_JANSSON 1

// Define to 1 if you have the `lchmod' function
#define HAVE_LCHMOD 1

// Define to 1 if you have the `lchown' function
#define HAVE_LCHOWN 1

// Define to 1 if you have the `lgetea' function
/* #undef HAVE_LGETEA */

// Define to 1 if you have the `lgetxattr' function
#define HAVE_LGETXATTR 1

// Define to 1 if you have libcap
/* #undef HAVE_LIBCAP */

// Define to 1 if you have the `util' library (-lutil)
#define HAVE_LIBUTIL 1

// Define to 1 if you have the <libutil.h> header file
/* #undef HAVE_LIBUTIL_H */

// Define to 1 if you have zlib
#define HAVE_LIBZ 1

// Define to 1 if you are running Linux
/* #undef HAVE_LINUX_OS */

// Define to 1 if you have the `listea' function
/* #undef HAVE_LISTEA */

// Define to 1 if you have the `listxattr' function
#define HAVE_LISTXATTR 1

// Define to 1 if you have the `llistea' function
/* #undef HAVE_LLISTEA */

// Define to 1 if you have the `llistxattr' function
#define HAVE_LLISTXATTR 1

// Define to 1 if LMDB support should be enabled
#define HAVE_LMDB 1

// Define to 1 if you have the `localtime_r' function
#define HAVE_LOCALTIME_R 1

// Define if you have the 'long double' type
/* #undef HAVE_LONG_DOUBLE */

// Low level SCSI Interface support
/* #undef HAVE_LOWLEVEL_SCSI_INTERFACE */

// Define to 1 if you have the `lsetea' function
/* #undef HAVE_LSETEA */

// Define to 1 if you have the `lsetxattr' function
#define HAVE_LSETXATTR 1

// Define to 1 if you have the `lutimes' function
#define HAVE_LUTIMES 1

// Define to 1 if you have lzo lib
#define HAVE_LZO 1

// Define to 1 if you have the <mtio.h> header file
/* #undef HAVE_MTIO_H */

// Set if you have an MySQL Database
/* #undef HAVE_MYSQL */

// Set if have mysql_thread_safe
#define HAVE_MYSQL_THREAD_SAFE 1

// Define to 1 if you have the `nanosleep' function
#define HAVE_NANOSLEEP 1

// Define to 1 if NDMP support should be enabled
/* #undef HAVE_NDMP */

// Define to 1 if you are running NetBSD
#define HAVE_NETBSD_OS 1

// Define to 1 to when walkcontext does not work
/* #undef HAVE_NON_WORKING_WALKCONTEXT */

// Define to 1 to use the old sockopt option
/* #undef HAVE_OLD_SOCKOPT */

// Define to 1 if you have the `openat' function
#define HAVE_OPENAT 1

// Define to 1 if you are running OpenBSD
/* #undef HAVE_OPENBSD_OS */

// Define to 1 if OpenSSL library is available
#define HAVE_OPENSSL 1

// Define to 1 if you are running Tru64
/* #undef HAVE_OSF1_OS */

// Define to 1 if you have the `poll' function
#define HAVE_POLL 1

// Define to 1 if you have the <poll.h> header file
#define HAVE_POLL_H 1

// Define to 1 if you have the `posix_fadvise' function
#define HAVE_POSIX_FADVISE 1

// Set if you have an PostgreSQL Database
#define HAVE_POSTGRESQL 1

// Set if PostgreSQL DB batch insert code enabled
#define HAVE_POSTGRESQL_BATCH_FILE_INSERT 1

// Set if have PQisthreadsafe
#define HAVE_PQISTHREADSAFE 1

// Define to 1 if you have the `prctl' function
/* #undef HAVE_PRCTL */

// Define to 1 if you have the `putenv' function
#define HAVE_PUTENV 1

// Define to 1 if you have the <pwd.h> header file
#define HAVE_PWD_H 1

// Define to 1 if python support should be enabled
#define HAVE_PYTHON 1

// Define to 1 if you have rados lib
/* #undef HAVE_RADOS */

// Define to 1 if you have support for RADOS namespaces
/* #undef HAVE_RADOS_NAMESPACES */

// Define to 1 if you have support for RADOS NObject List API
/* #undef HAVE_RADOS_NOBJECTS_LIST */

// Define to 1 if you have radosstriper lib
/* #undef HAVE_RADOS_STRIPER */

// Define to 1 if you have the `readdir_r' function
#define HAVE_READDIR_R 1

// Define to 1 if you have the <regex.h> header file
#define HAVE_REGEX_H 1

// Define to 1 if you have the `setea' function
/* #undef HAVE_SETEA */

// Define to 1 if you have the `setenv' function
#define HAVE_SETENV 1

// Define to 1 if you have the `setproplist' function
/* #undef HAVE_SETPROPLIST */

// Define to 1 if you have the `setreuid' function
#define HAVE_SETREUID 1

// Define to 1 if you have the `setxattr' function
#define HAVE_SETXATTR 1

// Define to 1 if the SHA-2 family of digest algorithms is available
#define HAVE_SHA2 1

// Define to 1 if you have the `sizeof_proplist_entry' function
/* #undef HAVE_SIZEOF_PROPLIST_ENTRY */

// Set if you have an SQLite3 Database
/* #undef HAVE_SQLITE3 */

// Define to 1 if you have the `sqlite3_threadsafe' function
#define HAVE_SQLITE3_THREADSAFE 1

// Define to 1 if you are running Solaris
/* #undef HAVE_SUN_OS */

// Define to 1 if systemd support should be enabled
/* #undef HAVE_SYSTEMD */

// Define to 1 if you have the <sys/acl.h> header file
/* #undef HAVE_SYS_ACL_H */

// Define to 1 if you have the <sys/attr.h> header file
/* #undef HAVE_SYS_ATTR_H */

// Define to 1 if you have the <sys/bitypes.h> header file
/* #undef HAVE_SYS_BITYPES_H */

// Define to 1 if you have the <sys/capability.h> header file
/* #undef HAVE_SYS_CAPABILITY_H */

// Define to 1 if you have the <sys/ea.h> header file
/* #undef HAVE_SYS_EA_H */

// Define to 1 if you have the <sys/extattr.h> header file
#define HAVE_SYS_EXTATTR_H 1

// Define to 1 if you have the <sys/mman.h> header file
#undef HAVE_SYS_MMAN_H

// Define to 1 if you have the <sys/mtio.h> header file
#define HAVE_SYS_MTIO_H 1

// Define to 1 if you have the <sys/nvpair.h> header file
/* #undef HAVE_SYS_NVPAIR_H */

// Define to 1 if you have the <sys/poll.h> header file
#define HAVE_SYS_POLL_H 1

// Define to 1 if you have the <sys/prctl.h> header file
/* #undef HAVE_SYS_PRCTL_H */

// Define to 1 if you have the <sys/proplist.h> header file
/* #undef HAVE_SYS_PROPLIST_H */

// Define to 1 if you have the <sys/statvfs.h> header file
#define HAVE_SYS_STATVFS_H 1

// Define to 1 if you have the <sys/tape.h> header file
#define HAVE_SYS_TAPE_H 1

// Define to 1 if you have the <sys/time.h> header file
#define HAVE_SYS_TIME_H 1

// Define to 1 if you have the <sys/xattr.h> header file
#define HAVE_SYS_XATTR_H 1

// Define to 1 if TLS support should be enabled
#define HAVE_TLS 1

// Define to 1 if compiler has typeof
/* #undef HAVE_TYPEOF */

// Define to 1 if you have the <ucontext.h> header file
#define HAVE_UCONTEXT_H 1

// Define to 1 if you have the <umem.h> header file
/* #undef HAVE_UMEM_H */

// Define to 1 if you have the `unlinkat' function
#define HAVE_UNLINKAT 1

// Define to 1 if you have the `utimes' function
#define HAVE_UTIMES 1

// Extended Attributes support
#define HAVE_XATTR 1

// Define to 1 if you have the <zlib.h> header file
#define HAVE_ZLIB_H 1

// Where are shared libs stored
/* #undef LIBDIR */

// Where are locale files stored
#define LOCALEDIR "share/locale"

// Define to the full name of this package
#define PACKAGE_NAME "bareos"

// Where are system config files stored
#define SYSCONFDIR "/usr/pkg/etc"

// Define to 1 if you can safely include both <sys/time.h> and <time.h>
/* #undef TIME_WITH_SYS_TIME */

// Define to 1 if DB batch insert code enabled
#define USE_BATCH_FILE_INSERT 1

// Number of bits in a file offset, on hosts where this is settable
#define _FILE_OFFSET_BITS 64

// Define to make fseeko etc. visible, on some hosts
#define _LARGEFILE_SOURCE 1

// Define for large files, on AIX-style hosts
#define _LARGE_FILES 1

// Directory for backend files
#define PATH_BAREOS_BACKENDDIR "/usr/pkg/lib/bareos/backends"

// Directory for PID files
#define PATH_BAREOS_PIDDIR "/var/run/bareos"

// Directory for daemon files
#define PATH_BAREOS_WORKINGDIR "/var/db/bareos/working"

#define PLATFORM "netbsd"
#define DISTVER "9.0"

#endif /* defined(WIN32) */
// clang-format on

#endif /* BAREOS_INCLUDE_CONFIG_H_ */
