require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_SCHED_H_)) {
    eval 'sub _SYS_SCHED_H_ () {1;}' unless defined(&_SYS_SCHED_H_);
    require 'sys/featuretest.ph';
    require 'sys/types.ph';
    if(defined(&_KERNEL_OPT)) {
	require './sys/opt_multiprocessor.ph';
	require './sys/opt_lockdebug.ph';
    }
    eval 'sub SCHED_NONE () {-1;}' unless defined(&SCHED_NONE);
    eval 'sub SCHED_OTHER () {0;}' unless defined(&SCHED_OTHER);
    eval 'sub SCHED_FIFO () {1;}' unless defined(&SCHED_FIFO);
    eval 'sub SCHED_RR () {2;}' unless defined(&SCHED_RR);
    if(defined(&_NETBSD_SOURCE)) {
	unless(defined(&_KERNEL)) {
	    eval 'sub cpuset_create () {
	        eval q( &_cpuset_create());
	    }' unless defined(&cpuset_create);
	    eval 'sub cpuset_destroy {
	        my($c) = @_;
    		eval q( &_cpuset_destroy($c));
	    }' unless defined(&cpuset_destroy);
	    eval 'sub cpuset_size {
	        my($c) = @_;
    		eval q( &_cpuset_size($c));
	    }' unless defined(&cpuset_size);
	    eval 'sub cpuset_zero {
	        my($c) = @_;
    		eval q( &_cpuset_zero($c));
	    }' unless defined(&cpuset_zero);
	    eval 'sub cpuset_isset {
	        my($i, $c) = @_;
    		eval q( &_cpuset_isset($i, $c));
	    }' unless defined(&cpuset_isset);
	    eval 'sub cpuset_set {
	        my($i, $c) = @_;
    		eval q( &_cpuset_set($i, $c));
	    }' unless defined(&cpuset_set);
	    eval 'sub cpuset_clr {
	        my($i, $c) = @_;
    		eval q( &_cpuset_clr($i, $c));
	    }' unless defined(&cpuset_clr);
	}
	eval 'sub CP_USER () {0;}' unless defined(&CP_USER);
	eval 'sub CP_NICE () {1;}' unless defined(&CP_NICE);
	eval 'sub CP_SYS () {2;}' unless defined(&CP_SYS);
	eval 'sub CP_INTR () {3;}' unless defined(&CP_INTR);
	eval 'sub CP_IDLE () {4;}' unless defined(&CP_IDLE);
	eval 'sub CPUSTATES () {5;}' unless defined(&CPUSTATES);
	if(defined(&_KERNEL) || defined(&_KMEMUSER)) {
	    require 'sys/mutex.ph';
	    require 'sys/time.ph';
	    eval 'sub SPCF_SEENRR () {0x1;}' unless defined(&SPCF_SEENRR);
	    eval 'sub SPCF_SHOULDYIELD () {0x2;}' unless defined(&SPCF_SHOULDYIELD);
	    eval 'sub SPCF_OFFLINE () {0x4;}' unless defined(&SPCF_OFFLINE);
	    eval 'sub SPCF_RUNNING () {0x8;}' unless defined(&SPCF_RUNNING);
	    eval 'sub SPCF_NOINTR () {0x10;}' unless defined(&SPCF_NOINTR);
	    eval 'sub SPCF_SWITCHCLEAR () {( &SPCF_SEENRR| &SPCF_SHOULDYIELD);}' unless defined(&SPCF_SWITCHCLEAR);
	}
	eval 'sub CLONE_CSIGNAL () {0xff;}' unless defined(&CLONE_CSIGNAL);
	eval 'sub CLONE_VM () {0x100;}' unless defined(&CLONE_VM);
	eval 'sub CLONE_FS () {0x200;}' unless defined(&CLONE_FS);
	eval 'sub CLONE_FILES () {0x400;}' unless defined(&CLONE_FILES);
	eval 'sub CLONE_SIGHAND () {0x800;}' unless defined(&CLONE_SIGHAND);
	eval 'sub CLONE_PID () {0x1000;}' unless defined(&CLONE_PID);
	eval 'sub CLONE_PTRACE () {0x2000;}' unless defined(&CLONE_PTRACE);
	eval 'sub CLONE_VFORK () {0x4000;}' unless defined(&CLONE_VFORK);
    }
    if(defined(&_KERNEL)) {
    }
}
1;
