/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqbody;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.bean.ContentType;
import org.wiztools.restclient.bean.ReqEntityFilePartBean;
import org.wiztools.restclient.ui.FileChooserType;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.ui.dnd.DndAction;
import org.wiztools.restclient.ui.dnd.FileDropTargetListener;
import org.wiztools.restclient.ui.reqbody.AddMultipartBaseDialog;
import org.wiztools.restclient.ui.reqbody.AddMultipartPartListener;
import org.wiztools.restclient.ui.reqbody.ContentTypeCharsetComponent;
import org.wiztools.restclient.ui.reqbody.ContentTypeSelectorOnFile;

public class AddMultipartFileDialog
extends AddMultipartBaseDialog {
    @Inject
    private ContentTypeCharsetComponent jp_contentType;
    private final JTextField jtf_name = new JTextField(26);
    private final JTextField jtf_fileName = new JTextField(26);
    private final JTextField jtf_file = new JTextField(26);
    private final JButton jb_file = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/load_from_file.png"));
    private final JButton jb_add = new JButton("Add");
    private final JButton jb_addAndClose = new JButton("Add & close");
    private final JButton jb_cancel = new JButton("Cancel");

    @Inject
    public AddMultipartFileDialog(RESTUserInterface rest_ui) {
        super(rest_ui);
        this.setTitle("Add Multipart File");
    }

    @PostConstruct
    protected void init() {
        FileDropTargetListener l = new FileDropTargetListener();
        l.addDndAction(new DndAction(){

            @Override
            public void onDrop(List<File> files) {
                AddMultipartFileDialog.this.selectFile(files.get(0));
            }
        });
        new DropTarget(this.jtf_file, l);
        new DropTarget(this.jb_file, l);
        this.jb_add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddMultipartFileDialog.this.add();
            }
        });
        this.jb_addAndClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddMultipartFileDialog.this.addAndClose();
            }
        });
        this.jb_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddMultipartFileDialog.this.cancel();
            }
        });
        this.jb_file.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddMultipartFileDialog.this.selectFile();
            }
        });
        this.getRootPane().setDefaultButton(this.jb_add);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        JPanel jp = new JPanel(new BorderLayout());
        JPanel jp_west = new JPanel(new GridLayout(4, 2));
        jp_west.add(new JLabel(" Content type: "));
        jp_west.add(new JLabel(" Name: "));
        jp_west.add(new JLabel(" File name: "));
        jp_west.add(new JLabel(" File: "));
        jp.add((Component)jp_west, "West");
        JPanel jp_center = new JPanel(new GridLayout(4, 2));
        jp_center.add(this.jp_contentType.getComponent());
        jp_center.add(UIUtil.getFlowLayoutPanelLeftAligned(this.jtf_name));
        jp_center.add(UIUtil.getFlowLayoutPanelLeftAligned(this.jtf_fileName));
        JPanel jp_file = new JPanel(new FlowLayout(0));
        jp_file.add(this.jtf_file);
        jp_file.add(this.jb_file);
        jp_center.add(jp_file);
        jp.add((Component)jp_center, "Center");
        c.add((Component)jp, "Center");
        jp = new JPanel();
        jp.setLayout(new FlowLayout(2));
        jp.add(this.jb_cancel);
        jp.add(this.jb_add);
        jp.add(this.jb_addAndClose);
        c.add((Component)jp, "South");
        this.pack();
    }

    private void selectFile() {
        File f = this.rest_ui.getOpenFile(FileChooserType.OPEN_REQUEST_BODY);
        this.selectFile(f);
    }

    private void selectFile(File f) {
        if (f == null) {
            return;
        }
        if (!f.canRead()) {
            JOptionPane.showMessageDialog(this.rest_ui.getFrame(), "File not readable: " + f.getAbsolutePath(), "IO Error", 0);
            return;
        }
        ContentTypeSelectorOnFile.select(this.jp_contentType, f, this);
        if (StringUtil.isEmpty(this.jtf_fileName.getText())) {
            this.jtf_fileName.setText(f.getName());
        }
        this.jtf_file.setText(f.getAbsolutePath());
    }

    private boolean add() {
        if (StringUtil.isEmpty(this.jtf_name.getText())) {
            JOptionPane.showMessageDialog(this, "Name must be present!", "Validation: name empty!", 0);
            this.jtf_name.requestFocus();
            return false;
        }
        if (StringUtil.isEmpty(this.jtf_fileName.getText())) {
            JOptionPane.showMessageDialog(this, "File name must be present!", "Validation: filename empty!", 0);
            this.jtf_fileName.requestFocus();
            return false;
        }
        String name = this.jtf_name.getText();
        String fileName = this.jtf_fileName.getText();
        ContentType ct = this.jp_contentType.getContentType();
        File file = new File(this.jtf_file.getText());
        ReqEntityFilePartBean part = new ReqEntityFilePartBean(name, fileName, ct, file);
        for (AddMultipartPartListener l : this.listeners) {
            l.addPart(part);
        }
        this.clear();
        this.jb_file.requestFocus();
        return true;
    }

    private void addAndClose() {
        if (this.add()) {
            this.setVisible(false);
        }
    }

    private void cancel() {
        this.clear();
        this.setVisible(false);
    }

    @Override
    public void clear() {
        this.jp_contentType.clear();
        this.jtf_name.setText("");
        this.jtf_fileName.setText("");
        this.jtf_file.setText("");
    }

    @Override
    public void setVisible(boolean boo) {
        this.jp_contentType.requestFocus();
        super.setVisible(boo);
    }
}

