var message_url = sbRoot + '/ui/get-messages',
	test = !1;

PNotify.prototype.options.addclass = 'stack-bottomright';
PNotify.prototype.options.buttons.closer_hover = !1;
PNotify.prototype.options.delay = 5000;
PNotify.prototype.options.desktop = {desktop: !0, icon: 'data:image/png;base64,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'};
PNotify.prototype.options.hide = !0;
PNotify.prototype.options.history = !1;
PNotify.prototype.options.shadow = !1;
PNotify.prototype.options.stack = {dir1: 'up', dir2: 'left', firstpos1: 25, firstpos2: 25};
PNotify.prototype.options.styling = 'jqueryui';
PNotify.prototype.options.width = '340px';
PNotify.desktop.permission();

function displayPNotify(type, title, message) {
	var notification = new PNotify({
		type: type, title: title,
		text: message.replace(/<br[\s\/]*(?:\s[^>]*)?>/ig, "\n")
			.replace(/<[\/]?b(?:\s[^>]*)?>/ig, '*')
			.replace(/<i(?:\s[^>]*)?>/ig, '[').replace(/<[\/]i>/ig, ']')
			.replace(/<(?:[\/]?ul|\/li)(?:\s[^>]*)?>/ig, '').replace(/<li(?:\s[^>]*)?>/ig, "\n" + '* ')
	});
}

function check_notifications() {
	if ('visible' == document.visibilityState) {
		$.getJSON(message_url, function (data) {
			$.each(data, function (name, data) {
				displayPNotify(data.type, data.title, data.message)
			});
		});
	}
	setTimeout(check_notifications, 3000)
}

$(document).ready(function(){
	check_notifications();
	if (test) {
		displayPNotify('notice', 'test', 'test<br/><i class="test-class">hello <b>world</b></i><ul><li>item 1</li><li>item 2</li></ul>');
		//setInterval(function () {displayPNotify('success', 'test2', 'test<br/><b>body2</b>')}, 2000);
		//setInterval(function () {displayPNotify('error', 'test3', 'hola<br/><b>body2</b>')}, 2100);
	}
});
