/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.style;

import writer2latex.latex.Context;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.style.BeforeAfter;
import writer2latex.latex.style.StyleConverter;
import writer2latex.office.SectionStyle;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.Config;

public class SectionStyleConverter
extends StyleConverter {
    private boolean bNeedMulticol = false;

    public SectionStyleConverter(WriterStyleCollection wsc, Config config, ConverterPalette palette) {
        super(wsc, config, palette);
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bNeedMulticol) {
            pack.append("\\usepackage{multicol}").nl();
        }
    }

    public void applySectionStyle(String sStyleName, BeforeAfter ba, Context context) {
        SectionStyle style = this.wsc.getSectionStyle(sStyleName);
        if (context.isInMulticols() || style == null || style.getColCount() < 2) {
            return;
        }
        int nCols = style.getColCount();
        this.bNeedMulticol = true;
        context.setInMulticols(true);
        ba.add("\\begin{multicols}{" + (nCols > 10 ? 10 : nCols) + "}", "\\end{multicols}");
    }
}

