/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_PLUGIN_ARRAY_H__
#define __SG_PLUGIN_ARRAY_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_application.h"
#include "sg_plugin.h"

#define SG_PLUGIN_ARRAY(obj)        GTK_CHECK_CAST (obj, sg_plugin_array_get_type (), SGpluginArray)
#define GTK_TYPE_SG_PLUGIN_ARRAY   (sg_plugin_array_get_type ())

#define SG_PLUGIN_ARRAY_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, sg_plugin_array_get_type(), SGpluginArrayClass)
#define GTK_IS_SG_PLUGIN_ARRAY(obj)     GTK_CHECK_TYPE (obj, sg_plugin_array_get_type ())


typedef struct _SGpluginArray   SGpluginArray;
typedef struct _SGpluginArrayClass   SGpluginArrayClass;
typedef GtkPlotArray* (*SGpluginArrayFunction)  (SGpluginArray *plugin, SGapplication *app, gpointer data);

struct _SGpluginArray
{
  SGplugin plugin;

  SGpluginArrayFunction action; 
};

struct _SGpluginArrayClass
{
  SGpluginClass parent_class;
};

GtkType		sg_plugin_array_get_type	();
SGpluginArray *	sg_plugin_array_new		();
GtkPlotArray *  sg_plugin_array_action		(SGpluginArray *plugin, 
						 SGapplication *app, 
						 gpointer data);
SGpluginArray *  sg_plugin_array_get		(const gchar *name);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_PLUGIN_ARRAY_H__ */

