/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.sablecc.sablecc.MacroExpander;
import org.sablecc.sablecc.ResolveAstIds;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.AAstProd;

public class GenProds
extends DepthFirstAdapter {
    private MacroExpander macros;
    private ResolveAstIds ast_ids;
    private File pkgDir;
    private String pkgName;

    public GenProds(ResolveAstIds ast_ids) {
        this.ast_ids = ast_ids;
        try {
            this.macros = new MacroExpander(new InputStreamReader(this.getClass().getResourceAsStream("productions.txt")));
        }
        catch (IOException e) {
            throw new RuntimeException("unable to open productions.txt.");
        }
        this.pkgDir = new File(ast_ids.astIds.pkgDir, "node");
        String string = this.pkgName = ast_ids.astIds.pkgName.equals("") ? "node" : ast_ids.astIds.pkgName + ".node";
        if (!this.pkgDir.exists() && !this.pkgDir.mkdir()) {
            throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
        }
    }

    @Override
    public void inAAstProd(AAstProd node) {
        String name = (String)this.ast_ids.ast_names.get(node);
        this.createProduction(name);
    }

    private void createProduction(String name) {
        BufferedWriter file;
        try {
            file = new BufferedWriter(new FileWriter(new File(this.pkgDir, name + ".java")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, name + ".java").getAbsolutePath());
        }
        try {
            this.macros.apply(file, "Production", new String[]{this.pkgName, name});
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, name + ".java").getAbsolutePath());
        }
        try {
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

