/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.LinkedList;
import java.util.Map;
import org.sablecc.sablecc.Cast;
import org.sablecc.sablecc.NodeCast;
import org.sablecc.sablecc.StringCast;
import org.sablecc.sablecc.TypedHashMap;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.AAlt;
import org.sablecc.sablecc.node.AAltTransform;
import org.sablecc.sablecc.node.AElem;
import org.sablecc.sablecc.node.AProd;
import org.sablecc.sablecc.node.ASimpleListTerm;
import org.sablecc.sablecc.node.ASimpleTerm;
import org.sablecc.sablecc.node.PTerm;
import org.sablecc.sablecc.node.TId;

public class In_Production {
    private String name;
    private String[] prodTransformElems;
    private int nbAlts;
    private In_Alternative[] alternatives;

    public In_Production(AProd prod) {
        this.setName(prod.getId().getText());
        AElem[] prodTransforms = prod.getProdTransform().toArray(new AElem[0]);
        this.prodTransformElems = new String[prodTransforms.length];
        for (int i = 0; i < prodTransforms.length; ++i) {
            this.prodTransformElems[i] = prodTransforms[i].getElemName() != null ? prodTransforms[i].getElemName().getText() : prodTransforms[i].getId().getText();
        }
        if (prodTransforms.length == 0) {
            this.prodTransformElems = new String[1];
            this.prodTransformElems[0] = new String("  ");
        }
        AAlt[] alts = prod.getAlts().toArray(new AAlt[0]);
        this.alternatives = new In_Alternative[alts.length];
        for (int i = 0; i < alts.length; ++i) {
            this.addAlternative(i, new In_Alternative(alts[i], this.prodTransformElems, this.name));
        }
        this.nbAlts = alts.length;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getNbAlts() {
        return this.nbAlts;
    }

    public void addAlternative(int position, In_Alternative alt) {
        this.alternatives[position] = alt;
    }

    public In_Alternative getAlternative(int position) {
        return this.alternatives[position];
    }

    class In_Alternative {
        String name;
        int nbElems;
        AElem[] elements;
        Map prodTransform_altTransform;

        In_Alternative(AAlt alt, String[] prodTransformElems, String prodName) {
            this.setName(alt.getAltName() != null ? alt.getAltName().getText() : "");
            this.elements = new AElem[alt.getElems().size()];
            AElem[] listOfElems = alt.getElems().toArray(new AElem[0]);
            final String newElemName = this.name.equals("") ? prodName : prodName + "#" + this.name;
            for (int i = 0; i < listOfElems.length; ++i) {
                AElem tmpElem = (AElem)listOfElems[i].clone();
                if (tmpElem.getElemName() != null) {
                    tmpElem.setElemName(new TId(newElemName + "#" + tmpElem.getElemName().getText()));
                } else {
                    tmpElem.setElemName(new TId(newElemName + "#" + tmpElem.getId().getText()));
                }
                this.addElem(i, tmpElem);
            }
            this.nbElems = listOfElems.length;
            this.prodTransform_altTransform = new TypedHashMap(prodTransformElems.length, (Cast)StringCast.instance, (Cast)NodeCast.instance);
            LinkedList<PTerm> list = ((AAltTransform)alt.getAltTransform()).getTerms();
            for (int i = 0; i < list.size(); ++i) {
                PTerm tmpTerm = list.get(i);
                tmpTerm.apply(new DepthFirstAdapter(){

                    @Override
                    public void caseASimpleListTerm(ASimpleListTerm node) {
                        node.setId(new TId(newElemName + "#" + node.getId().getText(), node.getId().getLine(), node.getId().getPos()));
                    }

                    @Override
                    public void caseASimpleTerm(ASimpleTerm node) {
                        node.setId(new TId(newElemName + "#" + node.getId().getText(), node.getId().getLine(), node.getId().getPos()));
                    }
                });
                this.prodTransform_altTransform.put(prodTransformElems[i], tmpTerm);
            }
        }

        void setName(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        int getNbElems() {
            return this.nbElems;
        }

        Map getProdTransform_AlTransformMap() {
            return this.prodTransform_altTransform;
        }

        void addElem(int position, AElem elem) {
            this.elements[position] = elem;
        }

        AElem[] getElems() {
            return this.elements;
        }
    }
}

