/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.util.Hashtable;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitVersionHelper;

public class PlainJUnitResultFormatter
implements JUnitResultFormatter {
    private NumberFormat nf = NumberFormat.getInstance();
    private Hashtable testStarts = new Hashtable();
    private OutputStream out;
    private StringWriter inner;
    private PrintWriter wri;
    private Hashtable failed = new Hashtable();
    private String systemOutput = null;
    private String systemError = null;

    public PlainJUnitResultFormatter() {
        this.inner = new StringWriter();
        this.wri = new PrintWriter(this.inner);
    }

    public void setOutput(OutputStream out) {
        this.out = out;
    }

    public void setSystemOutput(String out) {
        this.systemOutput = out;
    }

    public void setSystemError(String err) {
        this.systemError = err;
    }

    public void startTestSuite(JUnitTest suite) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endTestSuite(JUnitTest suite) throws BuildException {
        String newLine = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer("Testsuite: ");
        sb.append(suite.getName());
        sb.append(newLine);
        sb.append("Tests run: ");
        sb.append(suite.runCount());
        sb.append(", Failures: ");
        sb.append(suite.failureCount());
        sb.append(", Errors: ");
        sb.append(suite.errorCount());
        sb.append(", Time elapsed: ");
        sb.append(this.nf.format((double)suite.getRunTime() / 1000.0));
        sb.append(" sec");
        sb.append(newLine);
        if (this.systemOutput != null && this.systemOutput.length() > 0) {
            sb.append("------------- Standard Output ---------------").append(newLine).append(this.systemOutput).append("------------- ---------------- ---------------").append(newLine);
        }
        if (this.systemError != null && this.systemError.length() > 0) {
            sb.append("------------- Standard Error -----------------").append(newLine).append(this.systemError).append("------------- ---------------- ---------------").append(newLine);
        }
        sb.append(newLine);
        if (this.out == null) return;
        try {
            try {
                this.out.write(sb.toString().getBytes());
                this.wri.close();
                this.out.write(this.inner.toString().getBytes());
                this.out.flush();
            }
            catch (IOException ioex) {
                throw new BuildException("Unable to write output", (Throwable)ioex);
            }
            Object var6_4 = null;
            if (this.out == System.out) return;
            if (this.out == System.err) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (this.out == System.out) throw throwable;
            if (this.out == System.err) throw throwable;
            try {
                this.out.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        this.out.close();
        return;
    }

    public void startTest(Test t) {
        this.testStarts.put(t, new Long(System.currentTimeMillis()));
        this.failed.put(t, Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTest(Test test) {
        PrintWriter printWriter = this.wri;
        synchronized (printWriter) {
            this.wri.print("Testcase: " + JUnitVersionHelper.getTestCaseName(test));
            if (Boolean.TRUE.equals(this.failed.get(test))) {
                return;
            }
            Long l = (Long)this.testStarts.get(test);
            double seconds = 0.0;
            if (l != null) {
                seconds = (double)(System.currentTimeMillis() - l) / 1000.0;
            }
            this.wri.println(" took " + this.nf.format(seconds) + " sec");
        }
    }

    public void addFailure(Test test, Throwable t) {
        this.formatError("\tFAILED", test, t);
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.addFailure(test, (Throwable)t);
    }

    public void addError(Test test, Throwable t) {
        this.formatError("\tCaused an ERROR", test, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formatError(String type, Test test, Throwable t) {
        PrintWriter printWriter = this.wri;
        synchronized (printWriter) {
            if (test != null) {
                this.endTest(test);
                this.failed.put(test, Boolean.TRUE);
            }
            this.wri.println(type);
            this.wri.println(t.getMessage());
            String strace = JUnitTestRunner.getFilteredTrace(t);
            this.wri.print(strace);
            this.wri.println("");
        }
    }
}

