/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing;

import javax.swing.UIManager;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.igoweb.go.sgf.Node;
import org.igoweb.go.sgf.Prop;
import org.igoweb.go.sgf.Tree;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.IntHashSet;
import org.igoweb.util.swing.TextLog;

public class CommentLogViewer
extends TextLog {
    private final Tree tree;
    private IntHashSet nodesSeen = new IntHashSet();
    public static final int FORMAT_NORMAL = 0;
    public static final int FORMAT_BOLD = 1;
    public static final int FORMAT_DIM = 2;
    public static final int FORMAT_COUNT = 3;
    private int lastMoveNum = -2;
    private static final SimpleAttributeSet[] attrs = new SimpleAttributeSet[3];
    private final EventListener listener = new EventListener(){

        @Override
        public void handleEvent(Event event) {
            CommentLogViewer.this.treeEvent(event);
        }
    };

    public CommentLogViewer(Tree tree) {
        super(attrs, 1000);
        this.tree = tree;
        this.treeEvent(new Event(tree, 7, null));
    }

    @Override
    public void addNotify() {
        this.tree.addListener(this.listener);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        this.tree.removeListener(this.listener);
        super.removeNotify();
    }

    public SimpleAttributeSet getAttributes(int mode) {
        return attrs[mode];
    }

    @Override
    public void clear() {
        super.clear();
        this.nodesSeen.clear();
        this.treeEvent(new Event(this.tree, 7, null));
    }

    public void append(String text, int mode, boolean autoNewline, Node srcNode) {
        if (srcNode.getMoveNum() != this.lastMoveNum) {
            this.lastMoveNum = srcNode.getMoveNum();
            this.append(Defs.getString(-451068470, this.lastMoveNum), 1, true);
            autoNewline = true;
        }
        this.append(text, mode, autoNewline);
    }

    private void treeEvent(Event event) {
        switch (event.type) {
            case 6: {
                Node.NodeIterator iter = new Node.NodeIterator((Node)event.source);
                while (iter.hasNext()) {
                    this.nodesSeen.remove(new Integer(iter.nextNode().id));
                }
                break;
            }
            case 7: {
                Prop comments;
                if (!this.nodesSeen.add(this.tree.getActiveNode().id) || (comments = this.tree.getActiveNode().findProp(24)) == null) break;
                this.append(comments.getText(), 2, true, this.tree.getActiveNode());
                break;
            }
            case 0: {
                if (event.source != this.tree.getActiveNode()) break;
                Prop prop = (Prop)event.arg;
                if (prop.type != 24) break;
                this.append(prop.getText(), 0, true, this.tree.getActiveNode());
                break;
            }
            case 2: {
                if (event.source != this.tree.getActiveNode()) break;
                Prop prop = (Prop)event.arg;
                if (prop.type != 24) break;
                this.append(prop.getText(), 0, false, this.tree.getActiveNode());
            }
        }
    }

    static {
        for (int i = 0; i < 3; ++i) {
            CommentLogViewer.attrs[i] = CommentLogViewer.getBasicAttributeSet(true);
        }
        StyleConstants.setBold(attrs[1], true);
        StyleConstants.setForeground(attrs[2], UIManager.getColor("org.igoweb.stdBg").darker());
    }
}

