/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.icons;

import com.jidesoft.icons.IconSet;
import com.jidesoft.icons.IconsFactory;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class IconSetManager {
    private Map<String, IconSet> _availableStyles;
    private String _activeIconSetName = null;
    private IconSet _activeIconSet = null;

    public IconSet findIconSet(String iconSetName) {
        if (this._availableStyles == null) {
            return null;
        }
        return this._availableStyles.get(iconSetName);
    }

    public String getActiveIconSetName() {
        return this._activeIconSetName;
    }

    public IconSet getActiveIconSet() {
        return this._activeIconSet;
    }

    public void add(String name, int[] sizes, String packageName) {
        if (this._availableStyles == null) {
            this._availableStyles = new HashMap<String, IconSet>();
        }
        this._availableStyles.put(name, new IconSet(name, sizes, packageName));
        if (this._availableStyles.size() == 1) {
            this.setActiveIconSetName(name);
        }
    }

    public void remove(String name) {
        if (this._availableStyles != null) {
            this._availableStyles.remove(name);
        }
    }

    public void setActiveIconSetName(String activeIconSetName) {
        IconSet iconSet = this.findIconSet(activeIconSetName);
        if (iconSet == null) {
            throw new IllegalArgumentException("Icon set \"" + activeIconSetName + "\" not found");
        }
        this._activeIconSet = iconSet;
        this._activeIconSetName = activeIconSetName;
    }

    public ImageIcon getImageIcon(String iconName) {
        return this.getImageIcon(iconName, 16);
    }

    public ImageIcon getImageIcon(String iconName, int size) {
        String packageName = this._activeIconSet.getPackageName();
        int actualSize = this._activeIconSet.getNextAvailableSize(size);
        String fullIconName = packageName + "/png/" + actualSize + "x" + actualSize + "/" + iconName;
        ImageIcon icon = IconsFactory.getImageIcon(IconSetManager.class, fullIconName);
        if (actualSize == size) {
            return icon;
        }
        return IconsFactory.getScaledImage(null, icon, size, size);
    }

    public ImageIcon getOverlayImageIcon(String iconName, int size, String overlayIconName, int location) {
        return this.getOverlayImageIcon(iconName, size, overlayIconName, location, new Insets(0, 0, 0, 0));
    }

    public ImageIcon getOverlayImageIcon(String iconName, int size, String overlayIconName, int location, Insets insets) {
        ImageIcon icon = this.getImageIcon(iconName, size);
        if (icon == null) {
            return null;
        }
        ImageIcon overlay = this.getImageIcon(overlayIconName, size);
        if (overlay == null) {
            return icon;
        }
        overlay = IconsFactory.getIcon(null, overlay, size / 4, size / 4, size / 2, size / 2);
        return IconsFactory.getOverlayIcon(null, icon, overlay, location, insets);
    }

    public ImageIcon getOverlayImageIcon(String iconName, int size, String overlayIconName, int overlayIconSize, int location, Insets insets) {
        ImageIcon icon = this.getImageIcon(iconName, size);
        if (icon == null) {
            return null;
        }
        ImageIcon overlay = this.getImageIcon(overlayIconName, overlayIconSize);
        if (overlay == null) {
            return icon;
        }
        return IconsFactory.getOverlayIcon(null, icon, overlay, location, insets);
    }
}

