/*
 * Decompiled with CFR 0.152.
 */
package free.chess.variants.kriegspiel;

import free.chess.BoardPainter;
import free.chess.Chess;
import free.chess.ChessMove;
import free.chess.ChessPiece;
import free.chess.ChesslikeGenericVariant;
import free.chess.DefaultBoardPainter;
import free.chess.DefaultPiecePainter;
import free.chess.Move;
import free.chess.Piece;
import free.chess.PiecePainter;
import free.chess.Player;
import free.chess.Position;
import free.chess.Square;
import free.chess.WildVariant;
import free.chess.variants.kriegspiel.KriegspielMove;

public class Kriegspiel
implements WildVariant {
    private static final Kriegspiel INSTANCE = new Kriegspiel();

    public static Kriegspiel getInstance() {
        return INSTANCE;
    }

    private Kriegspiel() {
    }

    private void checkPosition(Position position) {
        if (!position.getVariant().equals(this)) {
            throw new IllegalArgumentException("Wrong position variant: " + position.getVariant());
        }
    }

    public void init(Position position) {
        this.checkPosition(position);
        position.setLexigraphic("rnbqkbnrpppppppp--------------------------------PPPPPPPPRNBQKBNR");
    }

    public Piece[] getPromotionTargets(Position position, Square square, Square square2) {
        this.checkPosition(position);
        return ChesslikeGenericVariant.getChessPromotionTargets(position, square, square2);
    }

    public Move createMove(Position position, Square square, Square square2, Piece piece, String string) {
        this.checkPosition(position);
        if (square2 == null) {
            return new KriegspielMove(position.getCurrentPlayer(), string);
        }
        if (square == null) {
            return new KriegspielMove(position, square2, string);
        }
        return Chess.getInstance().createChessMove(position, square, square2, (ChessPiece)piece, string);
    }

    public Move createMove(Position position, Move move) {
        this.checkPosition(position);
        if (move instanceof ChessMove) {
            ChessMove chessMove = (ChessMove)move;
            return this.createMove(position, chessMove.getStartingSquare(), chessMove.getEndingSquare(), chessMove.getPromotionTarget(), chessMove.getStringRepresentation());
        }
        return this.createMove(position, move.getStartingSquare(), move.getEndingSquare(), null, move.getStringRepresentation());
    }

    public Move createShortCastling(Position position) {
        this.checkPosition(position);
        Player player = position.getCurrentPlayer();
        if (player.isWhite()) {
            return ChesslikeGenericVariant.WHITE_SHORT_CASTLING;
        }
        return ChesslikeGenericVariant.BLACK_SHORT_CASTLING;
    }

    public Move createLongCastling(Position position) {
        this.checkPosition(position);
        Player player = position.getCurrentPlayer();
        if (player.isWhite()) {
            return ChesslikeGenericVariant.WHITE_LONG_CASTLING;
        }
        return ChesslikeGenericVariant.BLACK_LONG_CASTLING;
    }

    public void makeMove(Move move, Position position, Position.Modifier modifier) {
        this.checkPosition(position);
        if (!(move instanceof KriegspielMove) && !(move instanceof ChessMove)) {
            throw new IllegalArgumentException("The given move must be an instance of " + ChessMove.class.getName() + " or " + KriegspielMove.class.getName());
        }
        if (move instanceof KriegspielMove) {
            KriegspielMove kriegspielMove = (KriegspielMove)move;
            if (!kriegspielMove.isCompletelyHidden()) {
                Square square = kriegspielMove.getEndingSquare();
                modifier.setPieceAt(null, square);
            }
            modifier.setCurrentPlayer(position.getCurrentPlayer().getOpponent());
        } else {
            Chess.getInstance().makeChessMove((ChessMove)move, position, modifier);
        }
    }

    public Piece parsePiece(String string) {
        return ChesslikeGenericVariant.parseChessPiece(string);
    }

    public String pieceToString(Piece piece) {
        if (!(piece instanceof ChessPiece)) {
            throw new IllegalArgumentException("The given Piece must be an instance of ChessPiece.");
        }
        return ChesslikeGenericVariant.chessPieceToString((ChessPiece)piece);
    }

    public PiecePainter createDefaultPiecePainter() {
        return new DefaultPiecePainter();
    }

    public BoardPainter createDefaultBoardPainter() {
        return new DefaultBoardPainter();
    }

    public String getName() {
        return "Kriegspiel";
    }

    public String toString() {
        return this.getName();
    }
}

