# Copyright (C) 2008 LottaNZB Development Team
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

import logging
log = logging.getLogger(__name__)

from lottanzb.core import App
from lottanzb.modes.base import Mode as _Mode
from lottanzb.util import _

class Mode(_Mode):
    def handle_disconnect(self, backend, hint=""):
        try:
            self.reenter()
        except Exception, e:
            message = _("The connection to the HellaNZB daemon has been lost "
                "unexpectedly and the attempt to reconnect failed.")
            
            if hint:
                message += "\n\n" + hint
            
            App().mode_manager.show_selection_window(error_message=message)
