/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.tree.TreeCellRenderer;

public class DefaultTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected boolean selected;
    protected boolean hasFocus;
    private boolean drawsFocusBorderAroundIcon;
    protected transient Icon closedIcon;
    protected transient Icon leafIcon;
    protected transient Icon openIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;

    public Icon getDefaultOpenIcon() {
        return UIManager.getLookAndFeelDefaults().getIcon("Tree.openIcon");
    }

    public Icon getDefaultClosedIcon() {
        return UIManager.getLookAndFeelDefaults().getIcon("Tree.closedIcon");
    }

    public Icon getDefaultLeafIcon() {
        return UIManager.getLookAndFeelDefaults().getIcon("Tree.leafIcon");
    }

    public void setOpenIcon(Icon i) {
        this.openIcon = i;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public void setClosedIcon(Icon i) {
        this.closedIcon = i;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public void setLeafIcon(Icon i) {
        this.leafIcon = i;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setTextSelectionColor(Color c) {
        this.textSelectionColor = c;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setTextNonSelectionColor(Color c) {
        this.textNonSelectionColor = c;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color c) {
        this.backgroundSelectionColor = c;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color c) {
        this.backgroundNonSelectionColor = c;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBorderSelectionColor(Color c) {
        this.borderSelectionColor = c;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font f) {
        if (f != null && f instanceof UIResource) {
            f = null;
        }
        super.setFont(f);
    }

    public void setBackground(Color c) {
        if (c != null && c instanceof UIResource) {
            c = null;
        }
        super.setBackground(c);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object val, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (leaf) {
            this.setIcon(this.getLeafIcon());
        } else if (expanded) {
            this.setIcon(this.getOpenIcon());
        } else {
            this.setIcon(this.getClosedIcon());
        }
        this.setText(val.toString());
        this.selected = selected;
        this.hasFocus = hasFocus;
        this.setHorizontalAlignment(2);
        this.setOpaque(false);
        this.setVerticalAlignment(1);
        this.setEnabled(true);
        super.setFont(UIManager.getLookAndFeelDefaults().getFont("Tree.font"));
        if (selected) {
            super.setBackground(this.getBackgroundSelectionColor());
            this.setForeground(this.getTextSelectionColor());
            if (tree.getLeadSelectionPath() == null || tree.getLeadSelectionPath().getLastPathComponent().equals(val)) {
                this.setBorderSelectionColor(UIManager.getLookAndFeelDefaults().getColor("Tree.selectionBorderColor"));
            } else {
                this.setBorderSelectionColor(null);
            }
        } else {
            super.setBackground(this.getBackgroundNonSelectionColor());
            this.setForeground(this.getTextNonSelectionColor());
            this.setBorderSelectionColor(null);
        }
        return this;
    }

    public Font getFont() {
        return super.getFont();
    }

    public void paint(Graphics g) {
        Rectangle vr = new Rectangle();
        Rectangle ir = new Rectangle();
        Rectangle tr = new Rectangle();
        Insets insets = new Insets(0, 0, 0, 0);
        Border border = UIManager.getLookAndFeelDefaults().getBorder("Tree.selectionBorder");
        if (border != null) {
            insets = border.getBorderInsets(this);
        }
        FontMetrics fm = this.getToolkit().getFontMetrics(this.getFont());
        SwingUtilities.layoutCompoundLabel(this, fm, this.getText(), this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), vr, ir, tr, this.getIconTextGap());
        g.setColor(super.getBackground());
        g.fillRect(tr.x, tr.y, tr.width, tr.height - insets.top - insets.bottom);
        Color b = this.getBorderSelectionColor();
        if (b != null) {
            g.setColor(b);
            g.drawRect(tr.x, tr.y, tr.width, tr.height - insets.top - insets.bottom);
        }
        super.paint(g);
    }

    public Dimension getPreferredSize() {
        Rectangle vr = new Rectangle();
        Rectangle ir = new Rectangle();
        Rectangle tr = new Rectangle();
        FontMetrics fm = this.getToolkit().getFontMetrics(this.getFont());
        SwingUtilities.layoutCompoundLabel(this, fm, this.getText(), this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), vr, ir, tr, this.getIconTextGap());
        Rectangle cr = ir.union(tr);
        return new Dimension(cr.width, cr.height);
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long value0, int value1, int value2, int value3, int value4) {
    }

    public void repaint(Rectangle value0) {
    }

    protected void firePropertyChange(String value0, Object value1, Object value2) {
    }

    public void firePropertyChange(String value0, byte value1, byte value2) {
    }

    public void firePropertyChange(String value0, char value1, char value2) {
    }

    public void firePropertyChange(String value0, short value1, short value2) {
    }

    public void firePropertyChange(String value0, int value1, int value2) {
    }

    public void firePropertyChange(String value0, long value1, long value2) {
    }

    public void firePropertyChange(String value0, float value1, float value2) {
    }

    public void firePropertyChange(String value0, double value1, double value2) {
    }

    public void firePropertyChange(String name, boolean v1, boolean v2) {
    }

    public DefaultTreeCellRenderer() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.setLeafIcon(this.getDefaultLeafIcon());
        this.setOpenIcon(this.getDefaultOpenIcon());
        this.setClosedIcon(this.getDefaultClosedIcon());
        this.setTextNonSelectionColor(defaults.getColor("Tree.textForeground"));
        this.setTextSelectionColor(defaults.getColor("Tree.selectionForeground"));
        this.setBackgroundNonSelectionColor(defaults.getColor("Tree.nonSelectionBackground"));
        this.setBackgroundSelectionColor(defaults.getColor("Tree.selectionBackground"));
        this.setBorderSelectionColor(defaults.getColor("Tree.selectionBorderColor"));
    }
}

