(defproto ROBUST-PROTO
  '(weight-list
    c)
  ()
  morals-proto
  "Robust Regression Model")


(defmeth ROBUST-PROTO :weight-list (&optional (obj-id nil set))
  (when set (setf (slot-value 'weight-list) obj-id))
  (slot-value 'weight-list))

(defmeth ROBUST-PROTO :c (&optional (value nil set))
  (when set (setf (slot-value 'c) value))
  (slot-value 'c))


(defun robust-regression-model (x y &key 
                                   (intercept T)
                                   (print T)
                                   (plot T)
                                   weights
                                   (included (repeat t (length y)))
                                   predictor-names
                                   response-name
                                   case-labels                                  
                                   (iterations 0)
                                   vista-object
                                   (c 4.685)
                                   )
    (let* ((m (send ROBUST-PROTO :new x y)))
    (send m :x x)
    (send m :y y)
    (send m :intercept intercept)
    (send m :weights weights)
    (send m :included included)
    (send m :predictor-names predictor-names) 
    (send m :response-name response-name)
    (send m :case-labels case-labels)
    (send m :iterations iterations)
    (send m :vista-object vista-object)
    (send m :c c)
    (send m :compute)
    (send m :count 0)
    (setf *Robust-Model* m)
    m))

; :ISNEW method

(defmeth ROBUST-PROTO :isnew (x y)
  (call-method regression-model-proto :isnew)
  self)

