/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.tube;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Tube Socket", author="Branislav Stojkovic", category="Tubes", instanceNamePrefix="V", description="Various types of tube/valve sockets", stretchable=false, zOrder=4.0)
public class TubeSocket
extends AbstractTransparentComponent<String> {
    private static final long serialVersionUID = 1L;
    private static Color BODY_COLOR = Color.decode("#FFFFE0");
    private static Color BORDER_COLOR = Color.decode("#8E8E38");
    public static Color PIN_COLOR = Color.decode("#00B2EE");
    public static Color PIN_BORDER_COLOR = PIN_COLOR.darker();
    public static Size PIN_SIZE = new Size(Double.valueOf(1.0), SizeUnit.mm);
    public static Size HOLE_SIZE = new Size(Double.valueOf(5.0), SizeUnit.mm);
    public static Size TICK_SIZE = new Size(Double.valueOf(2.0), SizeUnit.mm);
    private Base base = Base.B9A;
    private String type = "";
    private Orientation orientation = Orientation.DEFAULT;
    private Point[] controlPoints = new Point[]{new Point(0, 0)};
    private transient Shape body;

    public TubeSocket() {
        this.updateControlPoints();
    }

    @EditableProperty
    public Base getBase() {
        return this.base;
    }

    public void setBase(Base base) {
        this.base = base;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
        this.body = null;
    }

    private void updateControlPoints() {
        double initialAngle;
        boolean hasEmptySpace;
        int pinCircleDiameter;
        int pinCount;
        Point firstPoint = this.controlPoints[0];
        switch (this.base) {
            case B7G: {
                pinCount = 7;
                pinCircleDiameter = this.getClosestOdd(new Size(Double.valueOf(12.0), SizeUnit.mm).convertToPixels());
                hasEmptySpace = true;
                break;
            }
            case OCTAL: {
                pinCount = 8;
                pinCircleDiameter = this.getClosestOdd(new Size(Double.valueOf(17.5), SizeUnit.mm).convertToPixels());
                hasEmptySpace = false;
                break;
            }
            case B9A: {
                pinCount = 9;
                pinCircleDiameter = this.getClosestOdd(new Size(Double.valueOf(21.0), SizeUnit.mm).convertToPixels());
                hasEmptySpace = true;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected base: " + (Object)((Object)this.base));
            }
        }
        double angleIncrement = Math.PI * 2 / (double)(hasEmptySpace ? pinCount + 1 : pinCount);
        double initialAngleOffset = hasEmptySpace ? angleIncrement : angleIncrement / 2.0;
        switch (this.orientation) {
            case DEFAULT: {
                initialAngle = 1.5707963267948966 + initialAngleOffset;
                break;
            }
            case _90: {
                initialAngle = Math.PI + initialAngleOffset;
                break;
            }
            case _180: {
                initialAngle = 4.71238898038469 + initialAngleOffset;
                break;
            }
            case _270: {
                initialAngle = initialAngleOffset;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected orientation: " + this.orientation);
            }
        }
        this.controlPoints = new Point[pinCount + 1];
        double angle = initialAngle;
        this.controlPoints[0] = firstPoint;
        for (int i = 0; i < pinCount; ++i) {
            this.controlPoints[i + 1] = new Point((int)(firstPoint.getX() + Math.cos(angle) * (double)pinCircleDiameter / 2.0), (int)(firstPoint.getY() + Math.sin(angle) * (double)pinCircleDiameter / 2.0));
            angle += angleIncrement;
        }
    }

    public Shape getBody() {
        if (this.body == null) {
            int bodyDiameter;
            switch (this.base) {
                case B7G: {
                    bodyDiameter = this.getClosestOdd(new Size(Double.valueOf(17.0), SizeUnit.mm).convertToPixels());
                    break;
                }
                case B9A: {
                    bodyDiameter = this.getClosestOdd(new Size(Double.valueOf(19.0), SizeUnit.mm).convertToPixels());
                    break;
                }
                case OCTAL: {
                    bodyDiameter = this.getClosestOdd(new Size(Double.valueOf(24.5), SizeUnit.mm).convertToPixels());
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected base: " + (Object)((Object)this.base));
                }
            }
            this.body = new Ellipse2D.Double(this.controlPoints[0].x - bodyDiameter / 2, this.controlPoints[0].y - bodyDiameter / 2, bodyDiameter, bodyDiameter);
            Area bodyArea = new Area(this.body);
            int holeSize = this.getClosestOdd(HOLE_SIZE.convertToPixels());
            bodyArea.subtract(new Area(new Ellipse2D.Double(this.controlPoints[0].x - holeSize / 2, this.controlPoints[0].y - holeSize / 2, holeSize, holeSize)));
            if (this.base == Base.OCTAL) {
                int tickSize = this.getClosestOdd(TICK_SIZE.convertToPixels());
                double angle = 0.0;
                switch (this.orientation) {
                    case DEFAULT: {
                        angle = 1.5707963267948966;
                        break;
                    }
                    case _90: {
                        angle = Math.PI;
                        break;
                    }
                    case _180: {
                        angle = 4.71238898038469;
                        break;
                    }
                    case _270: {
                        angle = 0.0;
                    }
                }
                int centerX = (int)((double)this.controlPoints[0].x + Math.cos(angle) * (double)holeSize / 2.0);
                int centerY = (int)((double)this.controlPoints[0].y + Math.sin(angle) * (double)holeSize / 2.0);
                bodyArea.subtract(new Area(new Ellipse2D.Double(centerX - tickSize / 2, centerY - tickSize / 2, tickSize, tickSize)));
            }
            this.body = bodyArea;
        }
        return this.body;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalBorderColor;
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1));
        Shape body = this.getBody();
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        if (componentState != ComponentState.DRAGGING) {
            g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : BODY_COLOR);
            g2d.fill(body);
        }
        g2d.setComposite(oldComposite);
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor();
        } else {
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : BORDER_COLOR;
        }
        g2d.setColor(finalBorderColor);
        g2d.draw(body);
        if (!outlineMode) {
            int pinSize = this.getClosestOdd(PIN_SIZE.convertToPixels());
            for (int i = 1; i < this.controlPoints.length; ++i) {
                g2d.setColor(PIN_COLOR);
                g2d.fillOval(this.controlPoints[i].x - pinSize / 2, this.controlPoints[i].y - pinSize / 2, pinSize, pinSize);
                g2d.setColor(PIN_BORDER_COLOR);
                g2d.drawOval(this.controlPoints[i].x - pinSize / 2, this.controlPoints[i].y - pinSize / 2, pinSize, pinSize);
            }
        }
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        Area area = new Area(new Ellipse2D.Double(1.0, 1.0, width - 2, width - 2));
        int center = width / 2;
        area.subtract(new Area(new Ellipse2D.Double(center - 2, center - 2, 5.0, 5.0)));
        g2d.setColor(BODY_COLOR);
        g2d.fill(area);
        g2d.setColor(BORDER_COLOR);
        g2d.draw(area);
        int radius = width / 2 - 6;
        for (int i = 0; i < 8; ++i) {
            int x = (int)((double)center + Math.cos((double)i * Math.PI / 4.0) * (double)radius);
            int y = (int)((double)center + Math.sin((double)i * Math.PI / 4.0) * (double)radius);
            g2d.setColor(PIN_COLOR);
            g2d.fillOval(x - 1, y - 1, 3, 3);
            g2d.setColor(PIN_BORDER_COLOR);
            g2d.drawOval(x - 1, y - 1, 3, 3);
        }
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    @EditableProperty(name="Type")
    public String getValue() {
        return this.type;
    }

    public void setValue(String value) {
        this.type = value;
    }

    public boolean isControlPointSticky(int index) {
        return index > 0;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    static enum Mount {
        CHASSIS("Chassis"),
        PCB("PCB");

        String name;

        private Mount(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    static enum Base {
        B9A("Noval B9A"),
        OCTAL("Octal"),
        B7G("Small-button B7G");

        String name;

        private Base(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

