/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class PrintWriter
extends Writer {
    private static final char[] line_separator = System.getProperty("line.separator", "\n").toCharArray();
    private boolean autoflush;
    private boolean error;
    private boolean closed;
    protected Writer out;

    protected void setError() {
        this.error = true;
    }

    public boolean checkError() {
        if (!this.closed) {
            this.flush();
        }
        return this.error;
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    public void close() {
        try {
            this.out.close();
            this.closed = true;
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    public void print(String string) {
        this.write(string == null ? "null" : string);
    }

    public void print(char c) {
        this.write(c);
    }

    public void print(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    public void print(boolean bl) {
        this.write(bl ? "true" : "false");
    }

    public void print(int n) {
        this.write(Integer.toString(n));
    }

    public void print(long l) {
        this.write(Long.toString(l));
    }

    public void print(float f) {
        this.write(Float.toString(f));
    }

    public void print(double d) {
        this.write(Double.toString(d));
    }

    public void print(Object object) {
        this.write(object == null ? "null" : object.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void println() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.write(line_separator, 0, line_separator.length);
                if (this.autoflush) {
                    this.out.flush();
                }
            }
            catch (IOException iOException) {
                this.error = true;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void println(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.print(bl);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void println(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.print(n);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void println(long l) {
        Object object = this.lock;
        synchronized (object) {
            this.print(l);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void println(float f) {
        Object object = this.lock;
        synchronized (object) {
            this.print(f);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void println(double d) {
        Object object = this.lock;
        synchronized (object) {
            this.print(d);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void println(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.print(object);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void println(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.print(string);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void println(char c) {
        Object object = this.lock;
        synchronized (object) {
            this.print(c);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void println(char[] cArray) {
        Object object = this.lock;
        synchronized (object) {
            this.print(cArray);
            this.println();
            return;
        }
    }

    public void write(int n) {
        try {
            this.out.write(n);
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    public void write(char[] cArray, int n, int n2) {
        try {
            this.out.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    public void write(String string, int n, int n2) {
        try {
            this.out.write(string, n, n2);
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    public void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    public void write(String string) {
        this.write(string, 0, string.length());
    }

    public PrintWriter(Writer writer) {
        super(writer.lock);
        this.out = writer;
    }

    public PrintWriter(Writer writer, boolean bl) {
        super(writer.lock);
        this.out = writer;
        this.autoflush = bl;
    }

    public PrintWriter(OutputStream outputStream) {
        this.out = new OutputStreamWriter(outputStream);
        this.lock = this.out;
    }

    public PrintWriter(OutputStream outputStream, boolean bl) {
        this(outputStream);
        this.autoflush = bl;
    }

    public PrintWriter(String string) throws FileNotFoundException {
        this(new FileOutputStream(string));
    }

    public PrintWriter(String string, String string2) throws FileNotFoundException, UnsupportedEncodingException {
        this(new OutputStreamWriter((OutputStream)new FileOutputStream(string), string2));
    }

    public PrintWriter(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public PrintWriter(File file, String string) throws FileNotFoundException, UnsupportedEncodingException {
        this(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string));
    }
}

