/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_PLUGIN_FILE_H__
#define __SG_PLUGIN_FILE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_plugin.h"

#define SG_PLUGIN_FILE(obj)        GTK_CHECK_CAST (obj, sg_plugin_file_get_type (), SGpluginFile)
#define GTK_TYPE_SG_PLUGIN_FILE   (sg_plugin_file_get_type ())
  
#define SG_PLUGIN_FILE_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, sg_plugin_file_get_type(), SGpluginFileClass)
#define GTK_IS_SG_PLUGIN_FILE(obj)     GTK_CHECK_TYPE (obj, sg_plugin_file_get_type ())


typedef struct _SGpluginFile   SGpluginFile;
typedef struct _SGpluginFileClass   SGpluginFileClass;

typedef enum
{
  SG_PLUGIN_FILE_IMPORT,
  SG_PLUGIN_FILE_OPEN,
  SG_PLUGIN_FILE_EXPORT,
  SG_PLUGIN_FILE_SAVE,
  SG_PLUGIN_FILE_SAVE_AS,
  SG_PLUGIN_FILE_PRINT,
} SGpluginFileMode;

struct _SGpluginFile
{
  SGplugin plugin;

  gchar *object_name;

  SGpluginFileMode mode; 
   
  gint nfilters;
  gchar filter[10][10];
  
  GtkPixmap *pixmap;

  gboolean (*action) (SGpluginFile *plugin, 
                      const gchar *file, FILE *opened,
                      GObject **o, gpointer data);
};

struct _SGpluginFileClass
{
  SGpluginClass parent_class;
};

GType         	sg_plugin_file_get_type     ();
SGpluginFile *  sg_plugin_file_new          ();
gboolean        sg_plugin_file_action       (SGpluginFile *plugin,
                                             const gchar *file,
                                             FILE *opened,
                                             GObject **object, 
					     gpointer data);
void		sg_plugin_file_set_object   (SGpluginFile *plugin,
					     const gchar *object);
SGpluginFile*   sg_plugin_file_get          (const gchar *name,
                                             const gchar *object_name,
                                             SGpluginFileMode mode);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_PLUGIN_FILE_H__ */

