/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.commons;

import java.util.Arrays;

public class CharacterEscaper {
    final char[] charsToEscape;

    public CharacterEscaper(String str) {
        this(str.toCharArray());
    }

    public CharacterEscaper(char[] charsToEscape) {
        this.charsToEscape = Arrays.copyOf(charsToEscape, charsToEscape.length);
        Arrays.sort(this.charsToEscape);
    }

    public String escape(String str) {
        StringBuilder sb = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (Arrays.binarySearch(this.charsToEscape, c) >= 0) {
                sb.append('\\').append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String toString() {
        return new String(this.charsToEscape);
    }
}

