/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class FloatFFT_2D {
    private int n1;
    private int n2;
    private int[] ip;
    private float[] w;
    private float[] t;
    private FloatFFT_1D fftn2;
    private FloatFFT_1D fftn1;
    private int oldNthread;
    private int nt;

    public FloatFFT_2D(int n, int n2) {
        if (!ConcurrencyUtils.isPowerOf2(n) || !ConcurrencyUtils.isPowerOf2(n2)) {
            throw new IllegalArgumentException("n1, n2 must be power of two numbers");
        }
        if (n <= 1 || n2 <= 1) {
            throw new IllegalArgumentException("n1, n2 must be greater than 1");
        }
        this.n1 = n;
        this.n2 = n2;
        this.ip = new int[2 + (int)Math.ceil(Math.sqrt(Math.max(n, n2)))];
        this.w = new float[(int)Math.ceil(Math.max(Math.max(n / 2, n2 / 2), Math.max(n / 2, n2 / 4) + n2 / 4))];
        this.fftn2 = new FloatFFT_1D(n2, this.ip, this.w);
        this.fftn1 = new FloatFFT_1D(n, this.ip, this.w);
        this.oldNthread = ConcurrencyUtils.getNumberOfProcessors();
        this.nt = 8 * this.oldNthread * n;
        if (2 * n2 == 4 * this.oldNthread) {
            this.nt >>= 1;
        } else if (2 * n2 < 4 * this.oldNthread) {
            this.nt >>= 2;
        }
        this.t = new float[this.nt];
    }

    public void complexForward(float[] fArray) {
        int n;
        int n2 = this.n2;
        this.n2 = 2 * this.n2;
        int n3 = this.n1 << 1;
        if (n3 < this.n2) {
            n3 = this.n2;
        }
        if (n3 > this.ip[0] << 2) {
            this.makewt(n3 >> 2);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n * this.n1;
            if (this.n2 == 4 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.xdft2d0_subth1(0, -1, fArray, true);
            this.cdft2d_subth(-1, fArray, true);
        } else {
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.complexForward(fArray, i * this.n2);
            }
            this.cdft2d_sub(-1, fArray, true);
        }
        this.n2 = n2;
    }

    public void complexForward(float[][] fArray) {
        int n;
        int n2 = this.n2;
        this.n2 = 2 * this.n2;
        int n3 = this.n1 << 1;
        if (n3 < this.n2) {
            n3 = this.n2;
        }
        if (n3 > this.ip[0] << 2) {
            this.makewt(n3 >> 2);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n * this.n1;
            if (this.n2 == 4 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.xdft2d0_subth1(0, -1, fArray, true);
            this.cdft2d_subth(-1, fArray, true);
        } else {
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.complexForward(fArray[i]);
            }
            this.cdft2d_sub(-1, fArray, true);
        }
        this.n2 = n2;
    }

    public void complexInverse(float[] fArray, boolean bl) {
        int n;
        int n2 = this.n2;
        this.n2 = 2 * this.n2;
        int n3 = this.n1 << 1;
        if (n3 < this.n2) {
            n3 = this.n2;
        }
        if (n3 > this.ip[0] << 2) {
            this.makewt(n3 >> 2);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n * this.n1;
            if (this.n2 == 4 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.xdft2d0_subth1(0, 1, fArray, bl);
            this.cdft2d_subth(1, fArray, bl);
        } else {
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.complexInverse(fArray, i * this.n2, bl);
            }
            this.cdft2d_sub(1, fArray, bl);
        }
        this.n2 = n2;
    }

    public void complexInverse(float[][] fArray, boolean bl) {
        int n;
        int n2 = this.n2;
        this.n2 = 2 * this.n2;
        int n3 = this.n1 << 1;
        if (n3 < this.n2) {
            n3 = this.n2;
        }
        if (n3 > this.ip[0] << 2) {
            this.makewt(n3 >> 2);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n * this.n1;
            if (this.n2 == 4 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.xdft2d0_subth1(0, 1, fArray, bl);
            this.cdft2d_subth(1, fArray, bl);
        } else {
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.complexInverse(fArray[i], bl);
            }
            this.cdft2d_sub(1, fArray, bl);
        }
        this.n2 = n2;
    }

    public void realForward(float[] fArray) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1 << 1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (this.n2 > (n2 = this.ip[1]) << 2) {
            n2 = this.n2 >> 2;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n * this.n1;
            if (this.n2 == 4 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.xdft2d0_subth1(1, 1, fArray, true);
            this.cdft2d_subth(-1, fArray, true);
            this.rdft2d_sub(1, fArray);
        } else {
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.realForward(fArray, i * this.n2);
            }
            this.cdft2d_sub(-1, fArray, true);
            this.rdft2d_sub(1, fArray);
        }
    }

    public void realForward(float[][] fArray) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1 << 1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (this.n2 > (n2 = this.ip[1]) << 2) {
            n2 = this.n2 >> 2;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n * this.n1;
            if (this.n2 == 4 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.xdft2d0_subth1(1, 1, fArray, true);
            this.cdft2d_subth(-1, fArray, true);
            this.rdft2d_sub(1, fArray);
        } else {
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.realForward(fArray[i]);
            }
            this.cdft2d_sub(-1, fArray, true);
            this.rdft2d_sub(1, fArray);
        }
    }

    public void realForwardFull(float[] fArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.n1 << 1;
        if (n7 < this.n2) {
            n7 = this.n2;
        }
        if (n7 > (n6 = this.ip[0]) << 2) {
            n6 = n7 >> 2;
            this.makewt(n6);
        }
        if (this.n2 > (n5 = this.ip[1]) << 2) {
            n5 = this.n2 >> 2;
            this.makect(n5, this.w, n6);
        }
        if ((n4 = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n4 * this.n1;
            if (this.n2 == 4 * n4) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n4) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthread = n4;
        }
        if (n4 > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.xdft2d0_subth1(1, 1, fArray, true);
            this.cdft2d_subth(-1, fArray, true);
            this.rdft2d_sub(1, fArray);
        } else {
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.realForward(fArray, i * this.n2);
            }
            this.cdft2d_sub(-1, fArray, true);
            this.rdft2d_sub(1, fArray);
        }
        int n8 = 2 * this.n2;
        int n9 = this.n1 / 2;
        for (n3 = this.n1 - 1; n3 >= 1; --n3) {
            int n10 = n3 * this.n2;
            n2 = 2 * n10;
            for (n = 0; n < this.n2; n += 2) {
                fArray[n2 + n] = fArray[n10 + n];
                fArray[n10 + n] = 0.0f;
                fArray[n2 + n + 1] = fArray[n10 + n + 1];
                fArray[n10 + n + 1] = 0.0f;
            }
        }
        if (n4 > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.fillSymmetric(fArray);
        } else {
            int n11;
            for (n3 = 1; n3 < n9; ++n3) {
                n2 = n3 * n8;
                n11 = (this.n1 - n3) * n8;
                fArray[n2 + this.n2] = fArray[n11 + 1];
                fArray[n2 + this.n2 + 1] = -fArray[n11];
            }
            for (n3 = 1; n3 < n9; ++n3) {
                for (n = this.n2 + 2; n < n8; n += 2) {
                    n2 = n3 * n8;
                    n11 = (this.n1 - n3) * n8;
                    fArray[n2 + n] = fArray[n11 + n8 - n];
                    fArray[n2 + n + 1] = -fArray[n11 + n8 - n + 1];
                }
            }
            for (n3 = 0; n3 <= this.n1 / 2; ++n3) {
                for (n = 0; n < n8; n += 2) {
                    n2 = n3 * n8 + n;
                    n11 = (this.n1 - n3) % this.n1 * n8 + (n8 - n) % n8;
                    fArray[n11] = fArray[n2];
                    fArray[n11 + 1] = -fArray[n2 + 1];
                }
            }
        }
        fArray[this.n2] = -fArray[1];
        fArray[1] = 0.0f;
        fArray[n9 * n8 + this.n2] = -fArray[n9 * n8 + 1];
        fArray[n9 * n8 + 1] = 0.0f;
        fArray[n9 * n8 + this.n2 + 1] = 0.0f;
    }

    public void realForwardFull(float[][] fArray) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1 << 1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (this.n2 > (n2 = this.ip[1]) << 2) {
            n2 = this.n2 >> 2;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n * this.n1;
            if (this.n2 == 4 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.xdft2d0_subth1(1, 1, fArray, true);
            this.cdft2d_subth(-1, fArray, true);
            this.rdft2d_sub(1, fArray);
        } else {
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.realForward(fArray[i]);
            }
            this.cdft2d_sub(-1, fArray, true);
            this.rdft2d_sub(1, fArray);
        }
        int n5 = 2 * this.n2;
        int n6 = this.n1 / 2;
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.fillSymmetric(fArray);
        } else {
            int n7;
            int n8;
            for (n8 = 1; n8 < n6; ++n8) {
                fArray[n8][this.n2] = fArray[this.n1 - n8][1];
                fArray[n8][this.n2 + 1] = -fArray[this.n1 - n8][0];
            }
            for (n8 = 1; n8 < n6; ++n8) {
                for (n7 = this.n2 + 2; n7 < n5; n7 += 2) {
                    fArray[n8][n7] = fArray[this.n1 - n8][n5 - n7];
                    fArray[n8][n7 + 1] = -fArray[this.n1 - n8][n5 - n7 + 1];
                }
            }
            for (n8 = 0; n8 <= this.n1 / 2; ++n8) {
                for (n7 = 0; n7 < n5; n7 += 2) {
                    fArray[(this.n1 - n8) % this.n1][(n5 - n7) % n5] = fArray[n8][n7];
                    fArray[(this.n1 - n8) % this.n1][(n5 - n7) % n5 + 1] = -fArray[n8][n7 + 1];
                }
            }
        }
        fArray[0][this.n2] = -fArray[0][1];
        fArray[0][1] = 0.0f;
        fArray[n6][this.n2] = -fArray[n6][1];
        fArray[n6][1] = 0.0f;
        fArray[n6][this.n2 + 1] = 0.0f;
    }

    public void realInverse(float[] fArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1 << 1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (this.n2 > (n2 = this.ip[1]) << 2) {
            n2 = this.n2 >> 2;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n * this.n1;
            if (this.n2 == 4 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.rdft2d_sub(-1, fArray);
            this.cdft2d_subth(1, fArray, bl);
            this.xdft2d0_subth1(1, -1, fArray, bl);
        } else {
            this.rdft2d_sub(-1, fArray);
            this.cdft2d_sub(1, fArray, bl);
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.realInverse(fArray, i * this.n2, bl);
            }
        }
    }

    public void realInverse(float[][] fArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1 << 1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (this.n2 > (n2 = this.ip[1]) << 2) {
            n2 = this.n2 >> 2;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n * this.n1;
            if (this.n2 == 4 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.rdft2d_sub(-1, fArray);
            this.cdft2d_subth(1, fArray, bl);
            this.xdft2d0_subth1(1, -1, fArray, bl);
        } else {
            this.rdft2d_sub(-1, fArray);
            this.cdft2d_sub(1, fArray, bl);
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.realInverse(fArray[i], bl);
            }
        }
    }

    public void realInverseFull(float[] fArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.n1 << 1;
        if (n7 < this.n2) {
            n7 = this.n2;
        }
        if (n7 > (n6 = this.ip[0]) << 2) {
            n6 = n7 >> 2;
            this.makewt(n6);
        }
        if (this.n2 > (n5 = this.ip[1]) << 2) {
            n5 = this.n2 >> 2;
            this.makect(n5, this.w, n6);
        }
        if ((n4 = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n4 * this.n1;
            if (this.n2 == 4 * n4) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n4) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthread = n4;
        }
        if (n4 > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.xdft2d0_subth2(1, -1, fArray, bl);
            this.cdft2d_subth(1, fArray, bl);
            this.rdft2d_sub(1, fArray);
        } else {
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.realInverse2(fArray, i * this.n2, bl);
            }
            this.cdft2d_sub(1, fArray, bl);
            this.rdft2d_sub(1, fArray);
        }
        int n8 = 2 * this.n2;
        int n9 = this.n1 / 2;
        for (n3 = this.n1 - 1; n3 >= 1; --n3) {
            int n10 = n3 * this.n2;
            n2 = 2 * n10;
            for (n = 0; n < this.n2; n += 2) {
                fArray[n2 + n] = fArray[n10 + n];
                fArray[n10 + n] = 0.0f;
                fArray[n2 + n + 1] = fArray[n10 + n + 1];
                fArray[n10 + n + 1] = 0.0f;
            }
        }
        if (n4 > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.fillSymmetric(fArray);
        } else {
            int n11;
            for (n3 = 1; n3 < n9; ++n3) {
                n2 = n3 * n8;
                n11 = (this.n1 - n3) * n8;
                fArray[n2 + this.n2] = fArray[n11 + 1];
                fArray[n2 + this.n2 + 1] = -fArray[n11];
            }
            for (n3 = 1; n3 < n9; ++n3) {
                for (n = this.n2 + 2; n < n8; n += 2) {
                    n2 = n3 * n8;
                    n11 = (this.n1 - n3) * n8;
                    fArray[n2 + n] = fArray[n11 + n8 - n];
                    fArray[n2 + n + 1] = -fArray[n11 + n8 - n + 1];
                }
            }
            for (n3 = 0; n3 <= this.n1 / 2; ++n3) {
                for (n = 0; n < n8; n += 2) {
                    n2 = n3 * n8 + n;
                    n11 = (this.n1 - n3) % this.n1 * n8 + (n8 - n) % n8;
                    fArray[n11] = fArray[n2];
                    fArray[n11 + 1] = -fArray[n2 + 1];
                }
            }
        }
        fArray[this.n2] = -fArray[1];
        fArray[1] = 0.0f;
        fArray[n9 * n8 + this.n2] = -fArray[n9 * n8 + 1];
        fArray[n9 * n8 + 1] = 0.0f;
        fArray[n9 * n8 + this.n2 + 1] = 0.0f;
    }

    public void realInverseFull(float[][] fArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1 << 1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (this.n2 > (n2 = this.ip[1]) << 2) {
            n2 = this.n2 >> 2;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 8 * n * this.n1;
            if (this.n2 == 4 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.xdft2d0_subth2(1, -1, fArray, bl);
            this.cdft2d_subth(1, fArray, bl);
            this.rdft2d_sub(1, fArray);
        } else {
            for (int i = 0; i < this.n1; ++i) {
                this.fftn2.realInverse2(fArray[i], 0, bl);
            }
            this.cdft2d_sub(1, fArray, bl);
            this.rdft2d_sub(1, fArray);
        }
        int n5 = 2 * this.n2;
        int n6 = this.n1 / 2;
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.fillSymmetric(fArray);
        } else {
            int n7;
            int n8;
            for (n8 = 1; n8 < n6; ++n8) {
                fArray[n8][this.n2] = fArray[this.n1 - n8][1];
                fArray[n8][this.n2 + 1] = -fArray[this.n1 - n8][0];
            }
            for (n8 = 1; n8 < n6; ++n8) {
                for (n7 = this.n2 + 2; n7 < n5; n7 += 2) {
                    fArray[n8][n7] = fArray[this.n1 - n8][n5 - n7];
                    fArray[n8][n7 + 1] = -fArray[this.n1 - n8][n5 - n7 + 1];
                }
            }
            for (n8 = 0; n8 <= this.n1 / 2; ++n8) {
                for (n7 = 0; n7 < n5; n7 += 2) {
                    fArray[(this.n1 - n8) % this.n1][(n5 - n7) % n5] = fArray[n8][n7];
                    fArray[(this.n1 - n8) % this.n1][(n5 - n7) % n5 + 1] = -fArray[n8][n7 + 1];
                }
            }
        }
        fArray[0][this.n2] = -fArray[0][1];
        fArray[0][1] = 0.0f;
        fArray[n6][this.n2] = -fArray[n6][1];
        fArray[n6][1] = 0.0f;
        fArray[n6][this.n2 + 1] = 0.0f;
    }

    private void makewt(int n) {
        this.ip[0] = n;
        this.ip[1] = 1;
        if (n > 2) {
            int n2;
            int n3 = n >> 1;
            float f = (float)(Math.atan(1.0) / (double)n3);
            float f2 = (float)Math.cos(f * (float)n3);
            this.w[0] = 1.0f;
            this.w[1] = f2;
            if (n3 == 4) {
                this.w[2] = (float)Math.cos(f * 2.0f);
                this.w[3] = (float)Math.sin(f * 2.0f);
            } else if (n3 > 4) {
                this.makeipt(n);
                this.w[2] = (float)(0.5 / Math.cos(f * 2.0f));
                this.w[3] = (float)(0.5 / Math.cos(f * 6.0f));
                for (n2 = 4; n2 < n3; n2 += 4) {
                    this.w[n2] = (float)Math.cos(f * (float)n2);
                    this.w[n2 + 1] = (float)Math.sin(f * (float)n2);
                    this.w[n2 + 2] = (float)Math.cos(3.0f * f * (float)n2);
                    this.w[n2 + 3] = (float)(-Math.sin(3.0f * f * (float)n2));
                }
            }
            int n4 = 0;
            while (n3 > 2) {
                float f3;
                float f4;
                int n5 = n4 + n3;
                this.w[n5] = 1.0f;
                this.w[n5 + 1] = f2;
                if ((n3 >>= 1) == 4) {
                    f4 = this.w[n4 + 4];
                    f3 = this.w[n4 + 5];
                    this.w[n5 + 2] = f4;
                    this.w[n5 + 3] = f3;
                } else if (n3 > 4) {
                    f4 = this.w[n4 + 4];
                    float f5 = this.w[n4 + 6];
                    this.w[n5 + 2] = (float)(0.5 / (double)f4);
                    this.w[n5 + 3] = (float)(0.5 / (double)f5);
                    for (n2 = 4; n2 < n3; n2 += 4) {
                        int n6 = n4 + 2 * n2;
                        int n7 = n5 + n2;
                        f4 = this.w[n6];
                        f3 = this.w[n6 + 1];
                        f5 = this.w[n6 + 2];
                        float f6 = this.w[n6 + 3];
                        this.w[n7] = f4;
                        this.w[n7 + 1] = f3;
                        this.w[n7 + 2] = f5;
                        this.w[n7 + 3] = f6;
                    }
                }
                n4 = n5;
            }
        }
    }

    private void makeipt(int n) {
        this.ip[2] = 0;
        this.ip[3] = 16;
        int n2 = 2;
        for (int i = n; i > 32; i >>= 2) {
            int n3 = n2 << 1;
            int n4 = n3 << 3;
            for (int j = n2; j < n3; ++j) {
                int n5;
                this.ip[n2 + j] = n5 = this.ip[j] << 2;
                this.ip[n3 + j] = n5 + n4;
            }
            n2 = n3;
        }
    }

    private void makect(int n, float[] fArray, int n2) {
        this.ip[1] = n;
        if (n > 1) {
            int n3 = n >> 1;
            float f = (float)Math.atan(1.0) / (float)n3;
            fArray[n2] = (float)Math.cos(f * (float)n3);
            fArray[n2 + n3] = 0.5f * fArray[n2];
            for (int i = 1; i < n3; ++i) {
                fArray[n2 + i] = (float)(0.5 * Math.cos(f * (float)i));
                fArray[n2 + n - i] = (float)(0.5 * Math.sin(f * (float)i));
            }
        }
    }

    private void rdft2d_sub(int n, float[] fArray) {
        int n2 = this.n1 >> 1;
        if (n < 0) {
            for (int i = 1; i < n2; ++i) {
                int n3 = this.n1 - i;
                int n4 = i * this.n2;
                int n5 = n3 * this.n2;
                float f = fArray[n4] - fArray[n5];
                int n6 = n4;
                fArray[n6] = fArray[n6] + fArray[n5];
                fArray[n5] = f;
                f = fArray[n5 + 1] - fArray[n4 + 1];
                int n7 = n4 + 1;
                fArray[n7] = fArray[n7] + fArray[n5 + 1];
                fArray[n5 + 1] = f;
            }
        } else {
            for (int i = 1; i < n2; ++i) {
                int n8 = this.n1 - i;
                int n9 = i * this.n2;
                int n10 = n8 * this.n2;
                fArray[n10] = 0.5f * (fArray[n9] - fArray[n10]);
                int n11 = n9;
                fArray[n11] = fArray[n11] - fArray[n10];
                fArray[n10 + 1] = 0.5f * (fArray[n9 + 1] + fArray[n10 + 1]);
                int n12 = n9 + 1;
                fArray[n12] = fArray[n12] - fArray[n10 + 1];
            }
        }
    }

    private void rdft2d_sub(int n, float[][] fArray) {
        int n2 = this.n1 >> 1;
        if (n < 0) {
            for (int i = 1; i < n2; ++i) {
                int n3 = this.n1 - i;
                float f = fArray[i][0] - fArray[n3][0];
                float[] fArray2 = fArray[i];
                fArray2[0] = fArray2[0] + fArray[n3][0];
                fArray[n3][0] = f;
                f = fArray[n3][1] - fArray[i][1];
                float[] fArray3 = fArray[i];
                fArray3[1] = fArray3[1] + fArray[n3][1];
                fArray[n3][1] = f;
            }
        } else {
            for (int i = 1; i < n2; ++i) {
                int n4 = this.n1 - i;
                fArray[n4][0] = 0.5f * (fArray[i][0] - fArray[n4][0]);
                float[] fArray4 = fArray[i];
                fArray4[0] = fArray4[0] - fArray[n4][0];
                fArray[n4][1] = 0.5f * (fArray[i][1] + fArray[n4][1]);
                float[] fArray5 = fArray[i];
                fArray5[1] = fArray5[1] - fArray[n4][1];
            }
        }
    }

    private void cdft2d_sub(int n, float[] fArray, boolean bl) {
        block21: {
            block19: {
                int n2;
                int n3;
                int n4;
                block22: {
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    block20: {
                        if (n != -1) break block19;
                        if (this.n2 <= 4) break block20;
                        for (int i = 0; i < this.n2; i += 8) {
                            int n9;
                            int n10;
                            int n11;
                            int n12;
                            int n13;
                            int n14;
                            for (n14 = 0; n14 < this.n1; ++n14) {
                                n13 = n14 * this.n2 + i;
                                n12 = 2 * n14;
                                n11 = 2 * this.n1 + 2 * n14;
                                n10 = n11 + 2 * this.n1;
                                n9 = n10 + 2 * this.n1;
                                this.t[n12] = fArray[n13];
                                this.t[n12 + 1] = fArray[n13 + 1];
                                this.t[n11] = fArray[n13 + 2];
                                this.t[n11 + 1] = fArray[n13 + 3];
                                this.t[n10] = fArray[n13 + 4];
                                this.t[n10 + 1] = fArray[n13 + 5];
                                this.t[n9] = fArray[n13 + 6];
                                this.t[n9 + 1] = fArray[n13 + 7];
                            }
                            this.fftn1.complexForward(this.t, 0);
                            this.fftn1.complexForward(this.t, 2 * this.n1);
                            this.fftn1.complexForward(this.t, 4 * this.n1);
                            this.fftn1.complexForward(this.t, 6 * this.n1);
                            for (n14 = 0; n14 < this.n1; ++n14) {
                                n13 = n14 * this.n2 + i;
                                n12 = 2 * n14;
                                n11 = 2 * this.n1 + 2 * n14;
                                n10 = n11 + 2 * this.n1;
                                n9 = n10 + 2 * this.n1;
                                fArray[n13] = this.t[n12];
                                fArray[n13 + 1] = this.t[n12 + 1];
                                fArray[n13 + 2] = this.t[n11];
                                fArray[n13 + 3] = this.t[n11 + 1];
                                fArray[n13 + 4] = this.t[n10];
                                fArray[n13 + 5] = this.t[n10 + 1];
                                fArray[n13 + 6] = this.t[n9];
                                fArray[n13 + 7] = this.t[n9 + 1];
                            }
                        }
                        break block21;
                    }
                    if (this.n2 != 4) break block22;
                    for (n8 = 0; n8 < this.n1; ++n8) {
                        n7 = n8 * this.n2;
                        n6 = 2 * n8;
                        n5 = 2 * this.n1 + 2 * n8;
                        this.t[n6] = fArray[n7];
                        this.t[n6 + 1] = fArray[n7 + 1];
                        this.t[n5] = fArray[n7 + 2];
                        this.t[n5 + 1] = fArray[n7 + 3];
                    }
                    this.fftn1.complexForward(this.t, 0);
                    this.fftn1.complexForward(this.t, 2 * this.n1);
                    for (n8 = 0; n8 < this.n1; ++n8) {
                        n7 = n8 * this.n2;
                        n6 = 2 * n8;
                        n5 = 2 * this.n1 + 2 * n8;
                        fArray[n7] = this.t[n6];
                        fArray[n7 + 1] = this.t[n6 + 1];
                        fArray[n7 + 2] = this.t[n5];
                        fArray[n7 + 3] = this.t[n5 + 1];
                    }
                    break block21;
                }
                if (this.n2 != 2) break block21;
                for (n4 = 0; n4 < this.n1; ++n4) {
                    n3 = n4 * this.n2;
                    n2 = 2 * n4;
                    this.t[n2] = fArray[n3];
                    this.t[n2 + 1] = fArray[n3 + 1];
                }
                this.fftn1.complexForward(this.t, 0);
                for (n4 = 0; n4 < this.n1; ++n4) {
                    n3 = n4 * this.n2;
                    n2 = 2 * n4;
                    fArray[n3] = this.t[n2];
                    fArray[n3 + 1] = this.t[n2 + 1];
                }
                break block21;
            }
            if (this.n2 > 4) {
                for (int i = 0; i < this.n2; i += 8) {
                    int n15;
                    int n16;
                    int n17;
                    int n18;
                    int n19;
                    int n20;
                    for (n20 = 0; n20 < this.n1; ++n20) {
                        n19 = n20 * this.n2 + i;
                        n18 = 2 * n20;
                        n17 = 2 * this.n1 + 2 * n20;
                        n16 = n17 + 2 * this.n1;
                        n15 = n16 + 2 * this.n1;
                        this.t[n18] = fArray[n19];
                        this.t[n18 + 1] = fArray[n19 + 1];
                        this.t[n17] = fArray[n19 + 2];
                        this.t[n17 + 1] = fArray[n19 + 3];
                        this.t[n16] = fArray[n19 + 4];
                        this.t[n16 + 1] = fArray[n19 + 5];
                        this.t[n15] = fArray[n19 + 6];
                        this.t[n15 + 1] = fArray[n19 + 7];
                    }
                    this.fftn1.complexInverse(this.t, 0, bl);
                    this.fftn1.complexInverse(this.t, 2 * this.n1, bl);
                    this.fftn1.complexInverse(this.t, 4 * this.n1, bl);
                    this.fftn1.complexInverse(this.t, 6 * this.n1, bl);
                    for (n20 = 0; n20 < this.n1; ++n20) {
                        n19 = n20 * this.n2 + i;
                        n18 = 2 * n20;
                        n17 = 2 * this.n1 + 2 * n20;
                        n16 = n17 + 2 * this.n1;
                        n15 = n16 + 2 * this.n1;
                        fArray[n19] = this.t[n18];
                        fArray[n19 + 1] = this.t[n18 + 1];
                        fArray[n19 + 2] = this.t[n17];
                        fArray[n19 + 3] = this.t[n17 + 1];
                        fArray[n19 + 4] = this.t[n16];
                        fArray[n19 + 5] = this.t[n16 + 1];
                        fArray[n19 + 6] = this.t[n15];
                        fArray[n19 + 7] = this.t[n15 + 1];
                    }
                }
            } else if (this.n2 == 4) {
                int n21;
                int n22;
                int n23;
                int n24;
                for (n24 = 0; n24 < this.n1; ++n24) {
                    n23 = n24 * this.n2;
                    n22 = 2 * n24;
                    n21 = 2 * this.n1 + 2 * n24;
                    this.t[n22] = fArray[n23];
                    this.t[n22 + 1] = fArray[n23 + 1];
                    this.t[n21] = fArray[n23 + 2];
                    this.t[n21 + 1] = fArray[n23 + 3];
                }
                this.fftn1.complexInverse(this.t, 0, bl);
                this.fftn1.complexInverse(this.t, 2 * this.n1, bl);
                for (n24 = 0; n24 < this.n1; ++n24) {
                    n23 = n24 * this.n2;
                    n22 = 2 * n24;
                    n21 = 2 * this.n1 + 2 * n24;
                    fArray[n23] = this.t[n22];
                    fArray[n23 + 1] = this.t[n22 + 1];
                    fArray[n23 + 2] = this.t[n21];
                    fArray[n23 + 3] = this.t[n21 + 1];
                }
            } else if (this.n2 == 2) {
                int n25;
                int n26;
                int n27;
                for (n27 = 0; n27 < this.n1; ++n27) {
                    n26 = n27 * this.n2;
                    n25 = 2 * n27;
                    this.t[n25] = fArray[n26];
                    this.t[n25 + 1] = fArray[n26 + 1];
                }
                this.fftn1.complexInverse(this.t, 0, bl);
                for (n27 = 0; n27 < this.n1; ++n27) {
                    n26 = n27 * this.n2;
                    n25 = 2 * n27;
                    fArray[n26] = this.t[n25];
                    fArray[n26 + 1] = this.t[n25 + 1];
                }
            }
        }
    }

    private void cdft2d_sub(int n, float[][] fArray, boolean bl) {
        block21: {
            block19: {
                int n2;
                int n3;
                block22: {
                    int n4;
                    int n5;
                    int n6;
                    block20: {
                        if (n != -1) break block19;
                        if (this.n2 <= 4) break block20;
                        for (int i = 0; i < this.n2; i += 8) {
                            int n7;
                            int n8;
                            int n9;
                            int n10;
                            int n11;
                            for (n11 = 0; n11 < this.n1; ++n11) {
                                n10 = 2 * n11;
                                n9 = 2 * this.n1 + 2 * n11;
                                n8 = n9 + 2 * this.n1;
                                n7 = n8 + 2 * this.n1;
                                this.t[n10] = fArray[n11][i];
                                this.t[n10 + 1] = fArray[n11][i + 1];
                                this.t[n9] = fArray[n11][i + 2];
                                this.t[n9 + 1] = fArray[n11][i + 3];
                                this.t[n8] = fArray[n11][i + 4];
                                this.t[n8 + 1] = fArray[n11][i + 5];
                                this.t[n7] = fArray[n11][i + 6];
                                this.t[n7 + 1] = fArray[n11][i + 7];
                            }
                            this.fftn1.complexForward(this.t, 0);
                            this.fftn1.complexForward(this.t, 2 * this.n1);
                            this.fftn1.complexForward(this.t, 4 * this.n1);
                            this.fftn1.complexForward(this.t, 6 * this.n1);
                            for (n11 = 0; n11 < this.n1; ++n11) {
                                n10 = 2 * n11;
                                n9 = 2 * this.n1 + 2 * n11;
                                n8 = n9 + 2 * this.n1;
                                n7 = n8 + 2 * this.n1;
                                fArray[n11][i] = this.t[n10];
                                fArray[n11][i + 1] = this.t[n10 + 1];
                                fArray[n11][i + 2] = this.t[n9];
                                fArray[n11][i + 3] = this.t[n9 + 1];
                                fArray[n11][i + 4] = this.t[n8];
                                fArray[n11][i + 5] = this.t[n8 + 1];
                                fArray[n11][i + 6] = this.t[n7];
                                fArray[n11][i + 7] = this.t[n7 + 1];
                            }
                        }
                        break block21;
                    }
                    if (this.n2 != 4) break block22;
                    for (n6 = 0; n6 < this.n1; ++n6) {
                        n5 = 2 * n6;
                        n4 = 2 * this.n1 + 2 * n6;
                        this.t[n5] = fArray[n6][0];
                        this.t[n5 + 1] = fArray[n6][1];
                        this.t[n4] = fArray[n6][2];
                        this.t[n4 + 1] = fArray[n6][3];
                    }
                    this.fftn1.complexForward(this.t, 0);
                    this.fftn1.complexForward(this.t, 2 * this.n1);
                    for (n6 = 0; n6 < this.n1; ++n6) {
                        n5 = 2 * n6;
                        n4 = 2 * this.n1 + 2 * n6;
                        fArray[n6][0] = this.t[n5];
                        fArray[n6][1] = this.t[n5 + 1];
                        fArray[n6][2] = this.t[n4];
                        fArray[n6][3] = this.t[n4 + 1];
                    }
                    break block21;
                }
                if (this.n2 != 2) break block21;
                for (n3 = 0; n3 < this.n1; ++n3) {
                    n2 = 2 * n3;
                    this.t[n2] = fArray[n3][0];
                    this.t[n2 + 1] = fArray[n3][1];
                }
                this.fftn1.complexForward(this.t, 0);
                for (n3 = 0; n3 < this.n1; ++n3) {
                    n2 = 2 * n3;
                    fArray[n3][0] = this.t[n2];
                    fArray[n3][1] = this.t[n2 + 1];
                }
                break block21;
            }
            if (this.n2 > 4) {
                for (int i = 0; i < this.n2; i += 8) {
                    int n12;
                    int n13;
                    int n14;
                    int n15;
                    int n16;
                    for (n16 = 0; n16 < this.n1; ++n16) {
                        n15 = 2 * n16;
                        n14 = 2 * this.n1 + 2 * n16;
                        n13 = n14 + 2 * this.n1;
                        n12 = n13 + 2 * this.n1;
                        this.t[n15] = fArray[n16][i];
                        this.t[n15 + 1] = fArray[n16][i + 1];
                        this.t[n14] = fArray[n16][i + 2];
                        this.t[n14 + 1] = fArray[n16][i + 3];
                        this.t[n13] = fArray[n16][i + 4];
                        this.t[n13 + 1] = fArray[n16][i + 5];
                        this.t[n12] = fArray[n16][i + 6];
                        this.t[n12 + 1] = fArray[n16][i + 7];
                    }
                    this.fftn1.complexInverse(this.t, 0, bl);
                    this.fftn1.complexInverse(this.t, 2 * this.n1, bl);
                    this.fftn1.complexInverse(this.t, 4 * this.n1, bl);
                    this.fftn1.complexInverse(this.t, 6 * this.n1, bl);
                    for (n16 = 0; n16 < this.n1; ++n16) {
                        n15 = 2 * n16;
                        n14 = 2 * this.n1 + 2 * n16;
                        n13 = n14 + 2 * this.n1;
                        n12 = n13 + 2 * this.n1;
                        fArray[n16][i] = this.t[n15];
                        fArray[n16][i + 1] = this.t[n15 + 1];
                        fArray[n16][i + 2] = this.t[n14];
                        fArray[n16][i + 3] = this.t[n14 + 1];
                        fArray[n16][i + 4] = this.t[n13];
                        fArray[n16][i + 5] = this.t[n13 + 1];
                        fArray[n16][i + 6] = this.t[n12];
                        fArray[n16][i + 7] = this.t[n12 + 1];
                    }
                }
            } else if (this.n2 == 4) {
                int n17;
                int n18;
                int n19;
                for (n19 = 0; n19 < this.n1; ++n19) {
                    n18 = 2 * n19;
                    n17 = 2 * this.n1 + 2 * n19;
                    this.t[n18] = fArray[n19][0];
                    this.t[n18 + 1] = fArray[n19][1];
                    this.t[n17] = fArray[n19][2];
                    this.t[n17 + 1] = fArray[n19][3];
                }
                this.fftn1.complexInverse(this.t, 0, bl);
                this.fftn1.complexInverse(this.t, 2 * this.n1, bl);
                for (n19 = 0; n19 < this.n1; ++n19) {
                    n18 = 2 * n19;
                    n17 = 2 * this.n1 + 2 * n19;
                    fArray[n19][0] = this.t[n18];
                    fArray[n19][1] = this.t[n18 + 1];
                    fArray[n19][2] = this.t[n17];
                    fArray[n19][3] = this.t[n17 + 1];
                }
            } else if (this.n2 == 2) {
                int n20;
                int n21;
                for (n21 = 0; n21 < this.n1; ++n21) {
                    n20 = 2 * n21;
                    this.t[n20] = fArray[n21][0];
                    this.t[n20 + 1] = fArray[n21][1];
                }
                this.fftn1.complexInverse(this.t, 0, bl);
                for (n21 = 0; n21 < this.n1; ++n21) {
                    n20 = 2 * n21;
                    fArray[n21][0] = this.t[n20];
                    fArray[n21][1] = this.t[n20 + 1];
                }
            }
        }
    }

    private void xdft2d0_subth1(final int n, final int n2, final float[] fArray, final boolean bl) {
        int n3;
        int n4 = ConcurrencyUtils.getNumberOfProcessors();
        final int n5 = n4 > this.n1 ? this.n1 : n4;
        Future[] futureArray = new Future[n5];
        for (int i = 0; i < n5; ++i) {
            n3 = i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    if (n == 0) {
                        if (n2 == -1) {
                            for (int i = n3; i < FloatFFT_2D.this.n1; i += n5) {
                                FloatFFT_2D.this.fftn2.complexForward(fArray, i * FloatFFT_2D.this.n2);
                            }
                        } else {
                            for (int i = n3; i < FloatFFT_2D.this.n1; i += n5) {
                                FloatFFT_2D.this.fftn2.complexInverse(fArray, i * FloatFFT_2D.this.n2, bl);
                            }
                        }
                    } else if (n2 == 1) {
                        for (int i = n3; i < FloatFFT_2D.this.n1; i += n5) {
                            FloatFFT_2D.this.fftn2.realForward(fArray, i * FloatFFT_2D.this.n2);
                        }
                    } else {
                        for (int i = n3; i < FloatFFT_2D.this.n1; i += n5) {
                            FloatFFT_2D.this.fftn2.realInverse(fArray, i * FloatFFT_2D.this.n2, bl);
                        }
                    }
                }
            });
        }
        try {
            for (n3 = 0; n3 < n5; ++n3) {
                futureArray[n3].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void xdft2d0_subth2(final int n, final int n2, final float[] fArray, final boolean bl) {
        int n3;
        int n4 = ConcurrencyUtils.getNumberOfProcessors();
        final int n5 = n4 > this.n1 ? this.n1 : n4;
        Future[] futureArray = new Future[n5];
        for (int i = 0; i < n5; ++i) {
            n3 = i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    if (n == 0) {
                        if (n2 == -1) {
                            for (int i = n3; i < FloatFFT_2D.this.n1; i += n5) {
                                FloatFFT_2D.this.fftn2.complexForward(fArray, i * FloatFFT_2D.this.n2);
                            }
                        } else {
                            for (int i = n3; i < FloatFFT_2D.this.n1; i += n5) {
                                FloatFFT_2D.this.fftn2.complexInverse(fArray, i * FloatFFT_2D.this.n2, bl);
                            }
                        }
                    } else if (n2 == 1) {
                        for (int i = n3; i < FloatFFT_2D.this.n1; i += n5) {
                            FloatFFT_2D.this.fftn2.realForward(fArray, i * FloatFFT_2D.this.n2);
                        }
                    } else {
                        for (int i = n3; i < FloatFFT_2D.this.n1; i += n5) {
                            FloatFFT_2D.this.fftn2.realInverse2(fArray, i * FloatFFT_2D.this.n2, bl);
                        }
                    }
                }
            });
        }
        try {
            for (n3 = 0; n3 < n5; ++n3) {
                futureArray[n3].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void xdft2d0_subth1(final int n, final int n2, final float[][] fArray, final boolean bl) {
        int n3;
        int n4 = ConcurrencyUtils.getNumberOfProcessors();
        final int n5 = n4 > this.n1 ? this.n1 : n4;
        Future[] futureArray = new Future[n5];
        for (int i = 0; i < n5; ++i) {
            n3 = i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    if (n == 0) {
                        if (n2 == -1) {
                            for (int i = n3; i < FloatFFT_2D.this.n1; i += n5) {
                                FloatFFT_2D.this.fftn2.complexForward(fArray[i]);
                            }
                        } else {
                            for (int i = n3; i < FloatFFT_2D.this.n1; i += n5) {
                                FloatFFT_2D.this.fftn2.complexInverse(fArray[i], bl);
                            }
                        }
                    } else if (n2 == 1) {
                        for (int i = n3; i < FloatFFT_2D.this.n1; i += n5) {
                            FloatFFT_2D.this.fftn2.realForward(fArray[i]);
                        }
                    } else {
                        for (int i = n3; i < FloatFFT_2D.this.n1; i += n5) {
                            FloatFFT_2D.this.fftn2.realInverse(fArray[i], bl);
                        }
                    }
                }
            });
        }
        try {
            for (n3 = 0; n3 < n5; ++n3) {
                futureArray[n3].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void xdft2d0_subth2(final int n, final int n2, final float[][] fArray, final boolean bl) {
        int n3;
        int n4 = ConcurrencyUtils.getNumberOfProcessors();
        final int n5 = n4 > this.n1 ? this.n1 : n4;
        Future[] futureArray = new Future[n5];
        for (int i = 0; i < n5; ++i) {
            n3 = i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    if (n == 0) {
                        if (n2 == -1) {
                            for (int i = n3; i < FloatFFT_2D.this.n1; i += n5) {
                                FloatFFT_2D.this.fftn2.complexForward(fArray[i]);
                            }
                        } else {
                            for (int i = n3; i < FloatFFT_2D.this.n1; i += n5) {
                                FloatFFT_2D.this.fftn2.complexInverse(fArray[i], bl);
                            }
                        }
                    } else if (n2 == 1) {
                        for (int i = n3; i < FloatFFT_2D.this.n1; i += n5) {
                            FloatFFT_2D.this.fftn2.realForward(fArray[i]);
                        }
                    } else {
                        for (int i = n3; i < FloatFFT_2D.this.n1; i += n5) {
                            FloatFFT_2D.this.fftn2.realInverse2(fArray[i], 0, bl);
                        }
                    }
                }
            });
        }
        try {
            for (n3 = 0; n3 < n5; ++n3) {
                futureArray[n3].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void cdft2d_subth(final int n, final float[] fArray, final boolean bl) {
        int n2;
        int n3;
        int n4 = n3 = ConcurrencyUtils.getNumberOfProcessors();
        int n5 = 8 * this.n1;
        if (this.n2 == 4 * n3) {
            n5 >>= 1;
        } else if (this.n2 < 4 * n3) {
            n4 = this.n2 >> 1;
            n5 >>= 2;
        }
        Future[] futureArray = new Future[n4];
        final int n6 = n4;
        for (int i = 0; i < n4; ++i) {
            n2 = i;
            final int n7 = n5 * i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    block21: {
                        block19: {
                            int n24;
                            int n25;
                            int n3;
                            block22: {
                                int n4;
                                int n5;
                                int n62;
                                int n72;
                                block20: {
                                    if (n != -1) break block19;
                                    if (FloatFFT_2D.this.n2 <= 4 * n6) break block20;
                                    for (int i = 8 * n2; i < FloatFFT_2D.this.n2; i += 8 * n6) {
                                        int n8;
                                        int n9;
                                        int n10;
                                        int n11;
                                        int n12;
                                        int n13;
                                        for (n13 = 0; n13 < FloatFFT_2D.this.n1; ++n13) {
                                            n12 = n13 * FloatFFT_2D.this.n2 + i;
                                            n11 = n7 + 2 * n13;
                                            n10 = n7 + 2 * FloatFFT_2D.this.n1 + 2 * n13;
                                            n9 = n10 + 2 * FloatFFT_2D.this.n1;
                                            n8 = n9 + 2 * FloatFFT_2D.this.n1;
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n11] = fArray[n12];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n11 + 1] = fArray[n12 + 1];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n10] = fArray[n12 + 2];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n10 + 1] = fArray[n12 + 3];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n9] = fArray[n12 + 4];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n9 + 1] = fArray[n12 + 5];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n8] = fArray[n12 + 6];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n8 + 1] = fArray[n12 + 7];
                                        }
                                        FloatFFT_2D.this.fftn1.complexForward(FloatFFT_2D.this.t, n7);
                                        FloatFFT_2D.this.fftn1.complexForward(FloatFFT_2D.this.t, n7 + 2 * FloatFFT_2D.this.n1);
                                        FloatFFT_2D.this.fftn1.complexForward(FloatFFT_2D.this.t, n7 + 4 * FloatFFT_2D.this.n1);
                                        FloatFFT_2D.this.fftn1.complexForward(FloatFFT_2D.this.t, n7 + 6 * FloatFFT_2D.this.n1);
                                        for (n13 = 0; n13 < FloatFFT_2D.this.n1; ++n13) {
                                            n12 = n13 * FloatFFT_2D.this.n2 + i;
                                            n11 = n7 + 2 * n13;
                                            n10 = n7 + 2 * FloatFFT_2D.this.n1 + 2 * n13;
                                            n9 = n10 + 2 * FloatFFT_2D.this.n1;
                                            n8 = n9 + 2 * FloatFFT_2D.this.n1;
                                            fArray[n12] = FloatFFT_2D.this.t[n11];
                                            fArray[n12 + 1] = FloatFFT_2D.this.t[n11 + 1];
                                            fArray[n12 + 2] = FloatFFT_2D.this.t[n10];
                                            fArray[n12 + 3] = FloatFFT_2D.this.t[n10 + 1];
                                            fArray[n12 + 4] = FloatFFT_2D.this.t[n9];
                                            fArray[n12 + 5] = FloatFFT_2D.this.t[n9 + 1];
                                            fArray[n12 + 6] = FloatFFT_2D.this.t[n8];
                                            fArray[n12 + 7] = FloatFFT_2D.this.t[n8 + 1];
                                        }
                                    }
                                    break block21;
                                }
                                if (FloatFFT_2D.this.n2 != 4 * n6) break block22;
                                for (n72 = 0; n72 < FloatFFT_2D.this.n1; ++n72) {
                                    n62 = n72 * FloatFFT_2D.this.n2 + 4 * n2;
                                    n5 = n7 + 2 * n72;
                                    n4 = n7 + 2 * FloatFFT_2D.this.n1 + 2 * n72;
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n5] = fArray[n62];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n5 + 1] = fArray[n62 + 1];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n4] = fArray[n62 + 2];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n4 + 1] = fArray[n62 + 3];
                                }
                                FloatFFT_2D.this.fftn1.complexForward(FloatFFT_2D.this.t, n7);
                                FloatFFT_2D.this.fftn1.complexForward(FloatFFT_2D.this.t, n7 + 2 * FloatFFT_2D.this.n1);
                                for (n72 = 0; n72 < FloatFFT_2D.this.n1; ++n72) {
                                    n62 = n72 * FloatFFT_2D.this.n2 + 4 * n2;
                                    n5 = n7 + 2 * n72;
                                    n4 = n7 + 2 * FloatFFT_2D.this.n1 + 2 * n72;
                                    fArray[n62] = FloatFFT_2D.this.t[n5];
                                    fArray[n62 + 1] = FloatFFT_2D.this.t[n5 + 1];
                                    fArray[n62 + 2] = FloatFFT_2D.this.t[n4];
                                    fArray[n62 + 3] = FloatFFT_2D.this.t[n4 + 1];
                                }
                                break block21;
                            }
                            if (FloatFFT_2D.this.n2 != 2 * n6) break block21;
                            for (n3 = 0; n3 < FloatFFT_2D.this.n1; ++n3) {
                                n25 = n3 * FloatFFT_2D.this.n2 + 2 * n2;
                                n24 = n7 + 2 * n3;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n24] = fArray[n25];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n24 + 1] = fArray[n25 + 1];
                            }
                            FloatFFT_2D.this.fftn1.complexForward(FloatFFT_2D.this.t, n7);
                            for (n3 = 0; n3 < FloatFFT_2D.this.n1; ++n3) {
                                n25 = n3 * FloatFFT_2D.this.n2 + 2 * n2;
                                n24 = n7 + 2 * n3;
                                fArray[n25] = FloatFFT_2D.this.t[n24];
                                fArray[n25 + 1] = FloatFFT_2D.this.t[n24 + 1];
                            }
                            break block21;
                        }
                        if (FloatFFT_2D.this.n2 > 4 * n6) {
                            for (int i = 8 * n2; i < FloatFFT_2D.this.n2; i += 8 * n6) {
                                int n26;
                                int n14;
                                int n15;
                                int n16;
                                int n17;
                                int n18;
                                for (n18 = 0; n18 < FloatFFT_2D.this.n1; ++n18) {
                                    n17 = n18 * FloatFFT_2D.this.n2 + i;
                                    n16 = n7 + 2 * n18;
                                    n15 = n7 + 2 * FloatFFT_2D.this.n1 + 2 * n18;
                                    n14 = n15 + 2 * FloatFFT_2D.this.n1;
                                    n26 = n14 + 2 * FloatFFT_2D.this.n1;
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n16] = fArray[n17];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n16 + 1] = fArray[n17 + 1];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n15] = fArray[n17 + 2];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n15 + 1] = fArray[n17 + 3];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n14] = fArray[n17 + 4];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n14 + 1] = fArray[n17 + 5];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n26] = fArray[n17 + 6];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n26 + 1] = fArray[n17 + 7];
                                }
                                FloatFFT_2D.this.fftn1.complexInverse(FloatFFT_2D.this.t, n7, bl);
                                FloatFFT_2D.this.fftn1.complexInverse(FloatFFT_2D.this.t, n7 + 2 * FloatFFT_2D.this.n1, bl);
                                FloatFFT_2D.this.fftn1.complexInverse(FloatFFT_2D.this.t, n7 + 4 * FloatFFT_2D.this.n1, bl);
                                FloatFFT_2D.this.fftn1.complexInverse(FloatFFT_2D.this.t, n7 + 6 * FloatFFT_2D.this.n1, bl);
                                for (n18 = 0; n18 < FloatFFT_2D.this.n1; ++n18) {
                                    n17 = n18 * FloatFFT_2D.this.n2 + i;
                                    n16 = n7 + 2 * n18;
                                    n15 = n7 + 2 * FloatFFT_2D.this.n1 + 2 * n18;
                                    n14 = n15 + 2 * FloatFFT_2D.this.n1;
                                    n26 = n14 + 2 * FloatFFT_2D.this.n1;
                                    fArray[n17] = FloatFFT_2D.this.t[n16];
                                    fArray[n17 + 1] = FloatFFT_2D.this.t[n16 + 1];
                                    fArray[n17 + 2] = FloatFFT_2D.this.t[n15];
                                    fArray[n17 + 3] = FloatFFT_2D.this.t[n15 + 1];
                                    fArray[n17 + 4] = FloatFFT_2D.this.t[n14];
                                    fArray[n17 + 5] = FloatFFT_2D.this.t[n14 + 1];
                                    fArray[n17 + 6] = FloatFFT_2D.this.t[n26];
                                    fArray[n17 + 7] = FloatFFT_2D.this.t[n26 + 1];
                                }
                            }
                        } else if (FloatFFT_2D.this.n2 == 4 * n6) {
                            int n27;
                            int n19;
                            int n20;
                            int n21;
                            for (n21 = 0; n21 < FloatFFT_2D.this.n1; ++n21) {
                                n20 = n21 * FloatFFT_2D.this.n2 + 4 * n2;
                                n19 = n7 + 2 * n21;
                                n27 = n7 + 2 * FloatFFT_2D.this.n1 + 2 * n21;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n19] = fArray[n20];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n19 + 1] = fArray[n20 + 1];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n27] = fArray[n20 + 2];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n27 + 1] = fArray[n20 + 3];
                            }
                            FloatFFT_2D.this.fftn1.complexInverse(FloatFFT_2D.this.t, n7, bl);
                            FloatFFT_2D.this.fftn1.complexInverse(FloatFFT_2D.this.t, n7 + 2 * FloatFFT_2D.this.n1, bl);
                            for (n21 = 0; n21 < FloatFFT_2D.this.n1; ++n21) {
                                n20 = n21 * FloatFFT_2D.this.n2 + 4 * n2;
                                n19 = n7 + 2 * n21;
                                n27 = n7 + 2 * FloatFFT_2D.this.n1 + 2 * n21;
                                fArray[n20] = FloatFFT_2D.this.t[n19];
                                fArray[n20 + 1] = FloatFFT_2D.this.t[n19 + 1];
                                fArray[n20 + 2] = FloatFFT_2D.this.t[n27];
                                fArray[n20 + 3] = FloatFFT_2D.this.t[n27 + 1];
                            }
                        } else if (FloatFFT_2D.this.n2 == 2 * n6) {
                            int n28;
                            int n22;
                            int n23;
                            for (n23 = 0; n23 < FloatFFT_2D.this.n1; ++n23) {
                                n22 = n23 * FloatFFT_2D.this.n2 + 2 * n2;
                                n28 = n7 + 2 * n23;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n28] = fArray[n22];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n28 + 1] = fArray[n22 + 1];
                            }
                            FloatFFT_2D.this.fftn1.complexInverse(FloatFFT_2D.this.t, n7, bl);
                            for (n23 = 0; n23 < FloatFFT_2D.this.n1; ++n23) {
                                n22 = n23 * FloatFFT_2D.this.n2 + 2 * n2;
                                n28 = n7 + 2 * n23;
                                fArray[n22] = FloatFFT_2D.this.t[n28];
                                fArray[n22 + 1] = FloatFFT_2D.this.t[n28 + 1];
                            }
                        }
                    }
                }
            });
        }
        try {
            for (n2 = 0; n2 < n4; ++n2) {
                futureArray[n2].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void cdft2d_subth(final int n, final float[][] fArray, final boolean bl) {
        int n2;
        int n3;
        int n4 = n3 = ConcurrencyUtils.getNumberOfProcessors();
        int n5 = 8 * this.n1;
        if (this.n2 == 4 * n3) {
            n5 >>= 1;
        } else if (this.n2 < 4 * n3) {
            n4 = this.n2 >> 1;
            n5 >>= 2;
        }
        Future[] futureArray = new Future[n4];
        final int n6 = n4;
        for (int i = 0; i < n4; ++i) {
            n2 = i;
            final int n7 = n5 * i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    block21: {
                        block19: {
                            int n18;
                            int n22;
                            block22: {
                                int n3;
                                int n4;
                                int n5;
                                block20: {
                                    if (n != -1) break block19;
                                    if (FloatFFT_2D.this.n2 <= 4 * n6) break block20;
                                    for (int i = 8 * n2; i < FloatFFT_2D.this.n2; i += 8 * n6) {
                                        int n62;
                                        int n72;
                                        int n8;
                                        int n9;
                                        int n10;
                                        for (n10 = 0; n10 < FloatFFT_2D.this.n1; ++n10) {
                                            n9 = n7 + 2 * n10;
                                            n8 = n7 + 2 * FloatFFT_2D.this.n1 + 2 * n10;
                                            n72 = n8 + 2 * FloatFFT_2D.this.n1;
                                            n62 = n72 + 2 * FloatFFT_2D.this.n1;
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n9] = fArray[n10][i];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n9 + 1] = fArray[n10][i + 1];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n8] = fArray[n10][i + 2];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n8 + 1] = fArray[n10][i + 3];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n72] = fArray[n10][i + 4];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n72 + 1] = fArray[n10][i + 5];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n62] = fArray[n10][i + 6];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n62 + 1] = fArray[n10][i + 7];
                                        }
                                        FloatFFT_2D.this.fftn1.complexForward(FloatFFT_2D.this.t, n7);
                                        FloatFFT_2D.this.fftn1.complexForward(FloatFFT_2D.this.t, n7 + 2 * FloatFFT_2D.this.n1);
                                        FloatFFT_2D.this.fftn1.complexForward(FloatFFT_2D.this.t, n7 + 4 * FloatFFT_2D.this.n1);
                                        FloatFFT_2D.this.fftn1.complexForward(FloatFFT_2D.this.t, n7 + 6 * FloatFFT_2D.this.n1);
                                        for (n10 = 0; n10 < FloatFFT_2D.this.n1; ++n10) {
                                            n9 = n7 + 2 * n10;
                                            n8 = n7 + 2 * FloatFFT_2D.this.n1 + 2 * n10;
                                            n72 = n8 + 2 * FloatFFT_2D.this.n1;
                                            n62 = n72 + 2 * FloatFFT_2D.this.n1;
                                            fArray[n10][i] = FloatFFT_2D.this.t[n9];
                                            fArray[n10][i + 1] = FloatFFT_2D.this.t[n9 + 1];
                                            fArray[n10][i + 2] = FloatFFT_2D.this.t[n8];
                                            fArray[n10][i + 3] = FloatFFT_2D.this.t[n8 + 1];
                                            fArray[n10][i + 4] = FloatFFT_2D.this.t[n72];
                                            fArray[n10][i + 5] = FloatFFT_2D.this.t[n72 + 1];
                                            fArray[n10][i + 6] = FloatFFT_2D.this.t[n62];
                                            fArray[n10][i + 7] = FloatFFT_2D.this.t[n62 + 1];
                                        }
                                    }
                                    break block21;
                                }
                                if (FloatFFT_2D.this.n2 != 4 * n6) break block22;
                                for (n5 = 0; n5 < FloatFFT_2D.this.n1; ++n5) {
                                    n4 = n7 + 2 * n5;
                                    n3 = n7 + 2 * FloatFFT_2D.this.n1 + 2 * n5;
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n4] = fArray[n5][4 * n2];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n4 + 1] = fArray[n5][4 * n2 + 1];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n3] = fArray[n5][4 * n2 + 2];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n3 + 1] = fArray[n5][4 * n2 + 3];
                                }
                                FloatFFT_2D.this.fftn1.complexForward(FloatFFT_2D.this.t, n7);
                                FloatFFT_2D.this.fftn1.complexForward(FloatFFT_2D.this.t, n7 + 2 * FloatFFT_2D.this.n1);
                                for (n5 = 0; n5 < FloatFFT_2D.this.n1; ++n5) {
                                    n4 = n7 + 2 * n5;
                                    n3 = n7 + 2 * FloatFFT_2D.this.n1 + 2 * n5;
                                    fArray[n5][4 * n2] = FloatFFT_2D.this.t[n4];
                                    fArray[n5][4 * n2 + 1] = FloatFFT_2D.this.t[n4 + 1];
                                    fArray[n5][4 * n2 + 2] = FloatFFT_2D.this.t[n3];
                                    fArray[n5][4 * n2 + 3] = FloatFFT_2D.this.t[n3 + 1];
                                }
                                break block21;
                            }
                            if (FloatFFT_2D.this.n2 != 2 * n6) break block21;
                            for (n22 = 0; n22 < FloatFFT_2D.this.n1; ++n22) {
                                n18 = n7 + 2 * n22;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n18] = fArray[n22][2 * n2];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n18 + 1] = fArray[n22][2 * n2 + 1];
                            }
                            FloatFFT_2D.this.fftn1.complexForward(FloatFFT_2D.this.t, n7);
                            for (n22 = 0; n22 < FloatFFT_2D.this.n1; ++n22) {
                                n18 = n7 + 2 * n22;
                                fArray[n22][2 * n2] = FloatFFT_2D.this.t[n18];
                                fArray[n22][2 * n2 + 1] = FloatFFT_2D.this.t[n18 + 1];
                            }
                            break block21;
                        }
                        if (FloatFFT_2D.this.n2 > 4 * n6) {
                            for (int i = 8 * n2; i < FloatFFT_2D.this.n2; i += 8 * n6) {
                                int n19;
                                int n11;
                                int n12;
                                int n13;
                                int n14;
                                for (n14 = 0; n14 < FloatFFT_2D.this.n1; ++n14) {
                                    n13 = n7 + 2 * n14;
                                    n12 = n7 + 2 * FloatFFT_2D.this.n1 + 2 * n14;
                                    n11 = n12 + 2 * FloatFFT_2D.this.n1;
                                    n19 = n11 + 2 * FloatFFT_2D.this.n1;
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n13] = fArray[n14][i];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n13 + 1] = fArray[n14][i + 1];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n12] = fArray[n14][i + 2];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n12 + 1] = fArray[n14][i + 3];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n11] = fArray[n14][i + 4];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n11 + 1] = fArray[n14][i + 5];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n19] = fArray[n14][i + 6];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n19 + 1] = fArray[n14][i + 7];
                                }
                                FloatFFT_2D.this.fftn1.complexInverse(FloatFFT_2D.this.t, n7, bl);
                                FloatFFT_2D.this.fftn1.complexInverse(FloatFFT_2D.this.t, n7 + 2 * FloatFFT_2D.this.n1, bl);
                                FloatFFT_2D.this.fftn1.complexInverse(FloatFFT_2D.this.t, n7 + 4 * FloatFFT_2D.this.n1, bl);
                                FloatFFT_2D.this.fftn1.complexInverse(FloatFFT_2D.this.t, n7 + 6 * FloatFFT_2D.this.n1, bl);
                                for (n14 = 0; n14 < FloatFFT_2D.this.n1; ++n14) {
                                    n13 = n7 + 2 * n14;
                                    n12 = n7 + 2 * FloatFFT_2D.this.n1 + 2 * n14;
                                    n11 = n12 + 2 * FloatFFT_2D.this.n1;
                                    n19 = n11 + 2 * FloatFFT_2D.this.n1;
                                    fArray[n14][i] = FloatFFT_2D.this.t[n13];
                                    fArray[n14][i + 1] = FloatFFT_2D.this.t[n13 + 1];
                                    fArray[n14][i + 2] = FloatFFT_2D.this.t[n12];
                                    fArray[n14][i + 3] = FloatFFT_2D.this.t[n12 + 1];
                                    fArray[n14][i + 4] = FloatFFT_2D.this.t[n11];
                                    fArray[n14][i + 5] = FloatFFT_2D.this.t[n11 + 1];
                                    fArray[n14][i + 6] = FloatFFT_2D.this.t[n19];
                                    fArray[n14][i + 7] = FloatFFT_2D.this.t[n19 + 1];
                                }
                            }
                        } else if (FloatFFT_2D.this.n2 == 4 * n6) {
                            int n20;
                            int n15;
                            int n16;
                            for (n16 = 0; n16 < FloatFFT_2D.this.n1; ++n16) {
                                n15 = n7 + 2 * n16;
                                n20 = n7 + 2 * FloatFFT_2D.this.n1 + 2 * n16;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n15] = fArray[n16][4 * n2];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n15 + 1] = fArray[n16][4 * n2 + 1];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n20] = fArray[n16][4 * n2 + 2];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n20 + 1] = fArray[n16][4 * n2 + 3];
                            }
                            FloatFFT_2D.this.fftn1.complexInverse(FloatFFT_2D.this.t, n7, bl);
                            FloatFFT_2D.this.fftn1.complexInverse(FloatFFT_2D.this.t, n7 + 2 * FloatFFT_2D.this.n1, bl);
                            for (n16 = 0; n16 < FloatFFT_2D.this.n1; ++n16) {
                                n15 = n7 + 2 * n16;
                                n20 = n7 + 2 * FloatFFT_2D.this.n1 + 2 * n16;
                                fArray[n16][4 * n2] = FloatFFT_2D.this.t[n15];
                                fArray[n16][4 * n2 + 1] = FloatFFT_2D.this.t[n15 + 1];
                                fArray[n16][4 * n2 + 2] = FloatFFT_2D.this.t[n20];
                                fArray[n16][4 * n2 + 3] = FloatFFT_2D.this.t[n20 + 1];
                            }
                        } else if (FloatFFT_2D.this.n2 == 2 * n6) {
                            int n21;
                            int n17;
                            for (n17 = 0; n17 < FloatFFT_2D.this.n1; ++n17) {
                                n21 = n7 + 2 * n17;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n21] = fArray[n17][2 * n2];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n21 + 1] = fArray[n17][2 * n2 + 1];
                            }
                            FloatFFT_2D.this.fftn1.complexInverse(FloatFFT_2D.this.t, n7, bl);
                            for (n17 = 0; n17 < FloatFFT_2D.this.n1; ++n17) {
                                n21 = n7 + 2 * n17;
                                fArray[n17][2 * n2] = FloatFFT_2D.this.t[n21];
                                fArray[n17][2 * n2 + 1] = FloatFFT_2D.this.t[n21 + 1];
                            }
                        }
                    }
                }
            });
        }
        try {
            for (n2 = 0; n2 < n4; ++n2) {
                futureArray[n2].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void fillSymmetric(final float[] fArray) {
        int n;
        int n2 = ConcurrencyUtils.getNumberOfProcessors();
        Future[] futureArray = new Future[n2];
        int n3 = this.n1 / 2;
        int n4 = n3 / n2;
        final int n5 = 2 * this.n2;
        for (n = 0; n < n2; ++n) {
            final int n6 = n == 0 ? n * n4 + 1 : n * n4;
            final int n7 = n * n4 + n4;
            final int n8 = n * n4;
            final int n9 = n == n2 - 1 ? n * n4 + n4 + 1 : n * n4 + n4;
            futureArray[n] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    int n;
                    int n2;
                    int n3;
                    int n4;
                    for (n4 = n6; n4 < n7; ++n4) {
                        n3 = n4 * n5;
                        n2 = (FloatFFT_2D.this.n1 - n4) * n5;
                        fArray[n3 + ((FloatFFT_2D)FloatFFT_2D.this).n2] = fArray[n2 + 1];
                        fArray[n3 + ((FloatFFT_2D)FloatFFT_2D.this).n2 + 1] = -fArray[n2];
                    }
                    for (n4 = n6; n4 < n7; ++n4) {
                        for (n = FloatFFT_2D.this.n2 + 2; n < n5; n += 2) {
                            n3 = n4 * n5;
                            n2 = (FloatFFT_2D.this.n1 - n4) * n5 + n5 - n;
                            fArray[n3 + n] = fArray[n2];
                            fArray[n3 + n + 1] = -fArray[n2 + 1];
                        }
                    }
                    for (n4 = n8; n4 < n9; ++n4) {
                        for (n = 0; n < n5; n += 2) {
                            n3 = (FloatFFT_2D.this.n1 - n4) % FloatFFT_2D.this.n1 * n5 + (n5 - n) % n5;
                            n2 = n4 * n5 + n;
                            fArray[n3] = fArray[n2];
                            fArray[n3 + 1] = -fArray[n2 + 1];
                        }
                    }
                }
            });
        }
        try {
            for (n = 0; n < n2; ++n) {
                futureArray[n].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void fillSymmetric(final float[][] fArray) {
        int n;
        int n2 = ConcurrencyUtils.getNumberOfProcessors();
        Future[] futureArray = new Future[n2];
        int n3 = this.n1 / 2;
        int n4 = n3 / n2;
        final int n5 = 2 * this.n2;
        for (n = 0; n < n2; ++n) {
            final int n6 = n == 0 ? n * n4 + 1 : n * n4;
            final int n7 = n * n4 + n4;
            final int n8 = n * n4;
            final int n9 = n == n2 - 1 ? n * n4 + n4 + 1 : n * n4 + n4;
            futureArray[n] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    int n;
                    int n2;
                    for (n2 = n6; n2 < n7; ++n2) {
                        fArray[n2][((FloatFFT_2D)FloatFFT_2D.this).n2] = fArray[FloatFFT_2D.this.n1 - n2][1];
                        fArray[n2][((FloatFFT_2D)FloatFFT_2D.this).n2 + 1] = -fArray[FloatFFT_2D.this.n1 - n2][0];
                    }
                    for (n2 = n6; n2 < n7; ++n2) {
                        for (n = FloatFFT_2D.this.n2 + 2; n < n5; n += 2) {
                            fArray[n2][n] = fArray[FloatFFT_2D.this.n1 - n2][n5 - n];
                            fArray[n2][n + 1] = -fArray[FloatFFT_2D.this.n1 - n2][n5 - n + 1];
                        }
                    }
                    for (n2 = n8; n2 < n9; ++n2) {
                        for (n = 0; n < n5; n += 2) {
                            fArray[(((FloatFFT_2D)FloatFFT_2D.this).n1 - n2) % ((FloatFFT_2D)FloatFFT_2D.this).n1][(n5 - n) % n5] = fArray[n2][n];
                            fArray[(((FloatFFT_2D)FloatFFT_2D.this).n1 - n2) % ((FloatFFT_2D)FloatFFT_2D.this).n1][(n5 - n) % n5 + 1] = -fArray[n2][n + 1];
                        }
                    }
                }
            });
        }
        try {
            for (n = 0; n < n2; ++n) {
                futureArray[n].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

