/*
 * Decompiled with CFR 0.152.
 */
package net.pflaeging.PortableSigner;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class SignCommandLine {
    public String input = "";
    public String output = "";
    public String signature = "";
    public String password = "";
    public String sigblock = "";
    public String sigimage = "";
    public String comment = "";
    public String reason = "";
    public String location = "";
    public String pwdFile = "";
    public String ownerPwdFile = "";
    public String ownerPwdString = "";
    private String embedParams = "";
    public byte[] ownerPwd = null;
    public Boolean nogui = false;
    public Boolean finalize = true;
    public Boolean noSigPage = false;
    public Boolean lastPage = false;
    private Boolean help = false;
    public float vPos = 0.0f;
    public float lMargin = 0.0f;
    public float rMargin = 0.0f;
    String langcodes = "";

    public SignCommandLine(String[] args) {
        Enumeration<String> langCodes = ResourceBundle.getBundle("net/pflaeging/PortableSigner/SignatureblockLanguages").getKeys();
        while (langCodes.hasMoreElements()) {
            this.langcodes = this.langcodes + langCodes.nextElement() + "|";
        }
        this.langcodes = this.langcodes.substring(0, this.langcodes.length() - 1);
        Options options = new Options();
        options.addOption("t", true, ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-InputFile"));
        options.addOption("o", true, ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-OutputFile"));
        options.addOption("s", true, ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-SignatureFile"));
        options.addOption("p", true, ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-Password"));
        options.addOption("n", false, ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-WithoutGUI"));
        options.addOption("f", false, ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-Finalize"));
        options.addOption("h", false, ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-Help"));
        options.addOption("b", true, ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-SigBlock") + this.langcodes);
        options.addOption("i", true, ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-SigImage"));
        options.addOption("c", true, ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-SigComment"));
        options.addOption("r", true, ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-SigReason"));
        options.addOption("l", true, ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-SigLocation"));
        options.addOption("e", true, ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-EmbedSignature"));
        options.addOption("pwdfile", true, ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-PasswdFile"));
        options.addOption("ownerpwd", true, ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-OwnerPasswd"));
        options.addOption("ownerpwdfile", true, ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-OwnerPasswdFile"));
        options.addOption("z", false, ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-LastPage"));
        PosixParser parser = new PosixParser();
        HelpFormatter usage = new HelpFormatter();
        try {
            CommandLine cmd = parser.parse(options, args);
            this.input = cmd.getOptionValue("t", "");
            this.output = cmd.getOptionValue("o", "");
            this.signature = cmd.getOptionValue("s", "");
            this.password = cmd.getOptionValue("p", "");
            this.nogui = cmd.hasOption("n");
            this.help = cmd.hasOption("h");
            this.finalize = !cmd.hasOption("f");
            this.sigblock = cmd.getOptionValue("b", "");
            this.sigimage = cmd.getOptionValue("i", "");
            this.comment = cmd.getOptionValue("c", "");
            this.reason = cmd.getOptionValue("r", "");
            this.location = cmd.getOptionValue("l", "");
            this.embedParams = cmd.getOptionValue("e", "");
            this.pwdFile = cmd.getOptionValue("pwdfile", "");
            this.ownerPwdString = cmd.getOptionValue("ownerpwd", "");
            this.ownerPwdFile = cmd.getOptionValue("ownerpwdfile", "");
            this.lastPage = !cmd.hasOption("z");
            if (cmd.getArgs().length != 0) {
                throw new ParseException(ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-UnknownArguments"));
            }
        }
        catch (ParseException e) {
            System.err.println(ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-WrongArguments"));
            usage.printHelp("PortableSigner", options);
            System.exit(3);
        }
        if (this.nogui.booleanValue()) {
            FileInputStream pwdfis;
            if (this.input.equals("") || this.output.equals("") || this.signature.equals("")) {
                System.err.println(ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-MissingArguments"));
                usage.printHelp("PortableSigner", options);
                System.exit(2);
            }
            if (this.password.equals("")) {
                if (!this.pwdFile.equals("")) {
                    try {
                        pwdfis = new FileInputStream(this.pwdFile);
                        byte[] pwd = new byte[1024];
                        this.password = "";
                        try {
                            int r;
                            while ((r = pwdfis.read(pwd)) >= 0) {
                                this.password = this.password + new String(pwd);
                                this.password = this.password.trim();
                                if (pwdfis.available() > 0) continue;
                            }
                            pwdfis.close();
                        }
                        catch (IOException ex) {
                        }
                    }
                    catch (FileNotFoundException fnfex) {}
                } else {
                    System.out.print(ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-MissingPassword"));
                    byte[] pwd = new byte[1024];
                    this.password = "";
                    try {
                        int r;
                        while ((r = System.in.read(pwd)) >= 0) {
                            this.password = this.password + new String(pwd);
                            this.password = this.password.trim();
                            if (System.in.available() > 0) continue;
                            break;
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
            if (!this.ownerPwdString.equals("") && !this.ownerPwdFile.equals("")) {
                this.ownerPwd = new byte[0];
            } else if (!this.ownerPwdString.equals("")) {
                this.ownerPwd = this.ownerPwdString.getBytes();
            } else if (!this.ownerPwdFile.equals("")) {
                try {
                    pwdfis = new FileInputStream(this.ownerPwdFile);
                    this.ownerPwd = new byte[0];
                    byte[] tmp = new byte[1024];
                    try {
                        int r;
                        while ((r = pwdfis.read(tmp)) >= 0) {
                            System.arraycopy(tmp, 0, tmp, 0, r);
                            byte[] full = new byte[this.ownerPwd.length + tmp.length];
                            System.arraycopy(this.ownerPwd, 0, full, 0, this.ownerPwd.length);
                            System.arraycopy(tmp, 0, full, this.ownerPwd.length, tmp.length);
                            this.ownerPwd = full;
                            if (pwdfis.available() > 0) continue;
                        }
                        pwdfis.close();
                    }
                    catch (IOException ex) {}
                }
                catch (FileNotFoundException fnfex) {
                    // empty catch block
                }
            }
        }
        if (!this.embedParams.equals("")) {
            String[] parameter = null;
            parameter = this.embedParams.split(",");
            try {
                Float vPosF = new Float(parameter[0]);
                Float lMarginF = new Float(parameter[1]);
                Float rMarginF = new Float(parameter[2]);
                this.vPos = vPosF.floatValue();
                this.lMargin = lMarginF.floatValue();
                this.rMargin = rMarginF.floatValue();
                this.noSigPage = true;
            }
            catch (NumberFormatException nfe) {
                System.err.println(ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-embedParameter-Error"));
                usage.printHelp("PortableSigner", options);
                System.exit(5);
            }
        }
        if (!this.langcodes.contains(this.sigblock) && !this.sigblock.equals("")) {
            System.err.println(ResourceBundle.getBundle("net/pflaeging/PortableSigner/i18n").getString("CLI-Only-german-english") + this.langcodes);
            usage.printHelp("PortableSigner", options);
            System.exit(4);
        }
        if (this.help.booleanValue()) {
            usage.printHelp("PortableSigner", options);
            System.exit(1);
        }
    }
}

