#!/usr/bin/python
#
# Find when the tests started running slow
#

from __future__ import print_function

from bracket import *
from utils import read_file

def test_system_time(ts):
    fn = os.path.join(results_dir(ts), "test.log.gz")
    f = gzip.open(fn, 'r')
    content = f.read()
    f.close()
    tail = content[-10000:]
    m = re.search(r'(\d+):(\d+)\.(\d+) \[system\]', tail)
    if not m:
        raise RuntimeError("could not find time in %s" % tail)
    min, sec, ms = m.groups()
    print(min, sec, ms)
    return int(min) * 60 + int(sec) + int(ms) * 0.001

use_current_repository()

def f(ts):
    return test_system_time(ts) < 35.0 * 60

begin = rcs2ts('2016.02.13.08.05.06')
end = rcs2ts('2016.02.15.08.08.04')
find_failure(begin, end,
         TestOp(f,
                [test_completed_op],
                name = 'tests_slow'))

