/*
 * Decompiled with CFR 0.152.
 */
package com.gokgs.client.swing;

import com.gokgs.client.KCGame;
import org.igoweb.go.Game;
import org.igoweb.go.Loc;
import org.igoweb.go.sgf.Node;
import org.igoweb.go.sgf.Prop;
import org.igoweb.go.sgf.Tree;
import org.igoweb.go.swing.GobanWidget;
import org.igoweb.go.swing.Sounds;
import org.igoweb.go.swing.Updater;
import org.igoweb.igoweb.client.swing.CommentViewer;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.Defs;
import org.igoweb.util.swing.Prefs;

public class KGameUpdater
extends Updater {
    public static final String NOISY_MOVES_PREF = "bPL-wjB5";
    public static final String ALL_GAMES_NOISY_PREF = "$gr^6i1Q";
    private static boolean soundsLoaded = false;
    private boolean iAmPlayer;
    private boolean soundEnabled = false;
    private CommentViewer commentViewer;
    private KCGame cGame;
    private AFrame undoWindow;

    public KGameUpdater(KCGame cGame, GobanWidget goban, Tree tree) {
        super(goban, tree, true, null, null);
        this.cGame = cGame;
        cGame.getGoGame().addListener(new EventListener(){

            @Override
            public void handleEvent(Event event) {
                if (event.type == 4) {
                    KGameUpdater.this.updateScores();
                }
            }
        });
        this.updateScores();
    }

    private void updateScores() {
        Game game = this.getGame();
        if (game != null) {
            Game masterGame = this.cGame.getGoGame();
            game.setScore(0, masterGame.getScore(0));
            game.setScore(1, masterGame.getScore(1));
        }
    }

    public void setIAmPlaying(boolean newVal) {
        this.iAmPlayer = newVal;
    }

    public void setSoundEnabled(boolean newVal) {
        this.soundEnabled = newVal;
    }

    public void setCommentViewer(CommentViewer newViewer) {
        this.commentViewer = newViewer;
    }

    public void setCGame(KCGame newCGame) {
        this.cGame = newCGame;
    }

    @Override
    protected void treeEvent(Event event) {
        switch (event.type) {
            case 0: {
                Game game;
                Prop param = (Prop)event.arg;
                if (param.type == 14) {
                    if (this.undoWindow != null) {
                        this.undoWindow.dispose();
                    }
                    this.undoWindow = null;
                    if (!this.soundEnabled || !Defs.isSoundEnabled() || !Prefs.getBoolean(NOISY_MOVES_PREF, true) || !this.iAmPlayer && !Prefs.getBoolean(ALL_GAMES_NOISY_PREF, false)) break;
                    Sounds.get(param.getLoc().equals(Loc.PASS) ? "pass" : "stone").play();
                    break;
                }
                if (param.type != 24 || (game = this.getGame()) == null || this.commentViewer == null) break;
                this.commentViewer.append(param.getText(), game.isPlayOver() || this.cGame.isOver() ? -1 : ((Node)event.source).getMoveNum());
                break;
            }
            case 2: {
                Game game;
                Prop prop = (Prop)event.arg;
                if (prop.type != 24 || (game = this.getGame()) == null || this.commentViewer == null) break;
                this.commentViewer.append(prop.getText(), game.isPlayOver() || this.cGame.isOver() ? -1 : ((Node)event.source).getMoveNum());
            }
        }
        super.treeEvent(event);
    }

    public void setUndoWindow(AFrame newUndoWindow) {
        this.undoWindow = newUndoWindow;
    }
}

