/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin.impl.gtk;

import com.l2fprod.gui.plaf.skin.DefaultButton;
import com.l2fprod.gui.plaf.skin.SkinButton;
import com.l2fprod.gui.plaf.skin.impl.AbstractSkinButton;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkUtils;
import com.l2fprod.gui.plaf.skin.impl.gtk.parser.GtkParser;
import com.l2fprod.util.ImageUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;

final class GtkButton
extends AbstractSkinButton
implements SkinButton {
    DefaultButton checkIN;
    DefaultButton checkOUT;
    DefaultButton optionIN;
    DefaultButton optionOUT;
    Icon disabledCheckIN;
    Icon disabledCheckOUT;
    Icon disabledOptionIN;
    Icon disabledOptionOUT;
    DefaultButton disabledButton;
    DefaultButton pressedButton;
    DefaultButton normalButton;
    DefaultButton rolloverButton;
    DefaultButton disabledButtonIN;
    DefaultButton toggleIN;
    DefaultButton toggleOUT;
    DefaultButton toggleRollover;

    public GtkButton(GtkParser parser) throws Exception {
        this.normalButton = GtkUtils.newButton(parser, "GtkButton", new String[]{"function", "state", "shadow"}, new String[]{"BOX", "NORMAL", "OUT"});
        this.pressedButton = GtkUtils.newButton(parser, "GtkButton", new String[]{"function", "state", "shadow"}, new String[]{"BOX", "ACTIVE", "IN"});
        this.disabledButton = GtkUtils.newButton(parser, "GtkButton", new String[]{"function", "state", "shadow"}, new String[]{"BOX", "INSENSITIVE", "OUT"});
        this.disabledButtonIN = GtkUtils.newButton(parser, "GtkButton", new String[]{"function", "state", "shadow"}, new String[]{"BOX", "INSENSITIVE", "IN"});
        this.rolloverButton = GtkUtils.newButton(parser, "GtkButton", new String[]{"function", "state"}, new String[]{"BOX", "PRELIGHT"});
        this.toggleIN = GtkUtils.newButton(parser, "GtkToggleButton", new String[]{"function", "shadow"}, new String[]{"BOX", "IN"});
        this.toggleOUT = GtkUtils.newButton(parser, "GtkToggleButton", new String[]{"function", "shadow", "state"}, new String[]{"BOX", "OUT", null});
        this.toggleRollover = GtkUtils.newButton(parser, "GtkToggleButton", new String[]{"function", "state"}, new String[]{"BOX", "PRELIGHT"});
        this.checkIN = GtkUtils.newButton(parser, "GtkCheckButton", new String[]{"function", "shadow"}, new String[]{"CHECK", "IN"});
        this.disabledCheckIN = ImageUtils.getDisabledIcon(this.checkIN.center);
        this.checkOUT = GtkUtils.newButton(parser, "GtkCheckButton", new String[]{"function", "shadow"}, new String[]{"CHECK", "OUT"});
        this.disabledCheckOUT = ImageUtils.getDisabledIcon(this.checkOUT.center);
        this.optionIN = GtkUtils.newButton(parser, "GtkRadioButton", new String[]{"function", "shadow"}, new String[]{"OPTION", "IN"});
        this.disabledOptionIN = ImageUtils.getDisabledIcon(this.optionIN.center);
        this.optionOUT = GtkUtils.newButton(parser, "GtkRadioButton", new String[]{"function", "shadow"}, new String[]{"OPTION", "OUT"});
        this.disabledOptionOUT = ImageUtils.getDisabledIcon(this.optionOUT.center);
    }

    public Dimension getCheckBoxIconSize() {
        if (this.checkIN != null) {
            return new Dimension(this.checkIN.getIconWidth(), this.checkIN.getIconHeight());
        }
        return new Dimension(13, 13);
    }

    public Dimension getRadioButtonIconSize() {
        if (this.optionIN != null) {
            return new Dimension(this.optionIN.getIconWidth(), this.optionIN.getIconHeight());
        }
        return new Dimension(13, 13);
    }

    public Icon getRadioIcon(AbstractButton b) {
        ButtonModel model = b.getModel();
        if (b instanceof JRadioButton || b instanceof JRadioButtonMenuItem) {
            if (model.isSelected() || model.isPressed() && model.isArmed()) {
                return b.isEnabled() ? this.optionIN : this.disabledOptionIN;
            }
            if (!model.isEnabled()) {
                if (model.isSelected()) {
                    return b.isEnabled() ? this.optionOUT : this.disabledOptionOUT;
                }
                return b.isEnabled() ? this.optionOUT : this.disabledOptionOUT;
            }
            return b.isEnabled() ? this.optionOUT : this.disabledOptionOUT;
        }
        if (b instanceof JCheckBox || b instanceof JCheckBoxMenuItem) {
            if (model.isSelected() || model.isPressed() && model.isArmed()) {
                return b.isEnabled() ? this.checkIN : this.disabledCheckIN;
            }
            if (!model.isEnabled()) {
                if (model.isSelected()) {
                    return b.isEnabled() ? this.checkOUT : this.disabledCheckOUT;
                }
                return b.isEnabled() ? this.checkOUT : this.disabledCheckOUT;
            }
            return b.isEnabled() ? this.checkOUT : this.disabledCheckOUT;
        }
        return null;
    }

    public boolean status() {
        return true;
    }

    public boolean installSkin(JComponent c) {
        return true;
    }

    protected boolean paintDisabledButton(Graphics g, AbstractButton b) {
        this.disabledButton.paint(g, b);
        return true;
    }

    protected boolean paintPressedToggle(Graphics g, AbstractButton b) {
        this.toggleIN.paint(g, b);
        return true;
    }

    protected boolean paintRolloverToggle(Graphics g, AbstractButton b) {
        this.toggleRollover.paint(g, b);
        return true;
    }

    protected boolean paintToggle(Graphics g, AbstractButton b) {
        this.toggleOUT.paint(g, b);
        return true;
    }

    protected boolean paintPressedButton(Graphics g, AbstractButton b) {
        this.pressedButton.paint(g, b);
        return true;
    }

    protected boolean paintRolloverButton(Graphics g, AbstractButton b) {
        this.rolloverButton.paint(g, b);
        return true;
    }

    protected boolean paintNormalButton(Graphics g, AbstractButton b) {
        this.normalButton.paint(g, b);
        return true;
    }
}

