/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.file;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.NativeIntegration;
import net.rubygrapefruit.platform.NativeIntegrationUnavailableException;
import net.rubygrapefruit.platform.ThreadSafe;
import net.rubygrapefruit.platform.internal.NativeLibraryLoader;
import net.rubygrapefruit.platform.internal.NativeLibraryLocator;
import net.rubygrapefruit.platform.internal.Platform;
import net.rubygrapefruit.platform.internal.jni.AbstractNativeFileEventFunctions;
import net.rubygrapefruit.platform.internal.jni.LinuxFileEventFunctions;
import net.rubygrapefruit.platform.internal.jni.OsxFileEventFunctions;
import net.rubygrapefruit.platform.internal.jni.WindowsFileEventFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class FileEvents {
    private static NativeLibraryLoader loader;
    private static final Map<Class<?>, Object> integrations;

    private FileEvents() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe
    public static void init(File extractDir) throws NativeIntegrationUnavailableException, NativeException {
        Class<FileEvents> clazz = FileEvents.class;
        synchronized (FileEvents.class) {
            if (loader == null) {
                Platform platform = Platform.current();
                try {
                    loader = new NativeLibraryLoader(platform, new NativeLibraryLocator(extractDir, "100fb08df4bc3b14c8652ba06237920a3bd2aa13389f12d3474272988ae205f9"));
                    loader.load(FileEvents.determineLibraryName(platform), platform.getLibraryVariants());
                    String nativeVersion = AbstractNativeFileEventFunctions.getVersion();
                    if (!nativeVersion.equals("100fb08df4bc3b14c8652ba06237920a3bd2aa13389f12d3474272988ae205f9")) {
                        throw new NativeException(String.format("Unexpected native file events library version loaded. Expected %s, was %s.", nativeVersion, "100fb08df4bc3b14c8652ba06237920a3bd2aa13389f12d3474272988ae205f9"));
                    }
                }
                catch (NativeException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new NativeException("Failed to initialise native integration.", t);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe
    public static <T extends NativeIntegration> T get(Class<T> type) throws NativeIntegrationUnavailableException, NativeException {
        FileEvents.init(null);
        Class<FileEvents> clazz = FileEvents.class;
        synchronized (FileEvents.class) {
            Platform platform = Platform.current();
            Object instance = integrations.get(type);
            if (instance == null) {
                try {
                    instance = FileEvents.getEventFunctions(type, platform);
                }
                catch (NativeException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new NativeException(String.format("Failed to load native integration %s.", type.getSimpleName()), t);
                }
                integrations.put(type, instance);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (T)((NativeIntegration)type.cast(instance));
        }
    }

    private static <T extends NativeIntegration> T getEventFunctions(Class<T> type, Platform platform) {
        if (platform.isWindows() && type.equals(WindowsFileEventFunctions.class)) {
            return (T)((NativeIntegration)type.cast(new WindowsFileEventFunctions()));
        }
        if (platform.isLinux() && type.equals(LinuxFileEventFunctions.class)) {
            return (T)((NativeIntegration)type.cast(new LinuxFileEventFunctions()));
        }
        if (platform.isMacOs() && type.equals(OsxFileEventFunctions.class)) {
            return (T)((NativeIntegration)type.cast(new OsxFileEventFunctions()));
        }
        throw new NativeIntegrationUnavailableException(String.format("Native integration %s is not supported for %s.", type.getSimpleName(), platform.toString()));
    }

    private static String determineLibraryName(Platform platform) {
        if (platform.isLinux()) {
            return "libnative-platform-file-events.so";
        }
        if (platform.isMacOs()) {
            return "libnative-platform-file-events.dylib";
        }
        if (platform.isWindows()) {
            return "native-platform-file-events.dll";
        }
        throw new NativeIntegrationUnavailableException(String.format("Native file events integration is not available for %s.", platform));
    }

    static {
        integrations = new HashMap();
    }
}

