/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;

final class CharBufferImpl
extends CharBuffer {
    private boolean readOnly;

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final CharBuffer slice() {
        return new CharBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public final CharBuffer duplicate() {
        return new CharBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    public final CharBuffer asReadOnlyBuffer() {
        return new CharBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    public final CharBuffer compact() {
        this.checkIfReadOnly();
        this.mark = -1;
        int n = 0;
        while (this.remaining() > 0) {
            this.put(n, this.get());
            ++n;
        }
        this.position(n);
        this.limit(this.capacity());
        return this;
    }

    public final boolean isDirect() {
        return false;
    }

    public final CharSequence subSequence(int n, int n2) {
        if (n < 0 || n > this.length() || n2 < n || n2 > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return new CharBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.position() + n2, this.position() + n, -1, this.isReadOnly());
    }

    public final char get() {
        if (this.pos >= this.limit) {
            throw new BufferUnderflowException();
        }
        return this.backing_buffer[this.pos++ + this.array_offset];
    }

    public final CharBuffer put(char c) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        if (this.pos >= this.limit) {
            throw new BufferOverflowException();
        }
        this.backing_buffer[this.pos++ + this.array_offset] = c;
        return this;
    }

    public final char get(int n) {
        this.checkIndex(n);
        return this.backing_buffer[n + this.array_offset];
    }

    public final CharBuffer get(char[] cArray, int n, int n2) {
        CharBufferImpl.checkArraySize(cArray.length, n, n2);
        this.checkForUnderflow(n2);
        System.arraycopy(this.backing_buffer, this.pos + this.array_offset, cArray, n, n2);
        this.pos += n2;
        return this;
    }

    public final CharBuffer put(char[] cArray, int n, int n2) {
        CharBufferImpl.checkArraySize(cArray.length, n, n2);
        this.checkForOverflow(n2);
        System.arraycopy(cArray, n, this.backing_buffer, this.pos + this.array_offset, n2);
        this.pos += n2;
        return this;
    }

    public final CharBuffer put(int n, char c) {
        this.checkIndex(n);
        this.checkIfReadOnly();
        this.backing_buffer[n + this.array_offset] = c;
        return this;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    CharBufferImpl(int n) {
        this(new char[n], 0, n, n, 0, -1, false);
    }

    CharBufferImpl(char[] cArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(n2, n3, n4, n5);
        this.backing_buffer = cArray;
        this.array_offset = n;
        this.readOnly = bl;
    }

    public CharBufferImpl(CharBufferImpl charBufferImpl) {
        super(charBufferImpl.capacity(), charBufferImpl.limit(), charBufferImpl.position(), 0);
        this.backing_buffer = charBufferImpl.backing_buffer;
        this.array_offset = charBufferImpl.array_offset;
        this.readOnly = charBufferImpl.isReadOnly();
    }
}

