/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_PLUGIN_FORMULA_H__
#define __SG_PLUGIN_FORMULA_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "widgets/sg_worksheet.h"
#include "sg_plugin.h"

#define SG_PLUGIN_FORMULA(obj)        GTK_CHECK_CAST (obj, sg_plugin_formula_get_type (), SGpluginFormula)
#define GTK_TYPE_SG_PLUGIN_FORMULA   (sg_plugin_formula_get_type ())

#define SG_PLUGIN_FORMULA_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, sg_plugin_formula_get_type(), SGpluginFormulaClass)
#define GTK_IS_SG_PLUGIN_FORMULA(obj)     GTK_CHECK_TYPE (obj, sg_plugin_formula_get_type ())


typedef struct _SGpluginFormula   SGpluginFormula;
typedef struct _SGpluginFormulaClass   SGpluginFormulaClass;
typedef gboolean (*SGpluginFormulaFunction)  (SGpluginFormula *plugin, SGworksheet *w, gint row, gint col);

struct _SGpluginFormula
{
  SGplugin plugin;

  SGpluginFormulaFunction action; 
};

struct _SGpluginFormulaClass
{
  SGpluginClass parent_class;
};

GtkType		sg_plugin_formula_get_type	();
SGpluginFormula *sg_plugin_formula_new		();
gboolean   	sg_plugin_formula_action	(SGpluginFormula *plugin, 
						 SGworksheet *w,
						 gint row,
						 gint col);
SGpluginFormula *  sg_plugin_formula_get	(const gchar *name);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_PLUGIN_FORMULA_H__ */

