# Copyright (C) 2008 LottaNZB Development Team
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

from lottanzb.core import App

class Mode:
    def __init__(self, config):
        self.config = config
        self._signal_ids = []
        self.init_error = ""
    
    def enter(self):
        App().backend.connectToHella(*self.get_connection_args())
        
        event_map = { "unexpected-disconnect" : self.handle_disconnect }
        
        for event, handler in event_map.iteritems():
            self._signal_ids.append(App().backend.connect(event, handler))
        
        self.init_error = ""
    
    def leave(self):
        App().backend.disconnectFromHella()
        
        map(App().backend.disconnect, self._signal_ids)
        self._signal_ids = []
    
    def reenter(self):
        self.leave()
        self.enter()
    
    def __str__(self):
        return self.short
    
    def handle_disconnect(self, backend):
        pass
    
    def get_connection_args(self):
        raise NotImplementedError
    
    @classmethod
    def get_name(cls):
        return cls.__module__.split(".")[-1]
