# 0 /usr/pkgsrc/lang/mpd/work/mpd.1.0.1/library/gmpdwin.mpd 3+

global MPDWin


 const int DefaultPoll = 100
 const int UseDefault = 0
 const int OffScreen = 1

 type winVoid = ptr any
 type winWindow = winVoid
 type winFont = winVoid
 type winImage = winVoid

 type winInitialState = int
 type winError = int

 type winPoint = rec ( int x ; int y ; )
 type winRectangle = rec ( int x ; int y ; int w ; int h ; )






 type winEventType = int
 const int Ev_None = 0
 const int Ev_ButtonDown = 1
 const int Ev_ButtonUp = 2
 const int Ev_KeyDown = 4
 const int Ev_KeyUp = 8
 const int Ev_PointerMove = 16
 const int Ev_EnterWindow = 32
 const int Ev_ExitWindow = 64
 const int Ev_DeleteWindow = 128
 const int Ev_All = Ev_ButtonDown |
 Ev_ButtonUp |
 Ev_KeyDown |
 Ev_KeyUp |
 Ev_PointerMove |
 Ev_EnterWindow |
 Ev_ExitWindow |
 Ev_DeleteWindow

 type winButtonKeyStatus = int
 const int BK_None = 0
 const int BK_Button1 = 1
 const int BK_Button2 = 2
 const int BK_Button3 = 4
 const int BK_Button4 = 8
 const int BK_Button5 = 16
 const int BK_SHIFT = 32
 const int BK_LOCK = 64
 const int BK_CNTRL = 128
 const int BK_Mod1 = 256
 const int BK_Mod2 = 512
 const int BK_Mod3 = 1024
 const int BK_Mod4 = 2048
 const int BK_Mod5 = 4096

 type winLineStyle = enum ( LineSolid ,
 LineDoubleDash ,
 LineOnOffDash )

 type winCapStyle = enum ( CapNotLast ,
 CapButt ,
 CapRound ,
 CapProjecting )

 type winJoinStyle = enum ( JoinMiter ,
 JoinRound ,
 JoinBevel )

 type winFillStyle = enum ( FillSolid ,
 FillTiled ,
 FillOpaqueStippled ,
 FillStippled )

 type winFillRule = enum ( FillEvenOddRule ,
 FillWindingRule )

 type winArcMode = enum ( ArcChord ,
 ArcPieSlice )

 type winStdCursor = enum (
 XC_X_cursor , XC_arrow ,
 XC_based_arrow_down , XC_based_arrow_up ,
 XC_boat , XC_bogosity ,
 XC_bottom_left_corner , XC_bottom_right_corner ,
 XC_bottom_side , XC_bottom_tee ,
 XC_box_spiral , XC_center_ptr ,
 XC_circle , XC_clock ,
 XC_coffee_mug , XC_cross ,
 XC_cross_reverse , XC_crosshair ,
 XC_diamond_cross , XC_dot ,
 XC_dotbox , XC_double_arrow ,
 XC_draft_large , XC_draft_small ,
 XC_draped_box , XC_exchange ,
 XC_fleur , XC_gobbler ,
 XC_gumby , XC_hand1 ,
 XC_hand2 , XC_heart ,
 XC_icon , XC_iron_cross ,
 XC_left_ptr , XC_left_side ,
 XC_left_tee , XC_leftbutton ,
 XC_ll_angle , XC_lr_angle ,
 XC_man , XC_middlebutton ,
 XC_mouse , XC_pencil ,
 XC_pirate , XC_plus ,
 XC_question_arrow , XC_right_ptr ,
 XC_right_side , XC_right_tee ,
 XC_rightbutton , XC_rtl_logo ,
 XC_sailboat , XC_sb_down_arrow ,
 XC_sb_h_double_arrow , XC_sb_left_arrow ,
 XC_sb_right_arrow , XC_sb_up_arrow ,
 XC_sb_v_double_arrow , XC_shuttle ,
 XC_sizing , XC_spider ,
 XC_spraycan , XC_star ,
 XC_target , XC_tcross ,
 XC_top_left_arrow , XC_top_left_corner ,
 XC_top_right_corner , XC_top_side ,
 XC_top_tee , XC_trek ,
 XC_ul_angle , XC_umbrella ,
 XC_ur_angle , XC_watch ,
 XC_xterm , XC_None )

 type winCursor = winVoid

 type winColor = string [ * ]
 type winPixel = winVoid


 type winDrawOp = enum ( Op_Clear ,
 Op_And ,
 Op_AndReverse ,
 Op_Copy ,
 Op_AndInverted ,
 Op_Noop ,
 Op_Xor ,
 Op_Or ,
 Op_Nor ,
 Op_Equiv ,
 Op_Invert ,
 Op_OrReverse ,
 Op_CopyInverted ,
 Op_OrInverted ,
 Op_Nand ,
 Op_Set )

 type winEvent = rec ( winEventType event_type
 winWindow window
 int x , y
 int bk_status
 int data
 int keysym
 )

 optype winEventChannel ( winEvent ) { send }





 op WinOpen ( string [ * ] display ,
 string [ * ] title ,
 cap winEventChannel evchannel ,
 winInitialState state ,
 int w , int h
 ) returns winWindow win

 op WinClose ( winWindow win )

 op WinCreateSubwindow ( winWindow oldwin ,
 cap winEventChannel evchannel ,
 winInitialState state ,
 int x , int y , int w , int h )
 returns winWindow newwin

 op WinDestroyWindow ( winWindow win )

 op WinSetBorder ( winWindow win , int width , winColor color )
 returns winPixel pv

 op WinNewContext ( winWindow oldwin ) returns winWindow newwin
 op WinCopyContext ( winWindow srcwin , winWindow destwin )

 op WinFlush ( winWindow win )
 op WinSync ( winWindow win , bool discard )

 op WinBell ( winWindow win , int percent )

 op WinDrawPixel ( winWindow win , winPoint pt )

 op WinDrawLine ( winWindow win , winPoint pt1 , winPoint pt2 )
 op WinDrawPolyline ( winWindow win , winPoint pts [ * ] )
 op WinDrawPolygon ( winWindow win , winPoint pts [ * ] )
 op WinFillPolygon ( winWindow win , winPoint pts [ * ] )

 op WinDrawRectangle ( winWindow win , winRectangle rect )
 op WinFillRectangle ( winWindow win , winRectangle rect )

 op WinDrawArc ( winWindow win , winRectangle box , int a1 , int a2 )
 op WinFillArc ( winWindow win , winRectangle box , int a1 , int a2 )

 op WinClearArea ( winWindow win , winRectangle area )
 op WinEraseArea ( winWindow win , winRectangle area )
 op WinCopyArea ( winWindow srcw , winWindow destw ,
 winRectangle src_rect , winPoint destp )

 op WinSetLabels ( winWindow win , string [ * ] wlab , string [ * ] ilab )

 op WinSetPoll ( winWindow win , int ticks )
 op WinSetEventMask ( winWindow win , int em )

 op WinMapWindow ( winWindow win )
 op WinUnmapWindow ( winWindow win )
 op WinMapSubwindows ( winWindow win )
 op WinUnmapSubwindows ( winWindow win )
 op WinRaiseWindow ( winWindow win )
 op WinLowerWindow ( winWindow win )
 op WinMoveWindow ( winWindow win , winPoint pt )
 op WinEnableOutput ( winWindow win )
 op WinDisableOutput ( winWindow win )
 op WinUpdateWindow ( winWindow win )

 op WinSetForeground ( winWindow win , winColor fg ) returns winPixel pv
 op WinSetBackground ( winWindow win , winColor bg ) returns winPixel pv
 op WinSetForegroundByPixel ( winWindow win , winPixel pv )
 op WinSetBackgroundByPixel ( winWindow win , winPixel pv )

 op WinSetClipRectangles ( winWindow win , winPoint origin ,
 winRectangle rects [ * ] )

 op WinSetLineAttr ( winWindow win , int line_width , winLineStyle line_style ,
 winCapStyle cap_style , winJoinStyle join_style )
 op WinSetFillAttr ( winWindow win , winFillStyle fill_style ,
 winFillRule fill_rule )
 op WinSetDashes ( winWindow win , int dash_offset , string [ * ] dash_list )
 op WinSetArcMode ( winWindow win , winArcMode arc_mode )
 op WinSetDrawOp ( winWindow win , winDrawOp dop )

 op WinDefaultFont ( winWindow win ) returns winFont font
 op WinLoadFont ( winWindow win , string [ * ] fontname ) returns winFont font
 op WinSetFont ( winWindow win , winFont font )
 op WinFreeFont ( winWindow win , winFont font )

 op WinTextWidth ( winFont font , string [ * ] str ) returns int width
 external WinFontAscent ( winFont ) returns int
 external WinFontDescent ( winFont ) returns int

 op WinDrawString ( winWindow win , winPoint pt , string [ * ] str )
 op WinDrawImageString ( winWindow win , winPoint pt , string [ * ] str )

 op WinCreateCursor ( winWindow win , winStdCursor stdcursor )
 returns winCursor cur
 op WinSetCursor ( winWindow win , winCursor cursor , winColor fg , winColor bg )
 returns winError err
 op WinFreeCursor ( winWindow win , winCursor cursor )

 op WinCreateImage ( winWindow win , int depth , int w , int h )
 returns winImage im
 op WinGetPixel ( winImage im , winPoint pt ) returns winPixel pv
 op WinPutPixel ( winImage im , winPoint pt , winPixel pv )
 op WinAddPixel ( winImage im , winPixel pv )
 op WinPutImage ( winWindow win , winImage im , winRectangle src_rect ,
 winPoint dest )
 op WinGetImage ( winWindow win , winImage im , winRectangle src_rect ,
 winPoint dest )
 op WinDestroyImage ( winImage im )


 body MPDWin ; end ;
