/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.glyphs;

import com.xerox.VTM.engine.Camera;
import java.awt.Shape;
import java.awt.geom.Point2D;
import net.claribole.zvtm.glyphs.PathElement;

class MOVElement
extends PathElement {
    Point2D[] pc;
    Point2D[] lpc;

    MOVElement(long x, long y) {
        this.type = 0;
        this.x = x;
        this.y = y;
    }

    void initCams(int nbCam) {
        this.pc = new Point2D[nbCam];
        this.lpc = new Point2D[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new Point2D.Double();
            this.lpc[i] = new Point2D.Double();
        }
    }

    void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                Point2D[] ta = this.pc;
                this.pc = new Point2D[ta.length + 1];
                System.arraycopy(ta, 0, this.pc, 0, ta.length);
                this.pc[this.pc.length - 1] = new Point2D.Double();
                ta = this.lpc;
                this.lpc = new Point2D[ta.length + 1];
                System.arraycopy(ta, 0, this.lpc, 0, ta.length);
                this.lpc[this.lpc.length - 1] = new Point2D.Double();
            } else {
                System.err.println("DPath:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new Point2D[1];
            this.pc[0] = new Point2D.Double();
            this.lpc = new Point2D[1];
            this.lpc[0] = new Point2D.Double();
        } else {
            System.err.println("DPath:Error while adding camera " + verifIndex);
        }
    }

    void removeCamera(int index) {
        this.pc[index] = null;
        this.lpc[index] = null;
    }

    void project(int i, int hw, int hh, Camera c, float coef, double px, double py) {
        this.pc[i].setLocation((float)hw + (float)(this.x - c.posx) * coef, (float)hh - (float)(this.y - c.posy) * coef);
    }

    void projectForLens(int i, int hw, int hh, long lx, long ly, float coef, double px, double py) {
        this.lpc[i].setLocation((float)hw + (float)(this.x - lx) * coef, (float)hh - (float)(this.y - ly) * coef);
    }

    double getX(int i) {
        return this.pc[i].getX();
    }

    double getY(int i) {
        return this.pc[i].getY();
    }

    double getlX(int i) {
        return this.lpc[i].getX();
    }

    double getlY(int i) {
        return this.lpc[i].getY();
    }

    Shape getShape(int i) {
        return null;
    }

    Shape getlShape(int i) {
        return null;
    }
}

