.\" $Header: /home/vikas/src/nocol/doc/RCS/netconsole.1,v 1.11 1998/08/13 15:55:40 vikas Exp $
.\"
.TH NETCONSOLE 1 "May 1994"
.SH NAME
nocol \- Curses display agent for the NOCOL (
.I Network Operation Center OnLine
) network monitoring package.
.\" --------------------------------------------
.SH SYNOPSIS
.B netconsole
[
.B \-e
] [
.B \-d
] [
.B \-s
] [
.B \-l 
.I level
] [
.I data-directory
]

This program displays NOCOL format events by parsing all the datafiles in
the NOCOL data directory (or alternate directory specified).
.\" --------------------------------------------
.SH OPTIONS
.TP
.B \-e
For \fIextended\fR (132 column) display mode (resize your terminal to 132
column mode)
.TP
.B \-d
For \fIdebug\fR mode - various debug messages are displayed in the message
window to help debug the program.
.TP
.B \-s
For \fIsilent\fR mode - the warning bell/beep is permanently turned off
while displaying critical events. This option is only available from the
command line.
.TP
.B \-l
The display \fIlevel\fR which varies from:
.nf
	1	Critical events only
	2	Errors and critical events
	3	Warning, errors and critical events
	4	Informational, warning, errors and critical events
.fi
.TP
.I <data directory>
which is an alternate data directory name where NOCOL format data files are
located. If no directory name is specified, then the program parses all files
in a predefined
.I data
directory.
.LP
The default display severity level is Critical. However, you can set your
shell environment variable
.B NOCOL_SEVERITY
to one of Critical, Error, Warning, Info to set your desired severity
level.
.\" --------------------------------------------
.SH DESCRIPTION
.LP
.B netconsole
is the display agent for viewing the event data collected by various
monitoring programs in the NOCOL format. It uses the 
.I curses
screen management system and thus supports a wide variety of terminal types.

All events in NOCOL are classified as
.I CRITICAL, ERROR, WARNING
and
.I INFO.
Depending on the user selectable display 
.IR level ,
all events more severe than the selected level are displayed.
Hence if the selected display level is '3 (=WARNING)',
then all CRITICAL, ERROR and WARNING events are displayed on the terminal.

The screen automatically scrolls if there are more than a screenful of events
to be displayed. If a new site goes CRITICAL, the terminal starts beeping (if
the terminal type supports it) and the site shows up in reverse video.

A portion of the screen is used for displaying text messages (the 
.I MESSAGES
window). All files in a specific 
.I MSGS
directory (set during compile time) are displayed line by line sequentially.
This can give information about scheduled downtimes,  past logs, debug
messages, etc.

Additional capabilities include:
.IP -
freezing the screen so that the next screenful is displayed only when 
the user enters a key on the terminal
.IP -
filtering out the sites to be displayed by putting a filter which tests
against the lines to be displayed
.IP -
resizing window sizes

.SH DISPLAY FIELDS
The various fields that are displayed in \fBnetconsole\fR are:
.IP Site name
which is the name of the system that is being monitored.
.IP Address
This is the network address (IP, OSI NSAP) or any other resource
for the entity being monitored.
.IP Date/Time
the time stamp for the event. Note that some (most) monitors set this to the
time when the site was \fIinitially\fR detected in the current state 
.RI ( e.g.
when a site was first detected unreachable via
.IR ping ).
.IP Sender
is the name of the monitoring program
.RI ( "pingmon, nsmon, tsmon, tpmon"
) that recorded this event.
.IP Variable
is the name of the variable that is being monitored. Further information
regarding the type of variable and its properties can be found in the
descriptions of the respective 
.IR Sender .
Typical names are
.I reachability, thruput, named-status.
.IP Value
It is a long integer indicating the value of the variable being monitored.
.IP Threshold
The threshold value of the variable due to which the event is in the present
state/level. This can be a less-than or a greater-than threshold type,
depending on the monitor.
.IP Units
it is the units for the value being displayed.
.IP Flags
This is an integer used internally by the various agents. Each bit signifies
one of the following flags for that particular site:
.in +.5i
.DS
0x01	Site UP
.br
0x02	Site DOWN
.br
0x04	Status UNKNOWN
.br
0x08	Site in TEST mode
.DE
.in -.5i
.IP Condition
is the last known condition of the variable and is listed as one of
.I critical, error, warning 
or
.I informational.

.\" --------------------------------------------
.SH RUN TIME OPTIONS
.LP
.I netconsole
allows certain options to be entered at the prompt while running the
program. A carriage return is not necessary after entering an option,
and the keystrokes are not echoed. Thus, to change the display level,
the user simply presses a 
.I 'l'
on the keyboard followed by a number representing the display level.

The following options can be entered at the prompt while running 
.BR netconsole \-
.TP
.B h
for help
.TP
.B b
to turn the bell off once a critical event is acknowledged.
.TP
.B c
Condense the number of lines in the 
.I event
window, and correspondingly increase the size of the 
.I messages
window.
.TP
.B d
for toggling debug mode. Debug messages are displayed in the MESSAGES
sub-window of the netconsole display.
.TP
.B e
for toggling between extended (132 column) and short (80 column) display modes.
.TP
.B f
For toggling \fIfreezing\fR the screen. Once this option is set, the screen
will not scroll until the user enters a key on the keyboard.
.TP
.B l
.I <level>
for selecting a display level. Here the 
.I level
is any number between 1 and 4 (where 
.RI 1= "Critical, "
.RI 2= "Error, "
.RI 3= "Warning, "
.RI 4= "Info "
). Alternatively, the characters
.I C, E, W, I
can also be used.
.TP
.B r
to redraw/refresh a messed up screen.
.TP
.B "s /"
to put a search filter on the lines being displayed. Only lines that match
the filter specified will be displayed. The filter can have multiple words
separated by
.B '|'
or
.B '&'
for matching either or all of the words. The current display mode
(80 column or 132 column expanded) is taken into consideration when matching
the pattern.
.br
Thus, a filter such as:
.in +.5i
.DS
AWORD | BWORD | CWORD & DWORD | EWORD
.DE
.in -.5i
will search for lines that have \fIeither\fR
.RS
.IP -
AWORD or
.IP -
BWORD or
.IP -
CWORD and DWORD (both)
.IP -
EWORD
.RE
.IP
in the display lines.
.TP
.B x
To \fIexpand\fR the number of lines in the \fIevent\fR window.
.TP
.B q
to quit from the program.
.\" --------------------------------------------
.SH AUTHOR
Vikas Aggarwal, vikas@navya.com
.SH SEE ALSO
netconsole(1) nocol-prog(3) perlnocol(3)
etherload(8) eventselect(8) genmon(8) noclogd(8) nocol-overview(8)
nocol-utility(8) nsmon(8) pingmon(8) portmon(8) 
tpmon(8) trapmon(8)

