/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.AttributeSet;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class CopyNode
extends TemplateNode {
    final String uas;

    final TemplateNode clone(Stylesheet stylesheet) {
        CopyNode ret = new CopyNode(this.uas);
        if (this.children != null) {
            ret.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            ret.next = this.next.clone(stylesheet);
        }
        return ret;
    }

    final void doApply(Stylesheet stylesheet, QName mode, Node context, int pos, int len, Node parent, Node nextSibling) throws TransformerException {
        Node copy = parent;
        switch (context.getNodeType()) {
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
                copy = context.cloneNode(false);
                copy = doc.adoptNode(copy);
                if (copy.getNodeType() == 2) {
                    NamedNodeMap attrs;
                    if (parent.getFirstChild() != null || (attrs = parent.getAttributes()) == null) break;
                    attrs.setNamedItemNS(copy);
                    break;
                }
                if (nextSibling != null) {
                    parent.insertBefore(copy, nextSibling);
                    break;
                }
                parent.appendChild(copy);
            }
        }
        if (this.uas != null) {
            StringTokenizer st = new StringTokenizer(this.uas, " ");
            while (st.hasMoreTokens()) {
                this.addAttributeSet(stylesheet, mode, context, pos, len, copy, null, st.nextToken());
            }
        }
        if (this.children != null) {
            this.children.apply(stylesheet, mode, context, pos, len, copy, null);
        }
        if (this.next != null) {
            this.next.apply(stylesheet, mode, context, pos, len, parent, nextSibling);
        }
    }

    final void addAttributeSet(Stylesheet stylesheet, QName mode, Node context, int pos, int len, Node parent, Node nextSibling, String attributeSet) throws TransformerException {
        Iterator i = stylesheet.attributeSets.iterator();
        while (i.hasNext()) {
            AttributeSet as = (AttributeSet)i.next();
            if (!as.name.equals(attributeSet)) continue;
            if (as.uas != null) {
                StringTokenizer st = new StringTokenizer(as.uas, " ");
                while (st.hasMoreTokens()) {
                    this.addAttributeSet(stylesheet, mode, context, pos, len, parent, nextSibling, st.nextToken());
                }
            }
            if (as.children == null) continue;
            as.children.apply(stylesheet, mode, context, pos, len, parent, nextSibling);
        }
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        buf.append('[');
        buf.append(']');
        return buf.toString();
    }

    CopyNode(String uas) {
        this.uas = uas;
    }
}

