/*
 * This file has been generated by the onto2vocabularyclass tool
 * copyright (C) 2007-2008 Sebastian Trueg <trueg@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _SOPRANO_RDF_H_
#define _SOPRANO_RDF_H_

#include <QtCore/QUrl>
#include "soprano_export.h"

namespace Soprano {
    namespace Vocabulary {
        namespace RDF {
            /**
             * http://www.w3.org/1999/02/22-rdf-syntax-ns#
             */
            SOPRANO_EXPORT QUrl rdfNamespace();

            /**
             * http://www.w3.org/1999/02/22-rdf-syntax-ns#Alt 
             * 
             * The class of containers of alternatives. 
             */
            SOPRANO_EXPORT QUrl Alt();

            /**
             * http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag 
             * 
             * The class of unordered containers. 
             */
            SOPRANO_EXPORT QUrl Bag();

            /**
             * http://www.w3.org/1999/02/22-rdf-syntax-ns#List 
             * 
             * The class of RDF Lists. 
             */
            SOPRANO_EXPORT QUrl List();

            /**
             * http://www.w3.org/1999/02/22-rdf-syntax-ns#Property 
             * 
             * The class of RDF properties. 
             */
            SOPRANO_EXPORT QUrl Property();

            /**
             * http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq 
             * 
             * The class of ordered containers. 
             */
            SOPRANO_EXPORT QUrl Seq();

            /**
             * http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement 
             * 
             * The class of RDF statements. 
             */
            SOPRANO_EXPORT QUrl Statement();

            /**
             * http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral 
             * 
             * The class of XML literal values. 
             */
            SOPRANO_EXPORT QUrl XMLLiteral();

            /**
             * http://www.w3.org/1999/02/22-rdf-syntax-ns#first 
             * 
             * The first item in the subject RDF list. 
             */
            SOPRANO_EXPORT QUrl first();

            /**
             * http://www.w3.org/1999/02/22-rdf-syntax-ns#nil 
             * 
             * The empty list, with no items in it. If the rest of a list is nil 
             * then the list has no more items in it. 
             */
            SOPRANO_EXPORT QUrl nil();

            /**
             * http://www.w3.org/1999/02/22-rdf-syntax-ns#object 
             * 
             * The object of the subject RDF statement. 
             */
            SOPRANO_EXPORT QUrl object();

            /**
             * http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate 
             * 
             * The predicate of the subject RDF statement. 
             */
            SOPRANO_EXPORT QUrl predicate();

            /**
             * http://www.w3.org/1999/02/22-rdf-syntax-ns#rest 
             * 
             * The rest of the subject RDF list after the first item. 
             */
            SOPRANO_EXPORT QUrl rest();

            /**
             * http://www.w3.org/1999/02/22-rdf-syntax-ns#subject 
             * 
             * The subject of the subject RDF statement. 
             */
            SOPRANO_EXPORT QUrl subject();

            /**
             * http://www.w3.org/1999/02/22-rdf-syntax-ns#type 
             * 
             * The subject is an instance of a class. 
             */
            SOPRANO_EXPORT QUrl type();

            /**
             * http://www.w3.org/1999/02/22-rdf-syntax-ns#value 
             * 
             * Idiomatic property used for structured values. 
             */
            SOPRANO_EXPORT QUrl value();
        }
    }
}

#endif
