 ############################################################################
 #                                                                          #
 #                         STRINGUTILS.PY                                   #
 #                                                                          #
 #           Copyright (C) 2008 - 2010 Ada Core Technologies, Inc.          #
 #                                                                          #
 # This program is free software: you can redistribute it and/or modify     #
 # it under the terms of the GNU General Public License as published by     #
 # the Free Software Foundation, either version 3 of the License, or        #
 # (at your option) any later version.                                      #
 #                                                                          #
 # This program is distributed in the hope that it will be useful,          #
 # but WITHOUT ANY WARRANTY; without even the implied warranty of           #
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            #
 # GNU General Public License for more details.                             #
 #                                                                          #
 # You should have received a copy of the GNU General Public License        #
 # along with this program.  If not, see <http://www.gnu.org/licenses/>     #
 #                                                                          #
 ############################################################################

"""This module provides various function to process/handle strings
"""

import re


class Filter (object):
    """Class that provide an easy way to apply several filters at the same time
    on a string or a list of strings.

    ??? we should use tuple instead of list

    ATTRIBUTES
      filters: list of filters to apply. each element of filters is either a
        function or a list of the form [ pattern, sub ] where pattern and sub
        string representing regexp
    """

    def __init__(self):
        """Filter constructor

        PARAMETERS
          None

        RETURN VALUE
          An instanciation of Filter
        """
        self.filters = []

    def process(self, item):
        """Apply the filters on the item

        PARAMETERS
          item: this is either a string or a list of strings

        RETURN VALUE
          return the filtered string or list
        """

        def run_aux(line):
            """Apply the filters on a string"""
            result = line
            for p in self.filters:
                if isinstance(p, list):
                    result = re.sub(p[0], p[1], result)
                else:
                    result = p(result)
            return result

        if isinstance(item, list):
            return [run_aux(k) for k in item]
        else:
            return run_aux(item)

    def append(self, pattern):
        """Add a filter

        PARAMETERS
          pattern: eitheir a function of a list containing the matching pattern
            and the sub pattern.

        RETURN VALUE
          None
        """
        self.filters.append(pattern)
