/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.BitwiseXORComposite;
import gnu.java.awt.ClasspathToolkit;
import gnu.java.awt.peer.gtk.GdkFontPeer;
import gnu.java.awt.peer.gtk.GdkPixbufDecoder;
import gnu.java.awt.peer.gtk.GdkTextLayout;
import gnu.java.awt.peer.gtk.GtkComponentPeer;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import gnu.java.awt.peer.gtk.GtkToolkit;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.CropImageFilter;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.ImagingOpException;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GdkGraphics2D
extends Graphics2D {
    private static BasicStroke draw3DRectStroke;
    private final int native_state;
    Paint paint;
    Stroke stroke;
    Color fg;
    Color bg;
    Shape clip;
    AffineTransform transform;
    private GtkComponentPeer component;
    Font font;
    private RenderingHints hints;
    private BufferedImage bimage;
    private boolean pixelConversionRequired;
    private int[] pixelBuffer;
    Composite comp;
    private Stack stateStack;
    private boolean shiftDrawCalls;

    static native void initStaticState();

    private final native void initStateUnlocked(GtkComponentPeer var1);

    private final native void initState(GtkComponentPeer var1);

    private final native void initState(int var1, int var2);

    private final native void initState(int[] var1, int var2, int var3);

    private final native void copyState(GdkGraphics2D var1);

    public native void dispose();

    private final native void cairoSurfaceSetFilter(int var1);

    private final native void cairoSurfaceSetFilterUnlocked(int var1);

    native void connectSignals(GtkComponentPeer var1);

    public void finalize() {
        this.dispose();
    }

    public Graphics create() {
        return new GdkGraphics2D(this);
    }

    public Graphics create(int n, int n2, int n3, int n4) {
        return new GdkGraphics2D(this, n, n2, n3, n4);
    }

    private final void fail_g2d() {
        System.err.println("Attempted to instantiate GdkGraphics2D but Graphics2D not enabled.  Try again with -Dgnu.java.awt.peer.gtk.Graphics=Graphics2D");
        System.exit(1);
    }

    void initComponentGraphics2D() {
        this.initState(this.component);
        this.setColor(this.component.awtComponent.getForeground());
        this.setBackground(this.component.awtComponent.getBackground());
        this.setPaint(this.getColor());
        this.setTransform(new AffineTransform());
        this.setStroke(new BasicStroke());
        this.setRenderingHints(this.getDefaultHints());
        this.setFont(new Font("SansSerif", 0, 12));
        this.stateStack = new Stack();
    }

    void initComponentGraphics2DUnlocked() {
        this.initStateUnlocked(this.component);
        this.setColorUnlocked(this.component.awtComponent.getForeground());
        this.setBackgroundUnlocked(this.component.awtComponent.getBackground());
        this.setPaintUnlocked(this.getColorUnlocked());
        this.setTransformUnlocked(new AffineTransform());
        this.setStrokeUnlocked(new BasicStroke());
        this.setRenderingHintsUnlocked(this.getDefaultHints());
        this.setFontUnlocked(new Font("SansSerif", 0, 12));
        this.stateStack = new Stack();
    }

    private final native void gdkDrawDrawable(GdkGraphics2D var1, int var2, int var3);

    private final native void drawPixels(int[] var1, int var2, int var3, int var4, double[] var5);

    private final native void setTexturePixelsUnlocked(int[] var1, int var2, int var3, int var4);

    private final native void setTexturePixels(int[] var1, int var2, int var3, int var4);

    private final native void setGradient(double var1, double var3, double var5, double var7, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, boolean var17);

    private final native void setGradientUnlocked(double var1, double var3, double var5, double var7, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, boolean var17);

    private final native void cairoSave();

    private final native void cairoRestore();

    private final native void cairoSetMatrix(double[] var1);

    private final native void cairoSetMatrixUnlocked(double[] var1);

    private final native void cairoSetOperator(int var1);

    private final native void cairoSetRGBAColor(double var1, double var3, double var5, double var7);

    private final native void cairoSetRGBAColorUnlocked(double var1, double var3, double var5, double var7);

    private final native void cairoSetFillRule(int var1);

    private final native void cairoSetLineWidth(double var1);

    private final native void cairoSetLineWidthUnlocked(double var1);

    private final native void cairoSetLineCap(int var1);

    private final native void cairoSetLineCapUnlocked(int var1);

    private final native void cairoSetLineJoin(int var1);

    private final native void cairoSetLineJoinUnlocked(int var1);

    private final native void cairoSetDash(double[] var1, int var2, double var3);

    private final native void cairoSetDashUnlocked(double[] var1, int var2, double var3);

    private final native void cairoSetMiterLimit(double var1);

    private final native void cairoSetMiterLimitUnlocked(double var1);

    private final native void cairoNewPath();

    private final native void cairoMoveTo(double var1, double var3);

    private final native void cairoLineTo(double var1, double var3);

    private final native void cairoCurveTo(double var1, double var3, double var5, double var7, double var9, double var11);

    private final native void cairoRelMoveTo(double var1, double var3);

    private final native void cairoRelLineTo(double var1, double var3);

    private final native void cairoRelCurveTo(double var1, double var3, double var5, double var7, double var9, double var11);

    private final native void cairoRectangle(double var1, double var3, double var5, double var7);

    private final native void cairoClosePath();

    private final native void cairoStroke();

    private final native void cairoFill();

    private final native void cairoClip();

    private final void stateSave() {
        this.stateStack.push(new DrawState(this));
        this.cairoSave();
    }

    private final void stateRestore() {
        ((DrawState)this.stateStack.pop()).restore(this);
        this.cairoRestore();
    }

    private final double shifted(double d, boolean bl) {
        if (bl) {
            return Math.floor(d) + 0.5;
        }
        return d;
    }

    private final void walkPath(PathIterator pathIterator, boolean bl) {
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray = new double[6];
        this.cairoSetFillRule(pathIterator.getWindingRule());
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    d = this.shifted(dArray[0], bl);
                    d2 = this.shifted(dArray[1], bl);
                    this.cairoMoveTo(d, d2);
                    break;
                }
                case 1: {
                    d = this.shifted(dArray[0], bl);
                    d2 = this.shifted(dArray[1], bl);
                    this.cairoLineTo(d, d2);
                    break;
                }
                case 2: {
                    double d3 = d + 0.6666666666666666 * (this.shifted(dArray[0], bl) - d);
                    double d4 = d2 + 0.6666666666666666 * (this.shifted(dArray[1], bl) - d2);
                    double d5 = d3 + 0.3333333333333333 * (this.shifted(dArray[2], bl) - d);
                    double d6 = d4 + 0.3333333333333333 * (this.shifted(dArray[3], bl) - d2);
                    d = this.shifted(dArray[2], bl);
                    d2 = this.shifted(dArray[3], bl);
                    this.cairoCurveTo(d3, d4, d5, d6, d, d2);
                    break;
                }
                case 3: {
                    d = this.shifted(dArray[4], bl);
                    d2 = this.shifted(dArray[5], bl);
                    this.cairoCurveTo(this.shifted(dArray[0], bl), this.shifted(dArray[1], bl), this.shifted(dArray[2], bl), this.shifted(dArray[3], bl), d, d2);
                    break;
                }
                case 4: {
                    this.cairoClosePath();
                    break;
                }
            }
            pathIterator.next();
        }
    }

    private final Map getDefaultHints() {
        HashMap hashMap = new HashMap();
        hashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        hashMap.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        hashMap.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        hashMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        return hashMap;
    }

    public static int[] findSimpleIntegerArray(ColorModel colorModel, Raster raster) {
        if (colorModel == null || raster == null) {
            return null;
        }
        if (!colorModel.getColorSpace().isCS_sRGB()) {
            return null;
        }
        if (!(colorModel instanceof DirectColorModel)) {
            return null;
        }
        DirectColorModel directColorModel = (DirectColorModel)colorModel;
        if (directColorModel.getRedMask() != 0xFF0000 || directColorModel.getGreenMask() != 65280 || directColorModel.getBlueMask() != 255) {
            return null;
        }
        if (!(raster instanceof WritableRaster)) {
            return null;
        }
        if (raster.getSampleModel().getDataType() != 3) {
            return null;
        }
        if (!(raster.getDataBuffer() instanceof DataBufferInt)) {
            return null;
        }
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        if (dataBufferInt.getNumBanks() != 1) {
            return null;
        }
        return dataBufferInt.getData();
    }

    private final void updateBufferedImage() {
        if (this.bimage != null && this.pixelConversionRequired) {
            int n = this.bimage.getHeight();
            int n2 = this.bimage.getWidth();
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                int n5 = 0;
                while (n5 < n2) {
                    this.bimage.setRGB(n5, n4, this.pixelBuffer[n3++]);
                    ++n5;
                }
                ++n4;
            }
        }
    }

    private final boolean drawImage(Image image, AffineTransform affineTransform, Color color, ImageObserver imageObserver) {
        if (image == null) {
            return false;
        }
        AffineTransform affineTransform2 = new AffineTransform();
        try {
            affineTransform2 = affineTransform.createInverse();
            if (image instanceof BufferedImage) {
                BufferedImage bufferedImage = (BufferedImage)image;
                return this.drawRaster(bufferedImage.getColorModel(), bufferedImage.getTile(0, 0), affineTransform2, color);
            }
            return this.drawImage((Image)GdkPixbufDecoder.createBufferedImage(image.getSource()), affineTransform, color, imageObserver);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new ImagingOpException("Unable to invert transform " + affineTransform.toString());
        }
    }

    public void draw(Shape shape) {
        if (this.stroke != null && !(this.stroke instanceof BasicStroke)) {
            this.fill(this.stroke.createStrokedShape(shape));
            return;
        }
        this.cairoNewPath();
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            this.cairoRectangle(this.shifted(rectangle2D.getX(), this.shiftDrawCalls), this.shifted(rectangle2D.getY(), this.shiftDrawCalls), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else {
            this.walkPath(shape.getPathIterator(null), this.shiftDrawCalls);
        }
        this.cairoStroke();
        this.updateBufferedImage();
    }

    public void fill(Shape shape) {
        this.cairoNewPath();
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            this.cairoRectangle(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else {
            this.walkPath(shape.getPathIterator(null), false);
        }
        this.cairoFill();
        this.updateBufferedImage();
    }

    public void clip(Shape shape) {
        Rectangle2D rectangle2D;
        if (this.clip == null || shape == null) {
            this.clip = shape;
        } else if (shape instanceof Rectangle2D && this.clip instanceof Rectangle2D) {
            rectangle2D = (Rectangle2D)shape;
            Rectangle2D rectangle2D2 = (Rectangle2D)this.clip;
            this.clip = rectangle2D2.createIntersection(rectangle2D);
        } else {
            throw new UnsupportedOperationException();
        }
        if (this.clip != null) {
            this.cairoNewPath();
            if (this.clip instanceof Rectangle2D) {
                rectangle2D = (Rectangle2D)this.clip;
                this.cairoRectangle(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            } else {
                this.walkPath(this.clip.getPathIterator(null), false);
            }
            this.cairoClip();
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    public void setPaint(Paint paint) {
        if (this.paint == null) {
            return;
        }
        this.paint = paint;
        if (this.paint instanceof Color) {
            this.setColor((Color)this.paint);
        } else if (this.paint instanceof TexturePaint) {
            TexturePaint texturePaint = (TexturePaint)this.paint;
            BufferedImage bufferedImage = texturePaint.getImage();
            int n = (int)texturePaint.getAnchorRect().getWidth();
            int n2 = (int)texturePaint.getAnchorRect().getHeight();
            double d = (double)n / (double)bufferedImage.getWidth();
            double d2 = (double)n / (double)bufferedImage.getHeight();
            AffineTransform affineTransform = new AffineTransform(d, 0.0, 0.0, d2, 0.0, 0.0);
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, this.getRenderingHints());
            BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
            int[] nArray = bufferedImage2.getRGB(0, 0, n, n2, null, 0, n);
            this.setTexturePixels(nArray, n, n2, n);
        } else if (this.paint instanceof GradientPaint) {
            GradientPaint gradientPaint = (GradientPaint)this.paint;
            Point2D point2D = gradientPaint.getPoint1();
            Point2D point2D2 = gradientPaint.getPoint2();
            Color color = gradientPaint.getColor1();
            Color color2 = gradientPaint.getColor2();
            this.setGradient(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), color2.getRed(), color2.getGreen(), color2.getBlue(), color2.getAlpha(), gradientPaint.isCyclic());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void setPaintUnlocked(Paint paint) {
        if (this.paint == null) {
            return;
        }
        this.paint = paint;
        if (this.paint instanceof Color) {
            this.setColorUnlocked((Color)this.paint);
        } else if (this.paint instanceof TexturePaint) {
            TexturePaint texturePaint = (TexturePaint)this.paint;
            BufferedImage bufferedImage = texturePaint.getImage();
            int n = (int)texturePaint.getAnchorRect().getWidth();
            int n2 = (int)texturePaint.getAnchorRect().getHeight();
            double d = (double)n / (double)bufferedImage.getWidth();
            double d2 = (double)n / (double)bufferedImage.getHeight();
            AffineTransform affineTransform = new AffineTransform(d, 0.0, 0.0, d2, 0.0, 0.0);
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, this.getRenderingHints());
            BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
            int[] nArray = bufferedImage2.getRGB(0, 0, n, n2, null, 0, n);
            this.setTexturePixelsUnlocked(nArray, n, n2, n);
        } else if (this.paint instanceof GradientPaint) {
            GradientPaint gradientPaint = (GradientPaint)this.paint;
            Point2D point2D = gradientPaint.getPoint1();
            Point2D point2D2 = gradientPaint.getPoint2();
            Color color = gradientPaint.getColor1();
            Color color2 = gradientPaint.getColor2();
            this.setGradientUnlocked(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), color2.getRed(), color2.getGreen(), color2.getBlue(), color2.getAlpha(), gradientPaint.isCyclic());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void setTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
        if (this.transform != null) {
            double[] dArray = new double[6];
            this.transform.getMatrix(dArray);
            this.cairoSetMatrix(dArray);
        }
    }

    public void setTransformUnlocked(AffineTransform affineTransform) {
        this.transform = affineTransform;
        if (this.transform != null) {
            double[] dArray = new double[6];
            this.transform.getMatrix(dArray);
            this.cairoSetMatrixUnlocked(dArray);
        }
    }

    public void transform(AffineTransform affineTransform) {
        if (this.transform == null) {
            this.transform = new AffineTransform(affineTransform);
        } else {
            this.transform.concatenate(affineTransform);
        }
        this.setTransform(this.transform);
        if (this.clip != null) {
            Rectangle2D rectangle2D = this.clip.getBounds2D();
            double[] dArray = new double[]{rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight()};
            try {
                affineTransform.createInverse().transform(dArray, 0, dArray, 0, 2);
                rectangle2D.setRect(dArray[0], dArray[1], dArray[2] - dArray[0], dArray[3] - dArray[1]);
                this.clip = rectangle2D;
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {}
        }
    }

    public void rotate(double d) {
        this.transform(AffineTransform.getRotateInstance(d));
    }

    public void rotate(double d, double d2, double d3) {
        this.transform(AffineTransform.getRotateInstance(d, d2, d3));
    }

    public void scale(double d, double d2) {
        this.transform(AffineTransform.getScaleInstance(d, d2));
    }

    public void translate(double d, double d2) {
        this.transform(AffineTransform.getTranslateInstance(d, d2));
    }

    public void translate(int n, int n2) {
        this.translate((double)n, (double)n2);
    }

    public void shear(double d, double d2) {
        this.transform(AffineTransform.getShearInstance(d, d2));
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        if (this.stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)this.stroke;
            this.cairoSetLineCap(basicStroke.getEndCap());
            this.cairoSetLineWidth(basicStroke.getLineWidth());
            this.cairoSetLineJoin(basicStroke.getLineJoin());
            this.cairoSetMiterLimit(basicStroke.getMiterLimit());
            float[] fArray = basicStroke.getDashArray();
            if (fArray != null) {
                double[] dArray = new double[fArray.length];
                int n = 0;
                while (n < fArray.length) {
                    dArray[n] = fArray[n];
                    ++n;
                }
                this.cairoSetDash(dArray, dArray.length, basicStroke.getDashPhase());
            } else {
                this.cairoSetDash(new double[0], 0, 0.0);
            }
        }
    }

    public void setStrokeUnlocked(Stroke stroke) {
        this.stroke = stroke;
        if (this.stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)this.stroke;
            this.cairoSetLineCapUnlocked(basicStroke.getEndCap());
            this.cairoSetLineWidthUnlocked(basicStroke.getLineWidth());
            this.cairoSetLineJoinUnlocked(basicStroke.getLineJoin());
            this.cairoSetMiterLimitUnlocked(basicStroke.getMiterLimit());
            float[] fArray = basicStroke.getDashArray();
            if (fArray != null) {
                double[] dArray = new double[fArray.length];
                int n = 0;
                while (n < fArray.length) {
                    dArray[n] = fArray[n];
                    ++n;
                }
                this.cairoSetDashUnlocked(dArray, dArray.length, basicStroke.getDashPhase());
            } else {
                this.cairoSetDashUnlocked(new double[0], 0, 0.0);
            }
        }
    }

    public void setPaintMode() {
        this.setComposite(AlphaComposite.SrcOver);
    }

    public void setXORMode(Color color) {
        this.setComposite(new BitwiseXORComposite(color));
    }

    public void setColor(Color color) {
        if (color == null) {
            color = Color.BLACK;
        }
        this.fg = color;
        this.paint = color;
        this.cairoSetRGBAColor((double)this.fg.getRed() / 255.0, (double)this.fg.getGreen() / 255.0, (double)this.fg.getBlue() / 255.0, (double)this.fg.getAlpha() / 255.0);
    }

    public void setColorUnlocked(Color color) {
        if (color == null) {
            color = Color.BLACK;
        }
        this.fg = color;
        this.paint = color;
        this.cairoSetRGBAColorUnlocked((double)this.fg.getRed() / 255.0, (double)this.fg.getGreen() / 255.0, (double)this.fg.getBlue() / 255.0, (double)this.fg.getAlpha() / 255.0);
    }

    public Color getColor() {
        return this.fg;
    }

    public Color getColorUnlocked() {
        return this.getColor();
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clip(new Rectangle(n, n2, n3, n4));
    }

    public Shape getClip() {
        if (this.clip == null) {
            return null;
        }
        return this.clip.getBounds2D();
    }

    public Rectangle getClipBounds() {
        if (this.clip == null) {
            return null;
        }
        return this.clip.getBounds();
    }

    protected Rectangle2D getClipInDevSpace() {
        Rectangle2D rectangle2D = this.clip.getBounds2D();
        if (this.transform == null) {
            return rectangle2D;
        }
        Point2D point2D = this.transform.transform(new Point2D.Double(rectangle2D.getX(), rectangle2D.getY()), null);
        Point2D point2D2 = this.transform.deltaTransform(new Point2D.Double(rectangle2D.getWidth(), rectangle2D.getHeight()), null);
        return new Rectangle2D.Double(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle2D.Double(n, n2, n3, n4));
    }

    public void setClip(Shape shape) {
        this.clip = shape;
        if (this.clip == null) {
            if (this.component != null) {
                Dimension dimension = this.component.awtComponent.getSize();
                this.setClip(0, 0, dimension.width, dimension.height);
            }
        } else {
            this.cairoNewPath();
            if (shape instanceof Rectangle2D) {
                Rectangle2D rectangle2D = (Rectangle2D)shape;
                this.cairoRectangle(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            } else {
                this.walkPath(shape.getPathIterator(null), false);
            }
            this.cairoClip();
        }
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Stroke stroke = this.stroke;
        this.setStroke(draw3DRectStroke);
        super.draw3DRect(n, n2, n3, n4, bl);
        this.setStroke(stroke);
        this.updateBufferedImage();
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Stroke stroke = this.stroke;
        this.setStroke(draw3DRectStroke);
        super.fill3DRect(n, n2, n3, n4, bl);
        this.setStroke(stroke);
        this.updateBufferedImage();
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.draw(new Rectangle(n, n2, n3, n4));
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.cairoNewPath();
        this.cairoRectangle(n, n2, n3, n4);
        this.cairoFill();
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        if (this.bg != null) {
            this.cairoSetRGBAColor((double)this.bg.getRed() / 255.0, (double)this.bg.getGreen() / 255.0, (double)this.bg.getBlue() / 255.0, 1.0);
        }
        this.cairoNewPath();
        this.cairoRectangle(n, n2, n3, n4);
        this.cairoFill();
        this.setColor(this.fg);
        this.updateBufferedImage();
    }

    public void setBackground(Color color) {
        if (color == null) {
            color = Color.WHITE;
        }
        this.bg = color;
    }

    public void setBackgroundUnlocked(Color color) {
        this.setBackground(color);
    }

    public Color getBackground() {
        return this.bg;
    }

    private final void doPolygon(int[] nArray, int[] nArray2, int n, boolean bl, boolean bl2) {
        if (n < 1) {
            return;
        }
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.moveTo(nArray[0], nArray2[0]);
        int n2 = 1;
        while (n2 < n) {
            generalPath.lineTo(nArray[n2], nArray2[n2]);
            ++n2;
        }
        if (bl) {
            generalPath.closePath();
        }
        Shape shape = generalPath;
        if (!bl2 && this.stroke != null && !(this.stroke instanceof BasicStroke)) {
            shape = this.stroke.createStrokedShape(generalPath);
            bl2 = true;
        }
        if (bl2) {
            this.fill(shape);
        } else {
            this.draw(shape);
        }
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        nArray[0] = n;
        nArray[1] = n3;
        nArray2[0] = n2;
        nArray2[1] = n4;
        this.doPolygon(nArray, nArray2, 2, false, false);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.doPolygon(nArray, nArray2, n, true, true);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.doPolygon(nArray, nArray2, n, true, false);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.doPolygon(nArray, nArray2, n, false, false);
    }

    private final boolean drawRaster(ColorModel colorModel, Raster raster, AffineTransform affineTransform, Color color) {
        int n;
        if (raster == null) {
            return false;
        }
        SampleModel sampleModel = raster.getSampleModel();
        DataBuffer dataBuffer = raster.getDataBuffer();
        if (dataBuffer == null || sampleModel == null) {
            return false;
        }
        if (colorModel == null) {
            colorModel = ColorModel.getRGBdefault();
        }
        double[] dArray = new double[6];
        if (affineTransform != null) {
            affineTransform.getMatrix(dArray);
        } else {
            dArray[0] = 1.0;
            dArray[1] = 0.0;
            dArray[2] = 0.0;
            dArray[3] = 1.0;
            dArray[4] = 0.0;
            dArray[5] = 0.0;
        }
        int[] nArray = GdkGraphics2D.findSimpleIntegerArray(colorModel, raster);
        if (nArray == null) {
            if (sampleModel instanceof MultiPixelPackedSampleModel) {
                nArray = raster.getPixels(0, 0, raster.getWidth(), raster.getHeight(), nArray);
                n = 0;
                while (n < nArray.length) {
                    nArray[n] = colorModel.getRGB(nArray[n]);
                    ++n;
                }
            } else {
                nArray = new int[raster.getWidth() * raster.getHeight()];
                n = 0;
                while (n < nArray.length) {
                    nArray[n] = colorModel.getRGB(dataBuffer.getElem(n));
                    ++n;
                }
            }
        }
        if (colorModel.hasAlpha()) {
            if (color != null && colorModel.hasAlpha()) {
                n = 0;
                while (n < nArray.length) {
                    if (colorModel.getAlpha(nArray[n]) == 0) {
                        nArray[n] = color.getRGB();
                    }
                    ++n;
                }
            }
        } else {
            n = 0;
            while (n < nArray.length) {
                int n2 = n++;
                nArray[n2] = nArray[n2] | 0xFF000000;
            }
        }
        this.drawPixels(nArray, raster.getWidth(), raster.getHeight(), raster.getWidth(), dArray);
        this.updateBufferedImage();
        return true;
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.drawRaster(renderedImage.getColorModel(), renderedImage.getData(), affineTransform, this.bg);
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.drawRenderedImage(renderableImage.createRendering(new RenderContext(affineTransform)), affineTransform);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return this.drawImage(image, affineTransform, this.bg, imageObserver);
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        BufferedImage bufferedImage2 = bufferedImageOp.filter(bufferedImage, null);
        this.drawImage((Image)bufferedImage2, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, n, n2), this.bg, null);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, n, n2), this.bg, imageObserver);
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        throw new UnsupportedOperationException();
    }

    public void setComposite(Composite composite) {
        this.comp = composite;
        if (!(composite instanceof AlphaComposite)) {
            throw new UnsupportedOperationException();
        }
        AlphaComposite alphaComposite = (AlphaComposite)composite;
        this.cairoSetOperator(alphaComposite.getRule());
        Color color = this.getColor();
        this.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(alphaComposite.getAlpha() * (float)color.getAlpha())));
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.hints.put(key, object);
        if (key.equals(RenderingHints.KEY_INTERPOLATION) || key.equals(RenderingHints.KEY_ALPHA_INTERPOLATION)) {
            if (object.equals(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR)) {
                this.cairoSurfaceSetFilter(0);
            } else if (object.equals(RenderingHints.VALUE_INTERPOLATION_BILINEAR)) {
                this.cairoSurfaceSetFilter(1);
            } else if (object.equals(RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED)) {
                this.cairoSurfaceSetFilter(2);
            } else if (object.equals(RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY)) {
                this.cairoSurfaceSetFilter(3);
            } else if (object.equals(RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT)) {
                this.cairoSurfaceSetFilter(4);
            }
        }
        boolean bl = false;
        if (this.hints.containsValue(RenderingHints.VALUE_STROKE_NORMALIZE) || this.hints.containsValue(RenderingHints.VALUE_STROKE_DEFAULT)) {
            bl = true;
        }
        this.shiftDrawCalls = bl;
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.hints.get(key);
    }

    public void setRenderingHints(Map map) {
        this.hints = new RenderingHints(this.getDefaultHints());
        this.hints.add(new RenderingHints(map));
        if (map.containsKey(RenderingHints.KEY_INTERPOLATION)) {
            if (map.containsValue(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR)) {
                this.cairoSurfaceSetFilter(0);
            } else if (map.containsValue(RenderingHints.VALUE_INTERPOLATION_BILINEAR)) {
                this.cairoSurfaceSetFilter(1);
            }
        }
        if (map.containsKey(RenderingHints.KEY_ALPHA_INTERPOLATION)) {
            if (map.containsValue(RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED)) {
                this.cairoSurfaceSetFilter(2);
            } else if (map.containsValue(RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY)) {
                this.cairoSurfaceSetFilter(3);
            } else if (map.containsValue(RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT)) {
                this.cairoSurfaceSetFilter(4);
            }
        }
        boolean bl = false;
        if (map.containsValue(RenderingHints.VALUE_STROKE_NORMALIZE) || map.containsValue(RenderingHints.VALUE_STROKE_DEFAULT)) {
            bl = true;
        }
        this.shiftDrawCalls = bl;
    }

    public void setRenderingHintsUnlocked(Map map) {
        this.hints = new RenderingHints(this.getDefaultHints());
        this.hints.add(new RenderingHints(map));
        if (map.containsKey(RenderingHints.KEY_INTERPOLATION)) {
            if (map.containsValue(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR)) {
                this.cairoSurfaceSetFilterUnlocked(0);
            } else if (map.containsValue(RenderingHints.VALUE_INTERPOLATION_BILINEAR)) {
                this.cairoSurfaceSetFilterUnlocked(1);
            }
        }
        if (map.containsKey(RenderingHints.KEY_ALPHA_INTERPOLATION)) {
            if (map.containsValue(RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED)) {
                this.cairoSurfaceSetFilterUnlocked(2);
            } else if (map.containsValue(RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY)) {
                this.cairoSurfaceSetFilterUnlocked(3);
            } else if (map.containsValue(RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT)) {
                this.cairoSurfaceSetFilterUnlocked(4);
            }
        }
        boolean bl = false;
        if (map.containsValue(RenderingHints.VALUE_STROKE_NORMALIZE) || map.containsValue(RenderingHints.VALUE_STROKE_DEFAULT)) {
            bl = true;
        }
        this.shiftDrawCalls = bl;
    }

    public void addRenderingHints(Map map) {
        this.hints.add(new RenderingHints(map));
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public Composite getComposite() {
        if (this.comp == null) {
            return AlphaComposite.SrcOver;
        }
        return this.comp;
    }

    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(this.transform, true, true);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        GdkGraphics2D gdkGraphics2D = (GdkGraphics2D)this.create(n, n2, n3, n4);
        this.gdkDrawDrawable(gdkGraphics2D, n + n5, n2 + n6);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new Arc2D.Double(n, n2, n3, n4, n5, n6, 0));
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        double d = (double)n3 / (double)image.getWidth(imageObserver);
        double d2 = (double)n4 / (double)image.getHeight(imageObserver);
        return this.drawImage(image, new AffineTransform(d, 0.0, 0.0, d2, (double)n, (double)n2), color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, this.bg, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        Image image2;
        if (image == null) {
            return false;
        }
        int n9 = n7 - n5;
        int n10 = n8 - n6;
        int n11 = n3 - n;
        int n12 = n4 - n2;
        double d = (double)n11 / (double)n9;
        double d2 = (double)n12 / (double)n10;
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            image2 = bufferedImage.getSubimage(n5, n6, n7, n8);
        } else {
            CropImageFilter cropImageFilter = new CropImageFilter(n5, n7, n7, n8);
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), cropImageFilter);
            image2 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        }
        return this.drawImage(image2, new AffineTransform(d, 0.0, 0.0, d2, (double)n, (double)n2), color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, this.bg, imageObserver);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.drawArc(n, n2, n3, n4, 0, 360);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 > n3) {
            n5 = n3;
        }
        if (n6 > n4) {
            n6 = n4;
        }
        int n7 = n + n3 - n5;
        int n8 = n2 + n4 - n6;
        this.drawArc(n, n2, n5, n6, 90, 90);
        this.drawArc(n7, n2, n5, n6, 0, 90);
        this.drawArc(n7, n8, n5, n6, 270, 90);
        this.drawArc(n, n8, n5, n6, 180, 90);
        int n9 = n2 + n6 / 2;
        int n10 = n2 + n4 - n6 / 2;
        this.drawLine(n, n9, n, n10);
        this.drawLine(n + n3, n9, n + n3, n10);
        int n11 = n + n5 / 2;
        int n12 = n + n3 - n5 / 2;
        this.drawLine(n11, n2, n12, n2);
        this.drawLine(n11, n2 + n4, n12, n2 + n4);
    }

    native void cairoDrawGlyphVector(GdkFontPeer var1, float var2, float var3, int var4, int[] var5, float[] var6);

    native void cairoDrawGdkTextLayout(GdkTextLayout var1, float var2, float var3);

    GdkFontPeer getFontPeer() {
        return (GdkFontPeer)this.getFont().getPeer();
    }

    public void drawGdkTextLayout(GdkTextLayout gdkTextLayout, float f, float f2) {
        this.cairoDrawGdkTextLayout(gdkTextLayout, f, f2);
        this.updateBufferedImage();
    }

    public void drawString(String string, float f, float f2) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.drawGlyphVector(this.getFont().createGlyphVector(null, string), f, f2);
        this.updateBufferedImage();
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.drawString(attributedCharacterIterator, (float)n, (float)n2);
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        int n = glyphVector.getNumGlyphs();
        int[] nArray = glyphVector.getGlyphCodes(0, n, null);
        float[] fArray = glyphVector.getGlyphPositions(0, n, null);
        this.setFont(glyphVector.getFont());
        this.cairoDrawGlyphVector(this.getFontPeer(), f, f2, n, nArray, fArray);
        this.updateBufferedImage();
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        GlyphVector glyphVector = this.getFont().createGlyphVector(this.getFontRenderContext(), attributedCharacterIterator);
        this.drawGlyphVector(glyphVector, f, f2);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new Arc2D.Double(n, n2, n3, n4, n5, n6, 0));
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.fillArc(n, n2, n3, n4, 0, 360);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 > n3) {
            n5 = n3;
        }
        if (n6 > n4) {
            n6 = n4;
        }
        int n7 = n + n3 - n5;
        int n8 = n2 + n4 - n6;
        this.fillArc(n, n2, n5, n6, 90, 90);
        this.fillArc(n7, n2, n5, n6, 0, 90);
        this.fillArc(n7, n8, n5, n6, 270, 90);
        this.fillArc(n, n8, n5, n6, 180, 90);
        this.fillRect(n, n2 + n6 / 2, n3, n4 - n6 + 1);
        this.fillRect(n + n5 / 2, n2, n3 - n5 + 1, n4);
    }

    public Font getFont() {
        if (this.font == null) {
            return new Font("SansSerif", 0, 12);
        }
        return this.font;
    }

    static native void releasePeerGraphicsResource(GdkFontPeer var0);

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        this.font = font.getPeer() instanceof GdkFontPeer ? font : ((ClasspathToolkit)Toolkit.getDefaultToolkit()).getFont(font.getName(), font.getAttributes());
    }

    public void setFontUnlocked(Font font) {
        this.setFont(font);
    }

    public String toString() {
        return this.getClass().getName() + "[font=" + this.getFont().toString() + ",color=" + this.fg.toString() + ']';
    }

    private final /* synthetic */ void this() {
        this.native_state = GtkGenericPeer.getUniqueInteger();
        this.shiftDrawCalls = false;
    }

    GdkGraphics2D(GdkGraphics2D gdkGraphics2D) {
        this.this();
        if (!GtkToolkit.useGraphics2D()) {
            this.fail_g2d();
        }
        this.paint = gdkGraphics2D.paint;
        this.stroke = gdkGraphics2D.stroke;
        this.setRenderingHints(gdkGraphics2D.hints);
        this.fg = gdkGraphics2D.fg.getAlpha() != -1 ? new Color(gdkGraphics2D.fg.getRed(), gdkGraphics2D.fg.getGreen(), gdkGraphics2D.fg.getBlue(), gdkGraphics2D.fg.getAlpha()) : new Color(gdkGraphics2D.fg.getRGB());
        if (gdkGraphics2D.bg != null) {
            this.bg = gdkGraphics2D.bg.getAlpha() != -1 ? new Color(gdkGraphics2D.bg.getRed(), gdkGraphics2D.bg.getGreen(), gdkGraphics2D.bg.getBlue(), gdkGraphics2D.bg.getAlpha()) : new Color(gdkGraphics2D.bg.getRGB());
        }
        this.clip = gdkGraphics2D.clip == null ? null : new Rectangle(gdkGraphics2D.getClipBounds());
        this.transform = gdkGraphics2D.transform == null ? new AffineTransform() : new AffineTransform(gdkGraphics2D.transform);
        this.font = gdkGraphics2D.font;
        this.component = gdkGraphics2D.component;
        this.copyState(gdkGraphics2D);
        this.setColor(this.fg);
        this.setBackground(this.bg);
        this.setPaint(this.paint);
        this.setStroke(this.stroke);
        this.setTransform(this.transform);
        this.setClip(this.clip);
        this.stateStack = new Stack();
    }

    GdkGraphics2D(GdkGraphics2D gdkGraphics2D, int n, int n2, int n3, int n4) {
        this(gdkGraphics2D);
        this.translate(n, n2);
        this.clipRect(0, 0, n3, n4);
    }

    GdkGraphics2D(int n, int n2) {
        this.this();
        if (!GtkToolkit.useGraphics2D()) {
            this.fail_g2d();
        }
        this.initState(n, n2);
        this.setColor(Color.black);
        this.setBackground(new Color(0, 0, 0, 0));
        this.setPaint(this.getColor());
        this.setFont(new Font("SansSerif", 0, 12));
        this.setTransform(new AffineTransform());
        this.setStroke(new BasicStroke());
        this.setRenderingHints(this.getDefaultHints());
        this.stateStack = new Stack();
    }

    GdkGraphics2D(GtkComponentPeer gtkComponentPeer) {
        this.this();
        if (!GtkToolkit.useGraphics2D()) {
            this.fail_g2d();
        }
        this.component = gtkComponentPeer;
        if (gtkComponentPeer.isRealized()) {
            this.initComponentGraphics2D();
        } else {
            this.connectSignals(gtkComponentPeer);
        }
    }

    GdkGraphics2D(BufferedImage bufferedImage) {
        this.this();
        this.bimage = bufferedImage;
        this.pixelBuffer = GdkGraphics2D.findSimpleIntegerArray(bufferedImage.getColorModel(), bufferedImage.getRaster());
        if (this.pixelBuffer == null) {
            this.pixelBuffer = new int[bufferedImage.getRaster().getWidth() * bufferedImage.getRaster().getHeight()];
            this.pixelConversionRequired = true;
        } else {
            this.pixelConversionRequired = false;
        }
        this.initState(this.pixelBuffer, bufferedImage.getWidth(), bufferedImage.getHeight());
        this.setColor(Color.black);
        this.setBackground(new Color(0, 0, 0, 0));
        this.setPaint(this.getColor());
        this.setFont(new Font("SansSerif", 0, 12));
        this.setTransform(new AffineTransform());
        this.setStroke(new BasicStroke());
        this.setRenderingHints(this.getDefaultHints());
        this.stateStack = new Stack();
        if (this.pixelConversionRequired) {
            this.drawImage((Image)bufferedImage, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), this.bg, null);
        }
    }

    static {
        throw new Error("Graphics2D not implemented. Cairo was not found or disabled at configure time");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class DrawState {
        private Paint paint;
        private Stroke stroke;
        private Color fg;
        private Color bg;
        private Shape clip;
        private AffineTransform transform;
        private Font font;
        private Composite comp;

        public void restore(GdkGraphics2D gdkGraphics2D) {
            gdkGraphics2D.paint = this.paint;
            gdkGraphics2D.stroke = this.stroke;
            gdkGraphics2D.fg = this.fg;
            gdkGraphics2D.bg = this.bg;
            gdkGraphics2D.clip = this.clip;
            gdkGraphics2D.transform = this.transform;
            gdkGraphics2D.font = this.font;
            gdkGraphics2D.comp = this.comp;
        }

        DrawState(GdkGraphics2D gdkGraphics2D2) {
            this.paint = gdkGraphics2D2.paint;
            this.stroke = gdkGraphics2D2.stroke;
            this.fg = gdkGraphics2D2.fg;
            this.bg = gdkGraphics2D2.bg;
            this.clip = gdkGraphics2D2.clip;
            if (gdkGraphics2D2.transform != null) {
                this.transform = (AffineTransform)gdkGraphics2D2.transform.clone();
            }
            this.font = gdkGraphics2D2.font;
            this.comp = gdkGraphics2D2.comp;
        }
    }
}

