/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.NoSuchElementException;

public abstract class QuadCurve2D
implements Shape,
Cloneable {
    private static final double BIG_VALUE = 1.7976931348623158E307;
    private static final double EPSILON = 1.0E-10;

    public abstract double getX1();

    public abstract double getY1();

    public abstract Point2D getP1();

    public abstract double getCtrlX();

    public abstract double getCtrlY();

    public abstract Point2D getCtrlPt();

    public abstract double getX2();

    public abstract double getY2();

    public abstract Point2D getP2();

    public abstract void setCurve(double var1, double var3, double var5, double var7, double var9, double var11);

    public void setCurve(double[] dArray, int n) {
        this.setCurve(dArray[n++], dArray[n++], dArray[n++], dArray[n++], dArray[n++], dArray[n++]);
    }

    public void setCurve(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        this.setCurve(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY());
    }

    public void setCurve(Point2D[] point2DArray, int n) {
        this.setCurve(point2DArray[n].getX(), point2DArray[n].getY(), point2DArray[n + 1].getX(), point2DArray[n + 1].getY(), point2DArray[n + 2].getX(), point2DArray[n + 2].getY());
    }

    public void setCurve(QuadCurve2D quadCurve2D) {
        this.setCurve(quadCurve2D.getX1(), quadCurve2D.getY1(), quadCurve2D.getCtrlX(), quadCurve2D.getCtrlY(), quadCurve2D.getX2(), quadCurve2D.getY2());
    }

    public static double getFlatnessSq(double d, double d2, double d3, double d4, double d5, double d6) {
        return Line2D.ptSegDistSq(d, d2, d5, d6, d3, d4);
    }

    public static double getFlatness(double d, double d2, double d3, double d4, double d5, double d6) {
        return Line2D.ptSegDist(d, d2, d5, d6, d3, d4);
    }

    public static double getFlatnessSq(double[] dArray, int n) {
        return Line2D.ptSegDistSq(dArray[n], dArray[n + 1], dArray[n + 4], dArray[n + 5], dArray[n + 2], dArray[n + 3]);
    }

    public static double getFlatness(double[] dArray, int n) {
        return Line2D.ptSegDist(dArray[n], dArray[n + 1], dArray[n + 4], dArray[n + 5], dArray[n + 2], dArray[n + 3]);
    }

    public double getFlatnessSq() {
        return Line2D.ptSegDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), this.getCtrlX(), this.getCtrlY());
    }

    public double getFlatness() {
        return Line2D.ptSegDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), this.getCtrlX(), this.getCtrlY());
    }

    public void subdivide(QuadCurve2D quadCurve2D, QuadCurve2D quadCurve2D2) {
        double[] dArray = new double[10];
        dArray[0] = this.getX1();
        dArray[1] = this.getY1();
        dArray[2] = this.getCtrlX();
        dArray[3] = this.getCtrlY();
        dArray[4] = this.getX2();
        dArray[5] = this.getY2();
        double[] dArray2 = dArray;
        QuadCurve2D.subdivide(dArray2, 0, dArray2, 0, dArray2, 4);
        if (quadCurve2D != null) {
            quadCurve2D.setCurve(dArray2, 0);
        }
        if (quadCurve2D2 != null) {
            quadCurve2D2.setCurve(dArray2, 4);
        }
    }

    public static void subdivide(QuadCurve2D quadCurve2D, QuadCurve2D quadCurve2D2, QuadCurve2D quadCurve2D3) {
        quadCurve2D.subdivide(quadCurve2D2, quadCurve2D3);
    }

    public static void subdivide(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = dArray[n + 2];
        double d4 = dArray[n + 3];
        double d5 = dArray[n + 4];
        double d6 = dArray[n + 5];
        if (dArray2 != null) {
            dArray2[n2] = d;
            dArray2[n2 + 1] = d2;
        }
        if (dArray3 != null) {
            dArray3[n3 + 4] = d5;
            dArray3[n3 + 5] = d6;
        }
        d = (d + d3) / (double)2;
        d5 = (d3 + d5) / (double)2;
        d3 = (d + d5) / (double)2;
        d2 = (d2 + d4) / (double)2;
        d6 = (d6 + d4) / (double)2;
        d4 = (d2 + d6) / (double)2;
        if (dArray2 != null) {
            dArray2[n2 + 2] = d;
            dArray2[n2 + 3] = d2;
            dArray2[n2 + 4] = d3;
            dArray2[n2 + 5] = d4;
        }
        if (dArray3 != null) {
            dArray3[n3] = d3;
            dArray3[n3 + 1] = d4;
            dArray3[n3 + 2] = d5;
            dArray3[n3 + 3] = d6;
        }
    }

    public static int solveQuadratic(double[] dArray) {
        return QuadCurve2D.solveQuadratic(dArray, dArray);
    }

    public static int solveQuadratic(double[] dArray, double[] dArray2) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        if (d3 == 0.0) {
            if (d2 == 0.0) {
                return -1;
            }
            dArray2[0] = -d / d2;
            return 1;
        }
        double d4 = d2 * d2 - (double)4 * d3 * d;
        if (d4 < 0.0) {
            return 0;
        }
        if (d4 == 0.0) {
            dArray2[0] = -0.5 * d2 / d3;
            return 1;
        }
        if (d2 == 0.0) {
            double d5 = Math.abs(0.5 * Math.sqrt(d4) / d3);
            dArray2[0] = -d5;
            dArray2[1] = d5;
        } else {
            double d6 = d2 > 0.0 ? 1 : -1;
            double d7 = -0.5 * (d2 + d6 * Math.sqrt(d4));
            dArray2[0] = d7 / d3;
            dArray2[1] = d / d7;
        }
        return 2;
    }

    public boolean contains(double d, double d2) {
        if (!this.getBounds2D().contains(d, d2)) {
            return false;
        }
        boolean bl = false;
        if ((this.getAxisIntersections(d, d2, true, 1.7976931348623158E307) & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        if (!this.getBounds2D().contains(d, d2, d3, d4)) {
            return false;
        }
        if (this.getAxisIntersections(d, d2, true, d3) != 0 || this.getAxisIntersections(d, d2 + d4, true, d3) != 0 || this.getAxisIntersections(d + d3, d2, false, d4) != 0 || this.getAxisIntersections(d, d2, false, d4) != 0) {
            return true;
        }
        return (this.getAxisIntersections(d, d2, true, 1.7976931348623158E307) & 1) != 0;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        if (!this.getBounds2D().intersects(d, d2, d3, d4)) {
            return false;
        }
        if (this.getAxisIntersections(d, d2, true, d3) != 0 || this.getAxisIntersections(d, d2 + d4, true, d3) != 0 || this.getAxisIntersections(d + d3, d2, false, d4) != 0 || this.getAxisIntersections(d, d2, false, d4) != 0) {
            return false;
        }
        return (this.getAxisIntersections(d, d2, true, 1.7976931348623158E307) & 1) != 0;
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public PathIterator getPathIterator(final AffineTransform affineTransform) {
        return new PathIterator(){
            private int current;

            public final int getWindingRule() {
                return 1;
            }

            public final boolean isDone() {
                boolean bl = false;
                if (this.current >= 2) {
                    bl = true;
                }
                return bl;
            }

            public final void next() {
                ++this.current;
            }

            public final int currentSegment(float[] fArray) {
                int n;
                switch (this.current) {
                    case 0: {
                        fArray[0] = (float)QuadCurve2D.this.getX1();
                        fArray[1] = (float)QuadCurve2D.this.getY1();
                        n = 0;
                        break;
                    }
                    case 1: {
                        fArray[0] = (float)QuadCurve2D.this.getCtrlX();
                        fArray[1] = (float)QuadCurve2D.this.getCtrlY();
                        fArray[2] = (float)QuadCurve2D.this.getX2();
                        fArray[3] = (float)QuadCurve2D.this.getY2();
                        n = 2;
                        break;
                    }
                    default: {
                        throw new NoSuchElementException("quad iterator out of bounds");
                    }
                }
                if (affineTransform != null) {
                    affineTransform.transform(fArray, 0, fArray, 0, 2);
                }
                return n;
            }

            public final int currentSegment(double[] dArray) {
                int n;
                switch (this.current) {
                    case 0: {
                        dArray[0] = QuadCurve2D.this.getX1();
                        dArray[1] = QuadCurve2D.this.getY1();
                        n = 0;
                        break;
                    }
                    case 1: {
                        dArray[0] = QuadCurve2D.this.getCtrlX();
                        dArray[1] = QuadCurve2D.this.getCtrlY();
                        dArray[2] = QuadCurve2D.this.getX2();
                        dArray[3] = QuadCurve2D.this.getY2();
                        n = 2;
                        break;
                    }
                    default: {
                        throw new NoSuchElementException("quad iterator out of bounds");
                    }
                }
                if (affineTransform != null) {
                    affineTransform.transform(dArray, 0, dArray, 0, 2);
                }
                return n;
            }

            private final /* synthetic */ void this() {
                this.current = 0;
            }
            {
                this.this();
            }
        };
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new FlatteningPathIterator(this.getPathIterator(affineTransform), d);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Error)new InternalError().initCause(cloneNotSupportedException);
        }
    }

    private final int getAxisIntersections(double d, double d2, boolean bl, double d3) {
        double d4;
        double d5;
        double d6;
        double d7;
        int n = 0;
        double[] dArray = new double[3];
        double d8 = 0.0;
        double d9 = 0.0;
        if (bl) {
            d9 = this.getY1() - d2;
            d7 = this.getCtrlY() - d2;
            d8 = this.getY2() - d2;
            d6 = this.getX1() - d;
            d5 = this.getCtrlX() - d;
            d4 = this.getX2() - d;
        } else {
            d9 = this.getX1() - d;
            d7 = this.getCtrlX() - d;
            d8 = this.getX2() - d;
            d6 = this.getY1() - d2;
            d5 = this.getCtrlY() - d2;
            d4 = this.getY2() - d2;
        }
        if (d9 == 0.0 || d8 == 0.0) {
            double d10 = this.getFlatness() * 1.0E-10;
            if (d9 == 0.0) {
                d9 -= d10;
            }
            if (d8 == 0.0) {
                d8 -= d10;
            }
        }
        dArray[0] = d9;
        dArray[1] = (double)2 * (d7 - d9);
        dArray[2] = d8 - (double)2 * d7 + d9;
        int n2 = QuadCurve2D.solveQuadratic(dArray);
        int n3 = 0;
        while (n3 < n2) {
            double d11;
            double d12 = dArray[n3];
            if (d12 >= 0.0 && d12 <= 1.0 && (d11 = d12 * d12 * (d4 - (double)2 * d5 + d6) + (double)2 * d12 * (d5 - d6) + d6) > 0.0 && d11 < d3) {
                int n4 = 0;
                if (n2 == 1) {
                    n4 = 1;
                }
                n += n4 + 1;
            }
            ++n3;
        }
        if (bl) {
            if (Line2D.linesIntersect(d6, d9, d4, d8, 1.0E-10, 0.0, d3, 0.0)) {
                ++n;
            }
        } else if (Line2D.linesIntersect(d9, d6, d8, d4, 0.0, 1.0E-10, 0.0, d3)) {
            ++n;
        }
        return n;
    }

    protected QuadCurve2D() {
    }

    public static class Float
    extends QuadCurve2D {
        public float x1;
        public float y1;
        public float ctrlx;
        public float ctrly;
        public float x2;
        public float y2;

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public Point2D getP1() {
            return new Point2D.Float(this.x1, this.y1);
        }

        public double getCtrlX() {
            return this.ctrlx;
        }

        public double getCtrlY() {
            return this.ctrly;
        }

        public Point2D getCtrlPt() {
            return new Point2D.Float(this.ctrlx, this.ctrly);
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public Point2D getP2() {
            return new Point2D.Float(this.x2, this.y2);
        }

        public void setCurve(double d, double d2, double d3, double d4, double d5, double d6) {
            this.x1 = (float)d;
            this.y1 = (float)d2;
            this.ctrlx = (float)d3;
            this.ctrly = (float)d4;
            this.x2 = (float)d5;
            this.y2 = (float)d6;
        }

        public void setCurve(float f, float f2, float f3, float f4, float f5, float f6) {
            this.x1 = f;
            this.y1 = f2;
            this.ctrlx = f3;
            this.ctrly = f4;
            this.x2 = f5;
            this.y2 = f6;
        }

        public Rectangle2D getBounds2D() {
            float f = Math.min(Math.min(this.x1, this.ctrlx), this.x2);
            float f2 = Math.min(Math.min(this.y1, this.ctrly), this.y2);
            float f3 = Math.max(Math.max(this.x1, this.ctrlx), this.x2);
            float f4 = Math.max(Math.max(this.y1, this.ctrly), this.y2);
            return new Rectangle2D.Float(f, f2, f3 - f, f4 - f2);
        }

        public Float() {
        }

        public Float(float f, float f2, float f3, float f4, float f5, float f6) {
            this.x1 = f;
            this.y1 = f2;
            this.ctrlx = f3;
            this.ctrly = f4;
            this.x2 = f5;
            this.y2 = f6;
        }
    }

    public static class Double
    extends QuadCurve2D {
        public double x1;
        public double y1;
        public double ctrlx;
        public double ctrly;
        public double x2;
        public double y2;

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public Point2D getP1() {
            return new Point2D.Double(this.x1, this.y1);
        }

        public double getCtrlX() {
            return this.ctrlx;
        }

        public double getCtrlY() {
            return this.ctrly;
        }

        public Point2D getCtrlPt() {
            return new Point2D.Double(this.ctrlx, this.ctrly);
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public Point2D getP2() {
            return new Point2D.Double(this.x2, this.y2);
        }

        public void setCurve(double d, double d2, double d3, double d4, double d5, double d6) {
            this.x1 = d;
            this.y1 = d2;
            this.ctrlx = d3;
            this.ctrly = d4;
            this.x2 = d5;
            this.y2 = d6;
        }

        public Rectangle2D getBounds2D() {
            double d = Math.min(Math.min(this.x1, this.ctrlx), this.x2);
            double d2 = Math.min(Math.min(this.y1, this.ctrly), this.y2);
            double d3 = Math.max(Math.max(this.x1, this.ctrlx), this.x2);
            double d4 = Math.max(Math.max(this.y1, this.ctrly), this.y2);
            return new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
        }

        public Double() {
        }

        public Double(double d, double d2, double d3, double d4, double d5, double d6) {
            this.x1 = d;
            this.y1 = d2;
            this.ctrlx = d3;
            this.ctrly = d4;
            this.x2 = d5;
            this.y2 = d6;
        }
    }
}

