/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MetalProgressBarUI
extends BasicProgressBarUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalProgressBarUI();
    }

    public void paintDeterminate(Graphics graphics, JComponent jComponent) {
        super.paintDeterminate(graphics, jComponent);
        Color color = graphics.getColor();
        Insets insets = this.progressBar.getInsets();
        int n = this.progressBar.getWidth();
        int n2 = this.progressBar.getHeight();
        int n3 = this.progressBar.getOrientation();
        ColorUIResource colorUIResource = MetalLookAndFeel.getControlShadow();
        graphics.setColor(colorUIResource);
        graphics.drawLine(insets.left, insets.top, n - insets.right, insets.top);
        graphics.drawLine(insets.left, insets.top, insets.left, n2 - insets.bottom);
        int n4 = this.getAmountFull(insets, n, n2);
        if (n4 > 0) {
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControlDarkShadow();
            graphics.setColor(colorUIResource2);
            if (n3 == 0) {
                graphics.drawLine(insets.left, insets.top, insets.left, n2 - insets.bottom);
                graphics.drawLine(insets.left, insets.top, insets.left + n4 - 1, insets.top);
            } else {
                if (n4 >= n2 - insets.top - insets.bottom) {
                    graphics.drawLine(insets.left, insets.top, n - insets.right, insets.top);
                }
                graphics.drawLine(insets.left, n2 - insets.bottom, insets.left, n2 - insets.bottom - n4);
            }
        }
        graphics.setColor(color);
    }

    public void paintIndeterminate(Graphics graphics, JComponent jComponent) {
        super.paintIndeterminate(graphics, jComponent);
        Color color = graphics.getColor();
        Insets insets = this.progressBar.getInsets();
        int n = this.progressBar.getWidth();
        int n2 = this.progressBar.getHeight();
        ColorUIResource colorUIResource = MetalLookAndFeel.getControlShadow();
        graphics.setColor(colorUIResource);
        graphics.drawLine(insets.left, insets.top, n - insets.right, insets.top);
        graphics.drawLine(insets.left, insets.top, insets.left, n2 - insets.bottom);
        this.boxRect = this.getBox(this.boxRect);
        ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControlDarkShadow();
        graphics.setColor(colorUIResource2);
        int n3 = this.progressBar.getOrientation();
        if (n3 == 0) {
            graphics.drawLine(this.boxRect.x, insets.top, this.boxRect.x + this.boxRect.width - 1, insets.top);
        } else {
            graphics.drawLine(insets.left, this.boxRect.y, insets.left, this.boxRect.y + this.boxRect.height - 1);
        }
        graphics.setColor(color);
    }
}

