<?php

/**
 * BasePost
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                          $id                                 Type: integer, primary key
 * @property int                          $employee_number                    Type: integer(7)
 * @property string                       $text                               Type: string
 * @property string                       $post_time                          Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property string                       $updated_at                         Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property Employee                     $employeePostAdded                  
 * @property Doctrine_Collection|Photo[]  $photos                             
 * @property Doctrine_Collection|Link[]   $Links                              
 * @property Doctrine_Collection|Share[]  $share                              
 *  
 * @method int                            getId()                             Type: integer, primary key
 * @method int                            getEmployeeNumber()                 Type: integer(7)
 * @method string                         getText()                           Type: string
 * @method string                         getPostTime()                       Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method string                         getUpdatedAt()                      Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method Employee                       getEmployeePostAdded()              
 * @method Doctrine_Collection|Photo[]    getPhotos()                         
 * @method Doctrine_Collection|Link[]     getLinks()                          
 * @method Doctrine_Collection|Share[]    getShare()                          
 *  
 * @method Post                           setId(int $val)                     Type: integer, primary key
 * @method Post                           setEmployeeNumber(int $val)         Type: integer(7)
 * @method Post                           setText(string $val)                Type: string
 * @method Post                           setPostTime(string $val)            Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method Post                           setUpdatedAt(string $val)           Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method Post                           setEmployeePostAdded(Employee $val) 
 * @method Post                           setPhotos(Doctrine_Collection $val) 
 * @method Post                           setLinks(Doctrine_Collection $val)  
 * @method Post                           setShare(Doctrine_Collection $val)  
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BasePost extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_buzz_post');
        $this->hasColumn('id', 'integer', null, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => '',
             ));
        $this->hasColumn('employee_number', 'integer', 7, array(
             'type' => 'integer',
             'length' => 7,
             ));
        $this->hasColumn('text', 'string', null, array(
             'type' => 'string',
             'length' => '',
             ));
        $this->hasColumn('post_time', 'timestamp', null, array(
             'type' => 'timestamp',
             'notnull' => true,
             ));
        $this->hasColumn('updated_at', 'timestamp', null, array(
             'type' => 'timestamp',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Employee as employeePostAdded', array(
             'local' => 'employee_number',
             'foreign' => 'empNumber'));

        $this->hasMany('Photo as photos', array(
             'local' => 'id',
             'foreign' => 'post_id'));

        $this->hasMany('Link as Links', array(
             'local' => 'id',
             'foreign' => 'post_id'));

        $this->hasMany('Share as share', array(
             'local' => 'id',
             'foreign' => 'post_id'));
    }
}