/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Pointer;
import gnu.java.awt.peer.gtk.GtkClipboard;
import gnu.java.awt.peer.gtk.GtkImage;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StringBufferInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class GtkSelection
implements Transferable {
    private static Object requestLock = new Object();
    private final boolean clipboard;
    private boolean requestInProgress;
    private boolean mimeTypesDelivered;
    private DataFlavor[] dataFlavors;
    private boolean textDelivered;
    private String text;
    private boolean imageDelivered;
    private Pointer imagePointer;
    private Image image;
    private boolean urisDelivered;
    private List uris;
    private boolean bytesDelivered;
    private byte[] bytes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataFlavor[] getTransferDataFlavors() {
        var2_1 = GtkSelection.requestLock;
        synchronized (var2_1) {
            block11: {
                if (this.mimeTypesDelivered) {
                    return (DataFlavor[])this.dataFlavors.clone();
                }
                while (true) {
                    block12: {
                        if (this.requestInProgress) break block12;
                        if (this.mimeTypesDelivered) break block11;
                        this.requestInProgress = true;
                        this.requestMimeTypes(this.clipboard);
                        if (true) ** GOTO lbl26
                    }
                    try {
                        GtkSelection.requestLock.wait();
                    }
                    catch (InterruptedException v1) {}
                }
                do {
                    try {
                        GtkSelection.requestLock.wait();
                    }
                    catch (InterruptedException v2) {}
lbl26:
                    // 3 sources

                } while (!this.mimeTypesDelivered);
                this.requestInProgress = false;
            }
            var1_2 = this.dataFlavors;
            if (!GtkClipboard.canCache) {
                this.dataFlavors = null;
                this.mimeTypesDelivered = false;
            }
            GtkSelection.requestLock.notifyAll();
            return var1_2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void mimeTypesAvailable(String[] var1_1) {
        var2_2 = GtkSelection.requestLock;
        synchronized (var2_2) {
            block13: {
                block12: {
                    if (var1_1 != null) break block12;
                    this.dataFlavors = new DataFlavor[0];
                    break block13;
                }
                var4_3 = new ArrayList(var1_1.length + 1);
                var5_4 = 0;
                if (true) ** GOTO lbl46
            }
lbl14:
            // 2 sources

            while (true) {
                this.mimeTypesDelivered = true;
                GtkSelection.requestLock.notifyAll();
                return;
            }
            do {
                block14: {
                    try {
                        if (var1_1[var5_4] == GtkClipboard.stringMimeType) {
                            var4_3.add(DataFlavor.stringFlavor);
                            var4_3.add(DataFlavor.plainTextFlavor);
                            break block14;
                        }
                        if (var1_1[var5_4] == GtkClipboard.imageMimeType) {
                            var4_3.add(DataFlavor.imageFlavor);
                            break block14;
                        }
                        if (var1_1[var5_4] == GtkClipboard.filesMimeType) {
                            var4_3.add(DataFlavor.javaFileListFlavor);
                            break block14;
                        }
                        var6_5 = new DataFlavor(var1_1[var5_4]);
                        if (!var4_3.contains(var6_5)) {
                            var4_3.add(var6_5);
                        }
                    }
                    catch (ClassNotFoundException var6_6) {
                        var6_6.printStackTrace();
                    }
                    catch (NullPointerException var6_7) {
                        var6_7.printStackTrace();
                    }
                }
                ++var5_4;
lbl46:
                // 2 sources

            } while (var5_4 < var1_1.length);
            this.dataFlavors = new DataFlavor[var4_3.size()];
            var4_3.toArray(this.dataFlavors);
            ** continue;
        }
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (dataFlavor.equals(dataFlavorArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String getText() {
        var2_1 = GtkSelection.requestLock;
        synchronized (var2_1) {
            block11: {
                if (this.textDelivered) {
                    return this.text;
                }
                while (true) {
                    block12: {
                        if (this.requestInProgress) break block12;
                        if (this.textDelivered) break block11;
                        this.requestInProgress = true;
                        this.requestText(this.clipboard);
                        if (true) ** GOTO lbl26
                    }
                    try {
                        GtkSelection.requestLock.wait();
                    }
                    catch (InterruptedException v1) {}
                }
                do {
                    try {
                        GtkSelection.requestLock.wait();
                    }
                    catch (InterruptedException v2) {}
lbl26:
                    // 3 sources

                } while (!this.textDelivered);
                this.requestInProgress = false;
            }
            var1_2 = this.text;
            if (!GtkClipboard.canCache) {
                this.text = null;
                this.textDelivered = false;
            }
            GtkSelection.requestLock.notifyAll();
            return var1_2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void textAvailable(String string) {
        Object object = requestLock;
        synchronized (object) {
            this.text = string;
            this.textDelivered = true;
            requestLock.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Image getImage() {
        var2_1 = GtkSelection.requestLock;
        synchronized (var2_1) {
            block12: {
                if (this.imageDelivered) {
                    return this.image;
                }
                while (true) {
                    block13: {
                        if (this.requestInProgress) break block13;
                        if (this.imageDelivered) break block12;
                        this.requestInProgress = true;
                        this.requestImage(this.clipboard);
                        if (true) ** GOTO lbl26
                    }
                    try {
                        GtkSelection.requestLock.wait();
                    }
                    catch (InterruptedException v1) {}
                }
                do {
                    try {
                        GtkSelection.requestLock.wait();
                    }
                    catch (InterruptedException v2) {}
lbl26:
                    // 3 sources

                } while (!this.imageDelivered);
                this.requestInProgress = false;
            }
            if (this.imagePointer != null) {
                this.image = new GtkImage(this.imagePointer);
            }
            this.imagePointer = null;
            var1_2 = this.image;
            if (!GtkClipboard.canCache) {
                this.image = null;
                this.imageDelivered = false;
            }
            GtkSelection.requestLock.notifyAll();
            return var1_2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void imageAvailable(Pointer pointer) {
        Object object = requestLock;
        synchronized (object) {
            this.imagePointer = pointer;
            this.imageDelivered = true;
            requestLock.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final List getURIs() {
        var2_1 = GtkSelection.requestLock;
        synchronized (var2_1) {
            block11: {
                if (this.urisDelivered) {
                    return this.uris;
                }
                while (true) {
                    block12: {
                        if (this.requestInProgress) break block12;
                        if (this.urisDelivered) break block11;
                        this.requestInProgress = true;
                        this.requestURIs(this.clipboard);
                        if (true) ** GOTO lbl26
                    }
                    try {
                        GtkSelection.requestLock.wait();
                    }
                    catch (InterruptedException v1) {}
                }
                do {
                    try {
                        GtkSelection.requestLock.wait();
                    }
                    catch (InterruptedException v2) {}
lbl26:
                    // 3 sources

                } while (!this.urisDelivered);
                this.requestInProgress = false;
            }
            var1_2 = this.uris;
            if (!GtkClipboard.canCache) {
                this.uris = null;
                this.urisDelivered = false;
            }
            GtkSelection.requestLock.notifyAll();
            return var1_2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void urisAvailable(String[] stringArray) {
        Object object = requestLock;
        synchronized (object) {
            block8: {
                if (stringArray == null || stringArray.length == 0) break block8;
                ArrayList arrayList = new ArrayList(stringArray.length);
                int n = 0;
                while (true) {
                    if (n >= stringArray.length) {
                        this.uris = arrayList;
                        break;
                    }
                    try {
                        URI uRI = new URI(stringArray[n]);
                        if (uRI.getScheme().equals("file")) {
                            arrayList.add(new File(uRI));
                        }
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                    ++n;
                }
            }
            this.urisDelivered = true;
            requestLock.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final byte[] getBytes(String var1_1) {
        var3_2 = GtkSelection.requestLock;
        synchronized (var3_2) {
            while (true) {
                block9: {
                    if (this.requestInProgress) break block9;
                    this.requestInProgress = true;
                    this.requestBytes(this.clipboard, var1_1);
                    if (true) ** GOTO lbl23
                }
                try {
                    GtkSelection.requestLock.wait();
                }
                catch (InterruptedException v1) {}
            }
            do {
                try {
                    GtkSelection.requestLock.wait();
                }
                catch (InterruptedException v2) {}
lbl23:
                // 3 sources

            } while (!this.bytesDelivered);
            var2_3 = this.bytes;
            this.bytes = null;
            this.bytesDelivered = false;
            this.requestInProgress = false;
            GtkSelection.requestLock.notifyAll();
            return var2_3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void bytesAvailable(byte[] byArray) {
        Object object = requestLock;
        synchronized (object) {
            this.bytes = byArray;
            this.bytesDelivered = true;
            requestLock.notifyAll();
            return;
        }
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        Object object;
        if (dataFlavor.equals(DataFlavor.stringFlavor) && (object = this.getText()) != null) {
            return object;
        }
        if (dataFlavor.equals(DataFlavor.plainTextFlavor) && (object = this.getText()) != null) {
            return new StringBufferInputStream((String)object);
        }
        if (dataFlavor.equals(DataFlavor.imageFlavor) && (object = this.getImage()) != null) {
            return object;
        }
        if (dataFlavor.equals(DataFlavor.javaFileListFlavor) && (object = this.getURIs()) != null) {
            return object;
        }
        object = this.getBytes(dataFlavor.getMimeType());
        if (object == null) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        if (dataFlavor.isMimeTypeSerializedObject()) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                return objectInputStream.readObject();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        if (dataFlavor.isRepresentationClassInputStream()) {
            return new ByteArrayInputStream((byte[])object);
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    private final native void requestText(boolean var1);

    private final native void requestImage(boolean var1);

    private final native void requestURIs(boolean var1);

    private final native void requestBytes(boolean var1, String var2);

    private final native void requestMimeTypes(boolean var1);

    GtkSelection(GtkClipboard gtkClipboard) {
        boolean bl = false;
        if (gtkClipboard == GtkClipboard.clipboard) {
            bl = true;
        }
        this.clipboard = bl;
    }
}

