/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security;

import gnu.classpath.SystemProperties;
import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class PolicyFile
extends Policy {
    private static final Logger logger = SystemLogger.SYSTEM;
    private static final String DEFAULT_POLICY = SystemProperties.getProperty("java.home") + SystemProperties.getProperty("file.separator") + "lib" + SystemProperties.getProperty("file.separator") + "security" + SystemProperties.getProperty("file.separator") + "java.policy";
    private static final String DEFAULT_USER_POLICY = SystemProperties.getProperty("user.home") + SystemProperties.getProperty("file.separator") + ".java.policy";
    private static final int STATE_BEGIN = 0;
    private static final int STATE_GRANT = 1;
    private static final int STATE_PERMS = 2;
    private final Map cs2pc = new HashMap();
    static /* synthetic */ Class class$java$lang$String;

    public final PermissionCollection getPermissions(CodeSource codeSource) {
        Permissions permissions = new Permissions();
        Iterator iterator = this.cs2pc.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            CodeSource codeSource2 = (CodeSource)entry.getKey();
            if (codeSource2.implies(codeSource)) {
                logger.log((Level)Component.POLICY, "{0} -> {1}", new Object[]{codeSource2, codeSource});
                PermissionCollection permissionCollection = (PermissionCollection)entry.getValue();
                Enumeration enumeration = permissionCollection.elements();
                while (enumeration.hasMoreElements()) {
                    permissions.add((Permission)enumeration.nextElement());
                }
                continue;
            }
            logger.log((Level)Component.POLICY, "{0} !-> {1}", new Object[]{codeSource2, codeSource});
        }
        logger.log((Level)Component.POLICY, "returning permissions {0} for {1}", new Object[]{permissions, codeSource});
        return permissions;
    }

    public final void refresh() {
        this.cs2pc.clear();
        final LinkedList linkedList = new LinkedList();
        try {
            linkedList.add(new File(DEFAULT_POLICY).toURL());
            linkedList.add(new File(DEFAULT_USER_POLICY).toURL());
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public final Object run() throws Exception {
                    String string = Security.getProperty("policy.allowSystemProperty");
                    if (string == null || Boolean.getBoolean(string)) {
                        String string2 = SystemProperties.getProperty("java.security.policy");
                        logger.log((Level)Component.POLICY, "java.security.policy={0}", string2);
                        if (string2 != null) {
                            boolean bl = string2.startsWith("=");
                            if (bl) {
                                string2 = string2.substring(1);
                            }
                            linkedList.clear();
                            linkedList.add(new URL(string2));
                            if (bl) {
                                return null;
                            }
                        }
                    }
                    int n = 1;
                    while (true) {
                        String string3 = "policy.url." + n;
                        String string4 = Security.getProperty(string3);
                        logger.log((Level)Component.POLICY, "{0}={1}", new Object[]{string3, string4});
                        if (string4 == null) break;
                        linkedList.add(new URL(string4));
                        ++n;
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            logger.log((Level)Component.POLICY, "reading policy properties", privilegedActionException);
        }
        catch (MalformedURLException malformedURLException) {
            logger.log((Level)Component.POLICY, "setting default policies", malformedURLException);
        }
        logger.log((Level)Component.POLICY, "building policy from URLs {0}", linkedList);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            try {
                URL uRL = (URL)iterator.next();
                this.parse(uRL);
            }
            catch (IOException iOException) {
                logger.log((Level)Component.POLICY, "reading policy", iOException);
            }
        }
    }

    public final String toString() {
        return super.toString() + " [ " + this.cs2pc.toString() + " ]";
    }

    /*
     * Unable to fully structure code
     */
    private final void parse(URL var1_1) throws IOException {
        PolicyFile.logger.log((Level)Component.POLICY, "reading policy file from {0}", var1_1);
        var2_2 = new StreamTokenizer(new InputStreamReader(var1_1.openStream()));
        var2_2.resetSyntax();
        var2_2.slashSlashComments(true);
        var2_2.slashStarComments(true);
        var2_2.wordChars(65, 90);
        var2_2.wordChars(97, 122);
        var2_2.wordChars(48, 57);
        var2_2.wordChars(46, 46);
        var2_2.wordChars(95, 95);
        var2_2.wordChars(36, 36);
        var2_2.whitespaceChars(32, 32);
        var2_2.whitespaceChars(9, 9);
        var2_2.whitespaceChars(12, 12);
        var2_2.whitespaceChars(10, 10);
        var2_2.whitespaceChars(13, 13);
        var2_2.quoteChar(39);
        var2_2.quoteChar(34);
        var4_3 = 0;
        var5_4 = new LinkedList();
        var6_5 = null;
        var7_6 = new LinkedList();
        var8_7 = new Permissions();
        block26: while ((var3_8 = var2_2.nextToken()) != -1) {
            switch (var3_8) {
                case 123: {
                    if (var4_3 != 1) {
                        PolicyFile.error(var1_1, var2_2, "spurious '{'");
                    }
                    var4_3 = 2;
                    var3_8 = var2_2.nextToken();
                    ** GOTO lbl49
                }
                case 125: {
                    if (var4_3 != 2) {
                        PolicyFile.error(var1_1, var2_2, "spurious '}'");
                    }
                    var4_3 = 0;
                    var8_7.setReadOnly();
                    var9_9 = null;
                    if (!var7_6.isEmpty()) {
                        var9_9 = (Certificate[])var7_6.toArray(new Certificate[var7_6.size()]);
                    }
                    this.cs2pc.put(new CodeSource(var6_5, (Certificate[])var9_9), var8_7);
                    var7_6.clear();
                    var8_7 = new Permissions();
                    var6_5 = null;
                    var3_8 = var2_2.nextToken();
                    if (var3_8 == 59) continue block26;
                    var2_2.pushBack();
                    break;
                }
lbl49:
                // 2 sources

                default: {
                    if (var3_8 != -3) {
                        PolicyFile.error(var1_1, var2_2, "expecting word token");
                    }
                    if (var2_2.sval.equalsIgnoreCase("keystore")) {
                        var9_9 = KeyStore.getDefaultType();
                        var3_8 = var2_2.nextToken();
                        if (var3_8 != 34 && var3_8 != 39) {
                            PolicyFile.error(var1_1, var2_2, "expecting key store URL");
                        }
                        var10_10 = var2_2.sval;
                        var3_8 = var2_2.nextToken();
                        if (var3_8 == 44) {
                            var3_8 = var2_2.nextToken();
                            if (var3_8 != 34 && var3_8 != 39) {
                                PolicyFile.error(var1_1, var2_2, "expecting key store type");
                            }
                            var9_9 = var2_2.sval;
                            var3_8 = var2_2.nextToken();
                        }
                        if (var3_8 != 59) {
                            PolicyFile.error(var1_1, var2_2, "expecting semicolon");
                        }
                        try {
                            var11_12 = KeyStore.getInstance((String)var9_9);
                            var11_12.load(new URL(var1_1, (String)var10_10).openStream(), null);
                            var5_4.add(var11_12);
                        }
                        catch (Exception var11_13) {
                            PolicyFile.error(var1_1, var2_2, var11_13.toString());
                        }
                        continue block26;
                    }
                    if (var2_2.sval.equalsIgnoreCase("grant")) {
                        if (var4_3 != 0) {
                            PolicyFile.error(var1_1, var2_2, "extraneous grant keyword");
                        }
                        var4_3 = 1;
                        break;
                    }
                    if (var2_2.sval.equalsIgnoreCase("signedBy")) {
                        if (var4_3 != 1 && var4_3 != 2) {
                            PolicyFile.error(var1_1, var2_2, "spurious 'signedBy'");
                        }
                        if (var5_4.isEmpty()) {
                            PolicyFile.error(var1_1, var2_2, "'signedBy' with no keystores");
                        }
                        if ((var3_8 = var2_2.nextToken()) != 34 && var3_8 != 39) {
                            PolicyFile.error(var1_1, var2_2, "expecting signedBy name");
                        }
                        var9_9 = new StringTokenizer(var2_2.sval, ",");
                        while (var9_9.hasMoreTokens()) {
                            var10_10 = var9_9.nextToken();
                            var11_12 = var5_4.iterator();
                            while (var11_12.hasNext()) {
                                var12_16 = (KeyStore)var11_12.next();
                                try {
                                    if (!var12_16.isCertificateEntry((String)var10_10)) continue;
                                    var7_6.add(var12_16.getCertificate((String)var10_10));
                                }
                                catch (KeyStoreException var13_21) {
                                    PolicyFile.error(var1_1, var2_2, var13_21.toString());
                                }
                            }
                        }
                        var3_8 = var2_2.nextToken();
                        if (var3_8 == 44) continue block26;
                        if (var4_3 != 1) {
                            PolicyFile.error(var1_1, var2_2, "spurious ','");
                        }
                        var2_2.pushBack();
                        break;
                    }
                    if (var2_2.sval.equalsIgnoreCase("codeBase")) {
                        if (var4_3 != 1) {
                            PolicyFile.error(var1_1, var2_2, "spurious 'codeBase'");
                        }
                        if ((var3_8 = var2_2.nextToken()) != 34 && var3_8 != 39) {
                            PolicyFile.error(var1_1, var2_2, "expecting code base URL");
                        }
                        var9_9 = PolicyFile.expand(var2_2.sval);
                        if (File.separatorChar != '/') {
                            var9_9 = var9_9.replace(File.separatorChar, '/');
                        }
                        try {
                            var6_5 = new URL((String)var9_9);
                        }
                        catch (MalformedURLException var10_11) {
                            PolicyFile.error(var1_1, var2_2, var10_11.toString());
                        }
                        var3_8 = var2_2.nextToken();
                        if (var3_8 == 44) continue block26;
                        var2_2.pushBack();
                        break;
                    }
                    if (var2_2.sval.equalsIgnoreCase("principal")) {
                        if (var4_3 != 1) {
                            PolicyFile.error(var1_1, var2_2, "spurious 'principal'");
                        }
                        if ((var3_8 = var2_2.nextToken()) == -3) {
                            var3_8 = var2_2.nextToken();
                            if (var3_8 != 34 && var3_8 != 39) {
                                PolicyFile.error(var1_1, var2_2, "expecting principal name");
                            }
                            var9_9 = var2_2.sval;
                            var10_10 = null;
                            try {
                                var11_12 = Class.forName(var2_2.sval);
                                v0 = new Class[1];
                                v1 = PolicyFile.class$java$lang$String;
                                if (v1 == null) {
                                    v1 = PolicyFile.class("[Ljava.lang.String;", false);
                                }
                                v0[0] = v1;
                                var12_16 = var11_12.getConstructor(v0);
                                var10_10 = (Principal)var12_16.newInstance(new Object[]{var9_9});
                            }
                            catch (Exception var11_14) {
                                PolicyFile.error(var1_1, var2_2, var11_14.toString());
                            }
                            var11_12 = var5_4.iterator();
                            while (var11_12.hasNext()) {
                                var12_16 = (KeyStore)var11_12.next();
                                try {
                                    var13_20 = var12_16.aliases();
                                    while (var13_20.hasMoreElements()) {
                                        var14_24 = (String)var13_20.nextElement();
                                        if (!var12_16.isCertificateEntry(var14_24) || !((var15_25 = var12_16.getCertificate(var14_24)) instanceof X509Certificate) || !var10_10.equals(((X509Certificate)var15_25).getSubjectDN()) && !var10_10.equals(((X509Certificate)var15_25).getSubjectX500Principal())) continue;
                                        var7_6.add(var15_25);
                                    }
                                }
                                catch (KeyStoreException var13_22) {
                                    PolicyFile.error(var1_1, var2_2, var13_22.toString());
                                }
                            }
                        } else if (var3_8 == 34 || var3_8 == 39) {
                            var9_9 = var2_2.sval;
                            var10_10 = var5_4.iterator();
                            while (var10_10.hasNext()) {
                                var11_12 = (KeyStore)var10_10.next();
                                try {
                                    if (!var11_12.isCertificateEntry((String)var9_9)) continue;
                                    var7_6.add(var11_12.getCertificate((String)var9_9));
                                }
                                catch (KeyStoreException var12_17) {
                                    PolicyFile.error(var1_1, var2_2, var12_17.toString());
                                }
                            }
                        } else {
                            PolicyFile.error(var1_1, var2_2, "expecting principal");
                        }
                        var3_8 = var2_2.nextToken();
                        if (var3_8 == 44) continue block26;
                        var2_2.pushBack();
                        break;
                    }
                    if (!var2_2.sval.equalsIgnoreCase("permission")) continue block26;
                    if (var4_3 != 2) {
                        PolicyFile.error(var1_1, var2_2, "spurious 'permission'");
                    }
                    if ((var3_8 = var2_2.nextToken()) != -3) {
                        PolicyFile.error(var1_1, var2_2, "expecting permission class name");
                    }
                    var9_9 = var2_2.sval;
                    var10_10 = null;
                    try {
                        var10_10 = Class.forName((String)var9_9);
                    }
                    catch (ClassNotFoundException v2) {}
                    var3_8 = var2_2.nextToken();
                    if (var3_8 == 59) {
                        if (var10_10 == null) {
                            var8_7.add(new UnresolvedPermission((String)var9_9, null, null, (Certificate[])var7_6.toArray(new Certificate[var7_6.size()])));
                            break;
                        }
                        try {
                            var8_7.add((Permission)var10_10.newInstance());
                        }
                        catch (Exception var11_15) {
                            PolicyFile.error(var1_1, var2_2, var11_15.toString());
                        }
                        continue block26;
                    }
                    if (var3_8 != 34 && var3_8 != 39) {
                        PolicyFile.error(var1_1, var2_2, "expecting permission target");
                    }
                    var11_12 = PolicyFile.expand(var2_2.sval);
                    var3_8 = var2_2.nextToken();
                    if (var3_8 == 59) {
                        if (var10_10 == null) {
                            var8_7.add(new UnresolvedPermission((String)var9_9, (String)var11_12, null, (Certificate[])var7_6.toArray(new Certificate[var7_6.size()])));
                            break;
                        }
                        try {
                            v3 = new Class[1];
                            v4 = PolicyFile.class$java$lang$String;
                            if (v4 == null) {
                                v4 = PolicyFile.class("[Ljava.lang.String;", false);
                            }
                            v3[0] = v4;
                            var12_16 = var10_10.getConstructor(v3);
                            var8_7.add((Permission)var12_16.newInstance(new Object[]{var11_12}));
                        }
                        catch (Exception var12_18) {
                            PolicyFile.error(var1_1, var2_2, var12_18.toString());
                        }
                        continue block26;
                    }
                    if (var3_8 != 44) {
                        PolicyFile.error(var1_1, var2_2, "expecting ','");
                    }
                    if ((var3_8 = var2_2.nextToken()) == -3) {
                        if (!var2_2.sval.equalsIgnoreCase("signedBy")) {
                            PolicyFile.error(var1_1, var2_2, "expecting 'signedBy'");
                        }
                        try {
                            v5 = new Class[1];
                            v6 = PolicyFile.class$java$lang$String;
                            if (v6 == null) {
                                v6 = PolicyFile.class("[Ljava.lang.String;", false);
                            }
                            v5[0] = v6;
                            var12_16 = var10_10.getConstructor(v5);
                            var8_7.add((Permission)var12_16.newInstance(new Object[]{var11_12}));
                        }
                        catch (Exception var12_19) {
                            PolicyFile.error(var1_1, var2_2, var12_19.toString());
                        }
                        var2_2.pushBack();
                        break;
                    }
                    if (var3_8 != 34 && var3_8 != 39) {
                        PolicyFile.error(var1_1, var2_2, "expecting permission action");
                    }
                    var12_16 = var2_2.sval;
                    if (var10_10 == null) {
                        var8_7.add(new UnresolvedPermission((String)var9_9, (String)var11_12, (String)var12_16, (Certificate[])var7_6.toArray(new Certificate[var7_6.size()])));
                        break;
                    }
                    try {
                        v7 = new Class[2];
                        v8 = PolicyFile.class$java$lang$String;
                        if (v8 == null) {
                            v8 = v7[0] = PolicyFile.class("[Ljava.lang.String;", false);
                        }
                        if ((v9 = PolicyFile.class$java$lang$String) == null) {
                            v9 = PolicyFile.class("[Ljava.lang.String;", false);
                        }
                        v7[1] = v9;
                        var13_20 = var10_10.getConstructor(v7);
                        var8_7.add((Permission)var13_20.newInstance(new Object[]{var11_12, var12_16}));
                    }
                    catch (Exception var13_23) {
                        PolicyFile.error(var1_1, var2_2, var13_23.toString());
                    }
                    var3_8 = var2_2.nextToken();
                    if (var3_8 == 59 || var3_8 == 44) continue block26;
                    PolicyFile.error(var1_1, var2_2, "expecting ';' or ','");
                }
            }
        }
    }

    private static final String expand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            switch (n) {
                case 0: {
                    if (string.charAt(n2) == '$') {
                        n = 1;
                        break;
                    }
                    stringBuffer.append(string.charAt(n2));
                    break;
                }
                case 1: {
                    if (string.charAt(n2) == '{') {
                        n = 2;
                        break;
                    }
                    n = 0;
                    stringBuffer.append('$').append(string.charAt(n2));
                    break;
                }
                case 2: {
                    if (string.charAt(n2) == '}') {
                        String string2 = stringBuffer2.toString();
                        if (string2.equals("/")) {
                            string2 = "file.separator";
                        }
                        if ((string2 = System.getProperty(string2)) == null) {
                            string2 = "";
                        }
                        stringBuffer.append(string2);
                        stringBuffer2.setLength(0);
                        n = 0;
                        break;
                    }
                    stringBuffer2.append(string.charAt(n2));
                    break;
                }
            }
            ++n2;
        }
        if (n != 0) {
            stringBuffer.append('$').append('{').append(stringBuffer2);
        }
        return stringBuffer.toString();
    }

    private static final void error(URL uRL, StreamTokenizer streamTokenizer, String string) throws IOException {
        throw new IOException(uRL + ':' + streamTokenizer.lineno() + ": " + string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public PolicyFile() {
        this.refresh();
    }
}

