/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.math.BigInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class IndexColorModel
extends ColorModel {
    private int map_size;
    private boolean opaque;
    private int trans;
    private int[] rgb;
    private BigInteger validBits;

    public final int getMapSize() {
        return this.map_size;
    }

    public final int getTransparentPixel() {
        return this.trans;
    }

    public final void getReds(byte[] byArray) {
        int n = 0;
        while (n < this.map_size) {
            byArray[n] = (byte)((0xFF0000 & this.rgb[n]) >> 16);
            ++n;
        }
    }

    public final void getGreens(byte[] byArray) {
        int n = 0;
        while (n < this.map_size) {
            byArray[n] = (byte)((0xFF00 & this.rgb[n]) >> 8);
            ++n;
        }
    }

    public final void getBlues(byte[] byArray) {
        int n = 0;
        while (n < this.map_size) {
            byArray[n] = (byte)(0xFF & this.rgb[n]);
            ++n;
        }
    }

    public final void getAlphas(byte[] byArray) {
        int n = 0;
        while (n < this.map_size) {
            byArray[n] = n == this.trans ? (byte)0 : (byte)((0xFF000000 & this.rgb[n]) >> 24);
            ++n;
        }
    }

    public final int getRed(int n) {
        if (n < this.map_size) {
            return (0xFF0000 & this.rgb[n]) >> 16;
        }
        return 0;
    }

    public final int getGreen(int n) {
        if (n < this.map_size) {
            return (0xFF00 & this.rgb[n]) >> 8;
        }
        return 0;
    }

    public final int getBlue(int n) {
        if (n < this.map_size) {
            return 0xFF & this.rgb[n];
        }
        return 0;
    }

    public final int getAlpha(int n) {
        if (this.opaque && n != this.trans) {
            return 255;
        }
        if (n == this.trans && this.trans != -1 || n >= this.map_size) {
            return 0;
        }
        return (0xFF000000 & this.rgb[n]) >> 24;
    }

    public final int getRGB(int n) {
        if (n >= 0 && n < this.map_size) {
            return this.rgb[n];
        }
        return 0;
    }

    public final void getRGBs(int[] nArray) {
        System.arraycopy(this.rgb, 0, nArray, 0, this.map_size);
    }

    public boolean isValid(int n) {
        if (n >= 0) {
            return this.validBits.testBit(n);
        }
        return false;
    }

    public boolean isValid() {
        BigInteger bigInteger = new BigInteger("0");
        bigInteger = bigInteger.setBit(this.map_size);
        bigInteger = bigInteger.subtract(new BigInteger("1"));
        return bigInteger.equals(this.validBits);
    }

    public BigInteger getValidPixels() {
        return this.validBits;
    }

    public BufferedImage convertToIntDiscrete(Raster raster, boolean bl) {
        int n;
        if (bl) {
            n = 2;
        } else {
            int n2 = 0;
            if (this.opaque && this.trans == -1) {
                n2 = 1;
            }
            n = 2 - n2;
        }
        int n3 = n;
        BufferedImage bufferedImage = new BufferedImage(raster.width, raster.height, n3);
        int n4 = raster.minX;
        while (n4 < raster.width + raster.minX) {
            int n5 = raster.minY;
            while (n5 < raster.height + raster.minY) {
                bufferedImage.setRGB(n4, n5, this.rgb[raster.getSample(n4, n5, 0)]);
                ++n5;
            }
            ++n4;
        }
        return bufferedImage;
    }

    private final /* synthetic */ void this() {
        this.trans = -1;
        this.validBits = BigInteger.ZERO;
    }

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this(n, n2, byArray, byArray2, byArray3, null);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, int n3) {
        int n4 = 0;
        if (n3 >= 0 && n3 < n2) {
            n4 = 1;
        }
        int[] nArray = IndexColorModel.nArray(8, n4 + 3);
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        boolean bl = false;
        if (n3 >= 0 && n3 < n2) {
            bl = true;
        }
        super(n, nArray, colorSpace, bl, false, 1, Buffers.smallestAppropriateTransferType(n));
        this.this();
        if (n < 1) {
            throw new IllegalArgumentException("bits < 1");
        }
        if (n > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = n2;
        if (n3 >= 0 && n3 < n2) {
            this.trans = n3;
            this.transparency = 2;
        }
        this.rgb = new int[n2];
        int n5 = 0;
        while (n5 < n2) {
            this.rgb[n5] = 0xFF000000 | (byArray[n5] & 0xFF) << 16 | (byArray2[n5] & 0xFF) << 8 | byArray3[n5] & 0xFF;
            ++n5;
        }
        this.validBits = this.validBits.setBit(n2).subtract(BigInteger.ONE);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        int n3 = 0;
        if (byArray4 == null) {
            n3 = 1;
        }
        int[] nArray = IndexColorModel.nArray(8, 4 - n3);
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        boolean bl = false;
        if (byArray4 != null) {
            bl = true;
        }
        super(n, nArray, colorSpace, bl, false, 3, Buffers.smallestAppropriateTransferType(n));
        this.this();
        if (n < 1) {
            throw new IllegalArgumentException("bits < 1");
        }
        if (n > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = n2;
        boolean bl2 = false;
        if (byArray4 == null) {
            bl2 = true;
        }
        this.opaque = bl2;
        this.rgb = new int[n2];
        if (byArray4 == null) {
            int n4 = 0;
            while (n4 < n2) {
                this.rgb[n4] = 0xFF000000 | (byArray[n4] & 0xFF) << 16 | (byArray2[n4] & 0xFF) << 8 | byArray3[n4] & 0xFF;
                ++n4;
            }
            this.transparency = 1;
        } else {
            byte by = 0;
            int n5 = -1;
            int n6 = 0;
            while (n6 < n2) {
                by = (byte)(by | byArray4[n6]);
                n5 = (byte)(n5 & byArray4[n6]);
                this.rgb[n6] = (byArray4[n6] & 0xFF) << 24 | (byArray[n6] & 0xFF) << 16 | (byArray2[n6] & 0xFF) << 8 | byArray3[n6] & 0xFF;
                ++n6;
            }
            this.transparency = by == 0 || n5 == -1 ? 2 : 3;
        }
        this.validBits = this.validBits.setBit(n2).subtract(BigInteger.ONE);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, int n3, boolean bl) {
        this(n, n2, byArray, n3, bl, -1);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, int n3, boolean bl, int n4) {
        int n5 = 0;
        if (bl || n4 >= 0 && n4 < n2) {
            n5 = 1;
        }
        int[] nArray = IndexColorModel.nArray(8, n5 + 3);
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        boolean bl2 = false;
        if (bl || n4 >= 0 && n4 < n2) {
            bl2 = true;
        }
        super(n, nArray, colorSpace, bl2, false, 1, Buffers.smallestAppropriateTransferType(n));
        this.this();
        if (n < 1) {
            throw new IllegalArgumentException("bits < 1");
        }
        if (n > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = n2;
        this.opaque = bl ^ true;
        if (n4 >= 0 && n4 < n2) {
            this.trans = n4;
        }
        this.rgb = new int[n2];
        if (bl) {
            int n6 = 0;
            int n7 = 255;
            int n8 = 0;
            while (n8 < n2) {
                int n9 = byArray[4 * n8 + 3 + n3] & 0xFF;
                n6 |= n9;
                n7 &= n9;
                this.rgb[n8] = n9 << 24 | (byArray[4 * n8 + n3] & 0xFF) << 16 | (byArray[4 * n8 + 1 + n3] & 0xFF) << 8 | byArray[4 * n8 + 2 + n3] & 0xFF;
                ++n8;
            }
            if (n6 == 0) {
                this.transparency = 2;
            } else if (n7 == 255) {
                int n10 = 0;
                if (n4 != -1) {
                    n10 = 1;
                }
                this.transparency = n10 + 1;
            } else {
                this.transparency = 3;
            }
        } else {
            int n11 = 0;
            while (n11 < n2) {
                this.rgb[n11] = 0xFF000000 | (byArray[3 * n11 + n3] & 0xFF) << 16 | (byArray[3 * n11 + 1 + n3] & 0xFF) << 8 | byArray[3 * n11 + 2 + n3] & 0xFF;
                ++n11;
            }
            if (n4 != -1) {
                this.transparency = 2;
            }
        }
        this.validBits = this.validBits.setBit(n2).subtract(BigInteger.ONE);
    }

    public IndexColorModel(int n, int n2, int[] nArray, int n3, boolean bl, int n4, int n5) {
        super(n, IndexColorModel.nArray(8, 4), ColorSpace.getInstance(1000), true, false, 3, n5);
        this.this();
        if (n5 != 0 && n5 != 1) {
            throw new IllegalArgumentException();
        }
        if (n > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = n2;
        this.opaque = bl ^ true;
        if (n4 >= 0 && n4 < n2) {
            this.trans = n4;
        }
        this.rgb = new int[n2];
        if (!bl) {
            int n6 = 0;
            while (n6 < n2) {
                this.rgb[n6] = nArray[n6 + n3] | 0xFF000000;
                ++n6;
            }
        } else {
            System.arraycopy(nArray, n3, this.rgb, 0, n2);
        }
        this.validBits = this.validBits.setBit(n2).subtract(BigInteger.ONE);
    }

    public IndexColorModel(int n, int n2, int[] nArray, int n3, int n4, BigInteger bigInteger) {
        super(n, IndexColorModel.nArray(8, 4), ColorSpace.getInstance(1000), true, false, 3, n4);
        this.this();
        if (n4 != 0 && n4 != 1) {
            throw new IllegalArgumentException();
        }
        if (n > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = n2;
        this.opaque = false;
        this.trans = -1;
        this.validBits = bigInteger;
        this.rgb = new int[n2];
        if (!this.hasAlpha) {
            int n5 = 0;
            while (n5 < n2) {
                this.rgb[n5] = nArray[n5 + n3] | 0xFF000000;
                ++n5;
            }
        } else {
            System.arraycopy(nArray, n3, this.rgb, 0, n2);
        }
    }
}

